/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.scaffolding;

import com.lothrazar.cyclic.base.BlockBase;
import com.lothrazar.cyclic.registry.SoundRegistry;
import com.lothrazar.cyclic.util.UtilEntity;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BlockScaffolding
extends BlockBase {
    private static final double CLIMB_SPEED = 0.31;
    private static final double OFFSET = 0.0125;
    protected static final VoxelShape AABB = Block.func_208617_a((double)0.2, (double)0.0, (double)0.2, (double)15.8, (double)1.0, (double)15.8);
    private boolean doesAutobreak = true;

    public BlockScaffolding(AbstractBlock.Properties properties, boolean autobreak) {
        super(properties.func_200943_b(0.1f).func_200944_c().harvestLevel(0).func_226896_b_().func_200947_a(SoundRegistry.SCAFFOLD));
        this.doesAutobreak = autobreak;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void registerClient() {
        RenderTypeLookup.setRenderLayer((Block)this, (RenderType)RenderType.func_228643_e_());
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return AABB;
    }

    @Deprecated
    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        if (this.doesAutobreak && worldIn.field_73012_v.nextDouble() < 0.5) {
            worldIn.func_175655_b(pos, true);
        }
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        if (!(entityIn instanceof LivingEntity)) {
            return;
        }
        LivingEntity entity = (LivingEntity)entityIn;
        if (!entityIn.field_70123_F) {
            return;
        }
        UtilEntity.tryMakeEntityClimb(worldIn, entity, 0.31);
    }
}

