/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.shapebuilder;

import com.lothrazar.cyclic.ModCyclic;
import com.lothrazar.cyclic.block.shapebuilder.TileStructure;
import com.lothrazar.cyclic.render.FakeBlockRenderTypes;
import com.lothrazar.cyclic.util.UtilRender;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.awt.Color;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

@OnlyIn(value=Dist.CLIENT)
public class RenderStructure
extends TileEntityRenderer<TileStructure> {
    public RenderStructure(TileEntityRendererDispatcher d) {
        super(d);
    }

    public void render(TileStructure te, float v, MatrixStack matrix, IRenderTypeBuffer ibuffer, int partialTicks, int destroyStage) {
        IItemHandler inv = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElse(null);
        if (inv == null) {
            return;
        }
        if (1 == te.getField(TileStructure.Fields.RENDER.ordinal())) {
            ItemStack stack = inv.getStackInSlot(0);
            if (stack.func_190926_b()) {
                this.renderOutline(te, matrix);
            } else {
                this.renderBlank(te, matrix, stack);
            }
        }
    }

    private void renderBlank(TileStructure te, MatrixStack matrix, ItemStack stack) {
        World world = ModCyclic.proxy.getClientWorld();
        BlockState renderBlockState = Block.func_149634_a((Item)stack.func_77973_b()).func_176223_P();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(PlayerContainer.field_226615_c_);
        double range = 6.0;
        BlockRayTraceResult lookingAt = (BlockRayTraceResult)ModCyclic.proxy.getClientPlayer().func_213324_a(range, 0.0f, false);
        if (world.func_175623_d(lookingAt.func_216350_a())) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        IRenderTypeBuffer.Impl buffer = mc.func_228019_au_().func_228487_b_();
        IVertexBuilder builder = buffer.getBuffer(FakeBlockRenderTypes.FAKE_BLOCK);
        BlockRendererDispatcher dispatcher = mc.func_175602_ab();
        matrix.func_227860_a_();
        BlockPos playerPos = te.func_174877_v();
        matrix.func_227861_a_((double)(-playerPos.func_177958_n()), (double)(-playerPos.func_177956_o()), (double)(-playerPos.func_177952_p()));
        for (BlockPos coordinate : te.getShape()) {
            if (!world.func_175623_d(coordinate)) continue;
            float x = coordinate.func_177958_n();
            float y = coordinate.func_177956_o();
            float z = coordinate.func_177952_p();
            matrix.func_227860_a_();
            matrix.func_227861_a_((double)x, (double)y, (double)z);
            matrix.func_227861_a_((double)-5.0E-4f, (double)-5.0E-4f, (double)-5.0E-4f);
            matrix.func_227862_a_(1.001f, 1.001f, 1.001f);
            IBakedModel ibakedmodel = dispatcher.func_184389_a(renderBlockState);
            BlockColors blockColors = Minecraft.func_71410_x().func_184125_al();
            int color = blockColors.func_228054_a_(renderBlockState, (IBlockDisplayReader)world, coordinate, 0);
            float red = (float)(color >> 16 & 0xFF) / 255.0f;
            float green = (float)(color >> 8 & 0xFF) / 255.0f;
            float blue = (float)(color & 0xFF) / 255.0f;
            float alpha = 0.7f;
            if (renderBlockState.func_185901_i() == BlockRenderType.MODEL) {
                for (Direction direction : Direction.values()) {
                    UtilRender.renderModelBrightnessColorQuads(matrix.func_227866_c_(), builder, red, green, blue, alpha, ibakedmodel.getQuads(renderBlockState, direction, new Random(MathHelper.func_180186_a((Vector3i)coordinate)), (IModelData)EmptyModelData.INSTANCE), 0xF00000, 327680);
                }
                UtilRender.renderModelBrightnessColorQuads(matrix.func_227866_c_(), builder, red, green, blue, alpha, ibakedmodel.getQuads(renderBlockState, null, new Random(MathHelper.func_180186_a((Vector3i)coordinate)), (IModelData)EmptyModelData.INSTANCE), 0xF00000, 655360);
            }
            matrix.func_227865_b_();
        }
        matrix.func_227865_b_();
    }

    private void renderOutline(TileStructure te, MatrixStack matrix) {
        Minecraft mc = Minecraft.func_71410_x();
        IRenderTypeBuffer.Impl buffer = mc.func_228019_au_().func_228487_b_();
        World world = ModCyclic.proxy.getClientWorld();
        List<BlockPos> coords = te.getShape();
        matrix.func_227860_a_();
        BlockPos view = te.func_174877_v();
        matrix.func_227861_a_((double)(-view.func_177958_n()), (double)(-view.func_177956_o()), (double)(-view.func_177952_p()));
        IVertexBuilder builder = buffer.getBuffer(FakeBlockRenderTypes.SOLID_COLOUR);
        for (BlockPos e : coords) {
            if (!world.func_175623_d(e)) continue;
            matrix.func_227860_a_();
            matrix.func_227861_a_((double)e.func_177958_n(), (double)e.func_177956_o(), (double)e.func_177952_p());
            matrix.func_227861_a_((double)-0.005f, (double)-0.005f, (double)-0.005f);
            float scale = 0.7f;
            matrix.func_227862_a_(scale, scale, scale);
            matrix.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-90.0f));
            Matrix4f positionMatrix = matrix.func_227866_c_().func_227870_a_();
            Color color = Color.BLUE;
            UtilRender.renderCube(positionMatrix, builder, e, color);
            matrix.func_227865_b_();
        }
        matrix.func_227865_b_();
        buffer.func_228462_a_(FakeBlockRenderTypes.SOLID_COLOUR);
    }
}

