/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.solidifier;

import com.lothrazar.cyclic.ModCyclic;
import com.lothrazar.cyclic.base.TileEntityBase;
import com.lothrazar.cyclic.block.solidifier.TileSolidifier;
import com.lothrazar.cyclic.fluid.FluidBiomassHolder;
import com.lothrazar.cyclic.fluid.FluidHoneyHolder;
import com.lothrazar.cyclic.fluid.FluidMagmaHolder;
import com.lothrazar.cyclic.fluid.FluidSlimeHolder;
import com.lothrazar.cyclic.fluid.FluidXpJuiceHolder;
import com.lothrazar.cyclic.recipe.CyclicRecipe;
import com.lothrazar.cyclic.recipe.CyclicRecipeType;
import com.lothrazar.cyclic.registry.BlockRegistry;
import com.lothrazar.cyclic.registry.ItemRegistry;
import com.lothrazar.cyclic.util.UtilItemStack;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Blocks;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;

public class RecipeSolidifier<TileEntityBase>
extends CyclicRecipe {
    public static List<RecipeSolidifier> RECIPES = new ArrayList<RecipeSolidifier>();
    private ItemStack result = ItemStack.field_190927_a;
    private NonNullList<Ingredient> ingredients = NonNullList.func_191196_a();
    private FluidStack fluidInput;
    private static Set<String> hashes = new HashSet<String>();

    private RecipeSolidifier(ResourceLocation id, FluidStack fluid, ItemStack result) {
        super(id);
        this.result = result;
        this.fluidInput = fluid;
    }

    private RecipeSolidifier(ResourceLocation id, ItemStack in, ItemStack inSecond, ItemStack inThird, FluidStack fluid, ItemStack result) {
        this(id, fluid, result);
        this.ingredients.add((Object)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{in}));
        this.ingredients.add((Object)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{inSecond}));
        this.ingredients.add((Object)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{inThird}));
    }

    public boolean matches(TileEntityBase inv, World worldIn) {
        try {
            TileSolidifier tile = (TileSolidifier)inv;
            if (tile.getFluid() != null && tile.getFluid().getFluid() == this.fluidInput.getFluid()) {
                return this.matches(tile, 0) && this.matches(tile, 1) && this.matches(tile, 2);
            }
            return false;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public boolean matches(TileSolidifier tile, int slot) {
        ItemStack current = tile.getStackInputSlot(slot);
        Ingredient ing = (Ingredient)this.ingredients.get(slot);
        for (ItemStack test : ing.func_193365_a()) {
            if (!UtilItemStack.matches(current, test)) continue;
            return true;
        }
        return false;
    }

    public NonNullList<Ingredient> func_192400_c() {
        return this.ingredients;
    }

    public ItemStack[] ingredientAt(int slot) {
        Ingredient ing = (Ingredient)this.ingredients.get(slot);
        return ing.func_193365_a();
    }

    @Override
    public ItemStack func_77571_b() {
        return this.result.func_77946_l();
    }

    @Override
    public FluidStack getRecipeFluid() {
        return this.fluidInput.copy();
    }

    public IRecipeType<?> func_222127_g() {
        return CyclicRecipeType.SOLID;
    }

    public static void initAllRecipes() {
        hashes = new HashSet<String>();
        RecipeSolidifier.addRecipe("clay", new ItemStack((IItemProvider)Blocks.field_150405_ch), new ItemStack((IItemProvider)Blocks.field_150405_ch), new ItemStack((IItemProvider)Blocks.field_150405_ch), new FluidStack((Fluid)Fluids.field_204546_a, 50), new ItemStack((IItemProvider)Blocks.field_150435_aG, 2));
        RecipeSolidifier.addRecipe("patn", new ItemStack((IItemProvider)Blocks.field_196658_i), new ItemStack((IItemProvider)Blocks.field_196658_i), new ItemStack((IItemProvider)Blocks.field_196658_i), new FluidStack((Fluid)Fluids.field_204546_a, 10), new ItemStack((IItemProvider)Blocks.field_185774_da, 2));
        RecipeSolidifier.addRecipe("bush", new ItemStack((IItemProvider)Blocks.field_196554_aH), new ItemStack((IItemProvider)Blocks.field_196554_aH), new ItemStack((IItemProvider)Blocks.field_196554_aH), new FluidStack((Fluid)Fluids.field_204546_a, 10), new ItemStack((IItemProvider)Blocks.field_196555_aI, 3));
        RecipeSolidifier.addRecipe("btube_coral", new ItemStack((IItemProvider)Blocks.field_204404_jE), new ItemStack((IItemProvider)Blocks.field_203963_jE), new ItemStack((IItemProvider)Blocks.field_204404_jE), new FluidStack((Fluid)Fluids.field_204546_a, 100), new ItemStack((IItemProvider)Blocks.field_203963_jE, 3));
        RecipeSolidifier.addRecipe("bbraincoral", new ItemStack((IItemProvider)Blocks.field_204405_jF), new ItemStack((IItemProvider)Blocks.field_203964_jF), new ItemStack((IItemProvider)Blocks.field_204405_jF), new FluidStack((Fluid)Fluids.field_204546_a, 100), new ItemStack((IItemProvider)Blocks.field_203964_jF, 3));
        RecipeSolidifier.addRecipe("bbubblecoral", new ItemStack((IItemProvider)Blocks.field_204406_jG), new ItemStack((IItemProvider)Blocks.field_203965_jG), new ItemStack((IItemProvider)Blocks.field_204406_jG), new FluidStack((Fluid)Fluids.field_204546_a, 100), new ItemStack((IItemProvider)Blocks.field_203965_jG, 3));
        RecipeSolidifier.addRecipe("bfirecoral", new ItemStack((IItemProvider)Blocks.field_204407_jH), new ItemStack((IItemProvider)Blocks.field_203966_jH), new ItemStack((IItemProvider)Blocks.field_204407_jH), new FluidStack((Fluid)Fluids.field_204546_a, 100), new ItemStack((IItemProvider)Blocks.field_203966_jH, 3));
        RecipeSolidifier.addRecipe("bhorncoral", new ItemStack((IItemProvider)Blocks.field_204408_jI), new ItemStack((IItemProvider)Blocks.field_203967_jI), new ItemStack((IItemProvider)Blocks.field_204408_jI), new FluidStack((Fluid)Fluids.field_204546_a, 100), new ItemStack((IItemProvider)Blocks.field_203967_jI, 3));
        RecipeSolidifier.addRecipe("braincoraltube", new ItemStack((IItemProvider)Blocks.field_212585_jY), new ItemStack((IItemProvider)Blocks.field_204278_jJ), new ItemStack((IItemProvider)Blocks.field_212585_jY), new FluidStack((Fluid)Fluids.field_204546_a, 100), new ItemStack((IItemProvider)Blocks.field_204278_jJ, 3));
        RecipeSolidifier.addRecipe("braincoral", new ItemStack((IItemProvider)Blocks.field_212586_jZ), new ItemStack((IItemProvider)Blocks.field_204279_jK), new ItemStack((IItemProvider)Blocks.field_212586_jZ), new FluidStack((Fluid)Fluids.field_204546_a, 100), new ItemStack((IItemProvider)Blocks.field_204279_jK, 3));
        RecipeSolidifier.addRecipe("bubblecoral", new ItemStack((IItemProvider)Blocks.field_212587_ka), new ItemStack((IItemProvider)Blocks.field_204280_jL), new ItemStack((IItemProvider)Blocks.field_212587_ka), new FluidStack((Fluid)Fluids.field_204546_a, 100), new ItemStack((IItemProvider)Blocks.field_204280_jL, 3));
        RecipeSolidifier.addRecipe("firecoral", new ItemStack((IItemProvider)Blocks.field_212588_kb), new ItemStack((IItemProvider)Blocks.field_204281_jM), new ItemStack((IItemProvider)Blocks.field_212588_kb), new FluidStack((Fluid)Fluids.field_204546_a, 100), new ItemStack((IItemProvider)Blocks.field_204281_jM, 3));
        RecipeSolidifier.addRecipe("hornecoral", new ItemStack((IItemProvider)Blocks.field_212589_kc), new ItemStack((IItemProvider)Blocks.field_204282_jN), new ItemStack((IItemProvider)Blocks.field_212589_kc), new FluidStack((Fluid)Fluids.field_204546_a, 100), new ItemStack((IItemProvider)Blocks.field_204282_jN, 3));
        RecipeSolidifier.addRecipe("brainffaltube", new ItemStack((IItemProvider)Blocks.field_211901_kp), new ItemStack((IItemProvider)Blocks.field_204743_jR), new ItemStack((IItemProvider)Blocks.field_211901_kp), new FluidStack((Fluid)Fluids.field_204546_a, 100), new ItemStack((IItemProvider)Blocks.field_204743_jR, 3));
        RecipeSolidifier.addRecipe("braincoralfa", new ItemStack((IItemProvider)Blocks.field_211902_kq), new ItemStack((IItemProvider)Blocks.field_204744_jS), new ItemStack((IItemProvider)Blocks.field_211902_kq), new FluidStack((Fluid)Fluids.field_204546_a, 100), new ItemStack((IItemProvider)Blocks.field_204744_jS, 3));
        RecipeSolidifier.addRecipe("bubblecoralfan", new ItemStack((IItemProvider)Blocks.field_211903_kr), new ItemStack((IItemProvider)Blocks.field_204745_jT), new ItemStack((IItemProvider)Blocks.field_211903_kr), new FluidStack((Fluid)Fluids.field_204546_a, 100), new ItemStack((IItemProvider)Blocks.field_204745_jT, 3));
        RecipeSolidifier.addRecipe("firecoralfan", new ItemStack((IItemProvider)Blocks.field_211904_ks), new ItemStack((IItemProvider)Blocks.field_204746_jU), new ItemStack((IItemProvider)Blocks.field_211904_ks), new FluidStack((Fluid)Fluids.field_204546_a, 100), new ItemStack((IItemProvider)Blocks.field_204746_jU, 3));
        RecipeSolidifier.addRecipe("horncoralfann", new ItemStack((IItemProvider)Blocks.field_211905_kt), new ItemStack((IItemProvider)Blocks.field_204747_jV), new ItemStack((IItemProvider)Blocks.field_211905_kt), new FluidStack((Fluid)Fluids.field_204546_a, 100), new ItemStack((IItemProvider)Blocks.field_204747_jV, 3));
        RecipeSolidifier.addRecipe("bbbconcrete", new ItemStack((IItemProvider)Blocks.field_196884_jh), new ItemStack((IItemProvider)Blocks.field_196884_jh), new ItemStack((IItemProvider)Blocks.field_196884_jh), new FluidStack((Fluid)Fluids.field_204546_a, 10), new ItemStack((IItemProvider)Blocks.field_196858_iR, 3));
        RecipeSolidifier.addRecipe("wconcrete", new ItemStack((IItemProvider)Blocks.field_196860_iS), new ItemStack((IItemProvider)Blocks.field_196860_iS), new ItemStack((IItemProvider)Blocks.field_196860_iS), new FluidStack((Fluid)Fluids.field_204546_a, 10), new ItemStack((IItemProvider)Blocks.field_196828_iC, 3));
        RecipeSolidifier.addRecipe("oconcrete", new ItemStack((IItemProvider)Blocks.field_196862_iT), new ItemStack((IItemProvider)Blocks.field_196862_iT), new ItemStack((IItemProvider)Blocks.field_196862_iT), new FluidStack((Fluid)Fluids.field_204546_a, 10), new ItemStack((IItemProvider)Blocks.field_196830_iD, 3));
        RecipeSolidifier.addRecipe("mconcrete", new ItemStack((IItemProvider)Blocks.field_196864_iU), new ItemStack((IItemProvider)Blocks.field_196864_iU), new ItemStack((IItemProvider)Blocks.field_196864_iU), new FluidStack((Fluid)Fluids.field_204546_a, 10), new ItemStack((IItemProvider)Blocks.field_196832_iE, 3));
        RecipeSolidifier.addRecipe("lconcrete", new ItemStack((IItemProvider)Blocks.field_196866_iV), new ItemStack((IItemProvider)Blocks.field_196866_iV), new ItemStack((IItemProvider)Blocks.field_196866_iV), new FluidStack((Fluid)Fluids.field_204546_a, 10), new ItemStack((IItemProvider)Blocks.field_196834_iF, 3));
        RecipeSolidifier.addRecipe("yconcrete", new ItemStack((IItemProvider)Blocks.field_196868_iW), new ItemStack((IItemProvider)Blocks.field_196868_iW), new ItemStack((IItemProvider)Blocks.field_196868_iW), new FluidStack((Fluid)Fluids.field_204546_a, 10), new ItemStack((IItemProvider)Blocks.field_196836_iG, 3));
        RecipeSolidifier.addRecipe("concrete", new ItemStack((IItemProvider)Blocks.field_196870_iX), new ItemStack((IItemProvider)Blocks.field_196870_iX), new ItemStack((IItemProvider)Blocks.field_196870_iX), new FluidStack((Fluid)Fluids.field_204546_a, 10), new ItemStack((IItemProvider)Blocks.field_196838_iH, 3));
        RecipeSolidifier.addRecipe("concrepinkte", new ItemStack((IItemProvider)Blocks.field_196872_iY), new ItemStack((IItemProvider)Blocks.field_196872_iY), new ItemStack((IItemProvider)Blocks.field_196872_iY), new FluidStack((Fluid)Fluids.field_204546_a, 10), new ItemStack((IItemProvider)Blocks.field_196840_iI, 3));
        RecipeSolidifier.addRecipe("gggrayconcrete", new ItemStack((IItemProvider)Blocks.field_196874_iZ), new ItemStack((IItemProvider)Blocks.field_196874_iZ), new ItemStack((IItemProvider)Blocks.field_196874_iZ), new FluidStack((Fluid)Fluids.field_204546_a, 10), new ItemStack((IItemProvider)Blocks.field_196842_iJ, 3));
        RecipeSolidifier.addRecipe("ggrconcrete", new ItemStack((IItemProvider)Blocks.field_196877_ja), new ItemStack((IItemProvider)Blocks.field_196877_ja), new ItemStack((IItemProvider)Blocks.field_196877_ja), new FluidStack((Fluid)Fluids.field_204546_a, 10), new ItemStack((IItemProvider)Blocks.field_196844_iK, 3));
        RecipeSolidifier.addRecipe("lgconcrete", new ItemStack((IItemProvider)Blocks.field_196878_jb), new ItemStack((IItemProvider)Blocks.field_196878_jb), new ItemStack((IItemProvider)Blocks.field_196878_jb), new FluidStack((Fluid)Fluids.field_204546_a, 10), new ItemStack((IItemProvider)Blocks.field_196846_iL, 3));
        RecipeSolidifier.addRecipe("purplecyconcrete", new ItemStack((IItemProvider)Blocks.field_196879_jc), new ItemStack((IItemProvider)Blocks.field_196879_jc), new ItemStack((IItemProvider)Blocks.field_196879_jc), new FluidStack((Fluid)Fluids.field_204546_a, 10), new ItemStack((IItemProvider)Blocks.field_196848_iM, 3));
        RecipeSolidifier.addRecipe("bluconcrete", new ItemStack((IItemProvider)Blocks.field_196880_jd), new ItemStack((IItemProvider)Blocks.field_196880_jd), new ItemStack((IItemProvider)Blocks.field_196880_jd), new FluidStack((Fluid)Fluids.field_204546_a, 10), new ItemStack((IItemProvider)Blocks.field_196850_iN, 3));
        RecipeSolidifier.addRecipe("brownconcrete", new ItemStack((IItemProvider)Blocks.field_196881_je), new ItemStack((IItemProvider)Blocks.field_196881_je), new ItemStack((IItemProvider)Blocks.field_196881_je), new FluidStack((Fluid)Fluids.field_204546_a, 10), new ItemStack((IItemProvider)Blocks.field_196852_iO, 3));
        RecipeSolidifier.addRecipe("greeeeconcrete", new ItemStack((IItemProvider)Blocks.field_196882_jf), new ItemStack((IItemProvider)Blocks.field_196882_jf), new ItemStack((IItemProvider)Blocks.field_196882_jf), new FluidStack((Fluid)Fluids.field_204546_a, 10), new ItemStack((IItemProvider)Blocks.field_196854_iP, 3));
        RecipeSolidifier.addRecipe("redconcrete", new ItemStack((IItemProvider)Blocks.field_196883_jg), new ItemStack((IItemProvider)Blocks.field_196883_jg), new ItemStack((IItemProvider)Blocks.field_196883_jg), new FluidStack((Fluid)Fluids.field_204546_a, 10), new ItemStack((IItemProvider)Blocks.field_196856_iQ, 3));
        RecipeSolidifier.addRecipe("freezeice", new ItemStack((IItemProvider)Blocks.field_196604_cC), new ItemStack((IItemProvider)Blocks.field_196604_cC), new ItemStack((IItemProvider)Blocks.field_196604_cC), new FluidStack((Fluid)Fluids.field_204546_a, 1000), new ItemStack((IItemProvider)Blocks.field_150432_aD));
        RecipeSolidifier.addRecipe("obsidian", new ItemStack((IItemProvider)Blocks.field_150347_e), new ItemStack((IItemProvider)Blocks.field_150347_e), new ItemStack((IItemProvider)Blocks.field_150347_e), new FluidStack((Fluid)Fluids.field_204547_b, 1000), new ItemStack((IItemProvider)Blocks.field_150343_Z));
        RecipeSolidifier.addRecipe("obsidian2", new ItemStack((IItemProvider)Blocks.field_150347_e), new ItemStack((IItemProvider)Items.field_151065_br), new ItemStack((IItemProvider)Blocks.field_150347_e), new FluidStack((Fluid)FluidMagmaHolder.STILL.get(), 500), new ItemStack((IItemProvider)Blocks.field_150343_Z));
        RecipeSolidifier.addRecipe("biograss", new ItemStack((IItemProvider)Blocks.field_150349_c), new ItemStack((IItemProvider)Blocks.field_196660_k), new ItemStack((IItemProvider)Blocks.field_150346_d), new FluidStack((Fluid)FluidBiomassHolder.STILL.get(), 500), new ItemStack((IItemProvider)Blocks.field_196658_i, 2));
        RecipeSolidifier.addRecipe("biofarm", new ItemStack((IItemProvider)Blocks.field_150346_d), new ItemStack((IItemProvider)Blocks.field_196660_k), new ItemStack((IItemProvider)Blocks.field_150346_d), new FluidStack((Fluid)FluidBiomassHolder.STILL.get(), 500), new ItemStack((IItemProvider)Blocks.field_150458_ak, 2));
        RecipeSolidifier.addRecipe("biofarmpodzol", new ItemStack((IItemProvider)Blocks.field_196658_i), new ItemStack((IItemProvider)Blocks.field_196660_k), new ItemStack((IItemProvider)Blocks.field_196658_i), new FluidStack((Fluid)FluidBiomassHolder.STILL.get(), 1000), new ItemStack((IItemProvider)Blocks.field_196661_l, 2));
        RecipeSolidifier.addRecipe("mossybrick", new ItemStack((IItemProvider)Blocks.field_196696_di), new ItemStack((IItemProvider)Blocks.field_196696_di), new ItemStack((IItemProvider)Blocks.field_196696_di), new FluidStack((Fluid)FluidBiomassHolder.STILL.get(), 10), new ItemStack((IItemProvider)Blocks.field_196698_dj, 3));
        RecipeSolidifier.addRecipe("mossystone", new ItemStack((IItemProvider)Blocks.field_150347_e), new ItemStack((IItemProvider)Blocks.field_150347_e), new ItemStack((IItemProvider)Blocks.field_150347_e), new FluidStack((Fluid)FluidBiomassHolder.STILL.get(), 10), new ItemStack((IItemProvider)Blocks.field_150341_Y, 3));
        RecipeSolidifier.addRecipe("biomycelium", new ItemStack((IItemProvider)Blocks.field_150420_aW), new ItemStack((IItemProvider)Blocks.field_150419_aX), new ItemStack((IItemProvider)Blocks.field_150458_ak), new FluidStack((Fluid)FluidBiomassHolder.STILL.get(), 1000), new ItemStack((IItemProvider)Blocks.field_150391_bh));
        RecipeSolidifier.addRecipe("biochar", new ItemStack((IItemProvider)ItemRegistry.biomass), new ItemStack((IItemProvider)Blocks.field_150346_d), new ItemStack((IItemProvider)Items.field_196155_l), new FluidStack((Fluid)FluidBiomassHolder.STILL.get(), 500), new ItemStack((IItemProvider)BlockRegistry.peat_unbaked));
        RecipeSolidifier.addRecipe("biocharrrr", new ItemStack((IItemProvider)Items.field_151055_y), new ItemStack((IItemProvider)ItemRegistry.peat_fuel), new ItemStack((IItemProvider)Items.field_151055_y), new FluidStack((Fluid)FluidBiomassHolder.STILL.get(), 100), new ItemStack((IItemProvider)Items.field_196155_l, 4));
        RecipeSolidifier.addRecipe("enrichfuel", new ItemStack((IItemProvider)ItemRegistry.peat_fuel), new ItemStack((IItemProvider)ItemRegistry.peat_fuel), new ItemStack((IItemProvider)ItemRegistry.peat_fuel), new FluidStack((Fluid)FluidBiomassHolder.STILL.get(), 500), new ItemStack((IItemProvider)ItemRegistry.peat_fuel_enriched, 3));
        RecipeSolidifier.addRecipe("honeymelon", new ItemStack((IItemProvider)Items.field_151127_ba), new ItemStack((IItemProvider)Items.field_151074_bl), new ItemStack((IItemProvider)Items.field_151127_ba), new FluidStack((Fluid)FluidHoneyHolder.STILL.get(), 50), new ItemStack((IItemProvider)Items.field_151060_bw, 2));
        RecipeSolidifier.addRecipe("honeycarrot", new ItemStack((IItemProvider)Items.field_151172_bF), new ItemStack((IItemProvider)Items.field_151074_bl), new ItemStack((IItemProvider)Items.field_151172_bF), new FluidStack((Fluid)FluidHoneyHolder.STILL.get(), 50), new ItemStack((IItemProvider)Items.field_151150_bK, 2));
        RecipeSolidifier.addRecipe("honeycake", new ItemStack((IItemProvider)Items.field_151110_aK), new ItemStack((IItemProvider)Items.field_151015_O), new ItemStack((IItemProvider)Items.field_151015_O), new FluidStack((Fluid)FluidHoneyHolder.STILL.get(), 500), new ItemStack((IItemProvider)Items.field_222070_lD));
        RecipeSolidifier.addRecipe("honeycookie", new ItemStack((IItemProvider)Items.field_151015_O), new ItemStack((IItemProvider)Items.field_196130_bo), new ItemStack((IItemProvider)Items.field_151015_O), new FluidStack((Fluid)FluidHoneyHolder.STILL.get(), 50), new ItemStack((IItemProvider)Items.field_151106_aX, 16));
        RecipeSolidifier.addRecipe("honeyspidereye", new ItemStack((IItemProvider)Items.field_151070_bp), new ItemStack((IItemProvider)Items.field_221692_bh), new ItemStack((IItemProvider)Items.field_221694_bi), new FluidStack((Fluid)FluidHoneyHolder.STILL.get(), 10), new ItemStack((IItemProvider)Items.field_151071_bq, 2));
        RecipeSolidifier.addRecipe("honeypie", new ItemStack((IItemProvider)Items.field_221687_cF), new ItemStack((IItemProvider)Items.field_151110_aK), new ItemStack((IItemProvider)Items.field_221687_cF), new FluidStack((Fluid)FluidHoneyHolder.STILL.get(), 50), new ItemStack((IItemProvider)Items.field_151158_bO, 3));
        RecipeSolidifier.addRecipe("honeyhive", new ItemStack((IItemProvider)Items.field_221675_bZ), new ItemStack((IItemProvider)Items.field_226635_pU_), new ItemStack((IItemProvider)Items.field_151055_y), new FluidStack((Fluid)FluidHoneyHolder.STILL.get(), 100), new ItemStack((IItemProvider)Blocks.field_226906_mb_));
        RecipeSolidifier.addRecipe("honeynest", new ItemStack((IItemProvider)Blocks.field_226908_md_), new ItemStack((IItemProvider)Blocks.field_226908_md_), new ItemStack((IItemProvider)Blocks.field_226908_md_), new FluidStack((Fluid)FluidHoneyHolder.STILL.get(), 8000), new ItemStack((IItemProvider)Blocks.field_226905_ma_));
        RecipeSolidifier.addRecipe("slimehoney", new ItemStack((IItemProvider)Items.field_151123_aH), new ItemStack((IItemProvider)Items.field_151123_aH), new ItemStack((IItemProvider)Items.field_151123_aH), new FluidStack((Fluid)FluidHoneyHolder.STILL.get(), 600), new ItemStack((IItemProvider)Blocks.field_180399_cE));
        RecipeSolidifier.addRecipe("slimefill", new ItemStack((IItemProvider)Items.field_151123_aH), new ItemStack((IItemProvider)Items.field_151123_aH), new ItemStack((IItemProvider)Items.field_151123_aH), new FluidStack((Fluid)FluidSlimeHolder.STILL.get(), 600), new ItemStack((IItemProvider)Items.field_151123_aH, 9));
        RecipeSolidifier.addRecipe("magmaglow", new ItemStack((IItemProvider)Items.field_221879_fX), new ItemStack((IItemProvider)Items.field_151114_aO), new ItemStack((IItemProvider)Items.field_221879_fX), new FluidStack((Fluid)FluidMagmaHolder.STILL.get(), 100), new ItemStack((IItemProvider)Items.field_179563_cD));
        RecipeSolidifier.addRecipe("slimemagmacream", new ItemStack((IItemProvider)Items.field_151123_aH), new ItemStack((IItemProvider)Items.field_151123_aH), new ItemStack((IItemProvider)Items.field_151123_aH), new FluidStack((Fluid)FluidMagmaHolder.STILL.get(), 100), new ItemStack((IItemProvider)Items.field_151064_bs, 6));
        RecipeSolidifier.addRecipe("magmabricks", new ItemStack((IItemProvider)Items.field_196154_dH), new ItemStack((IItemProvider)Items.field_196154_dH), new ItemStack((IItemProvider)Items.field_196154_dH), new FluidStack((Fluid)FluidMagmaHolder.STILL.get(), 10), new ItemStack((IItemProvider)Blocks.field_196653_dH));
        RecipeSolidifier.addRecipe("slimebricks", new ItemStack((IItemProvider)Items.field_196154_dH), new ItemStack((IItemProvider)Items.field_196154_dH), new ItemStack((IItemProvider)Items.field_196154_dH), new FluidStack((Fluid)FluidSlimeHolder.STILL.get(), 10), new ItemStack((IItemProvider)Blocks.field_196653_dH));
        RecipeSolidifier.addRecipe("rednetherbricks", new ItemStack((IItemProvider)Items.field_196154_dH), new ItemStack((IItemProvider)Items.field_151075_bm), new ItemStack((IItemProvider)Items.field_196154_dH), new FluidStack((Fluid)FluidSlimeHolder.STILL.get(), 10), new ItemStack((IItemProvider)Blocks.field_196817_hS));
        RecipeSolidifier rec = new RecipeSolidifier(new ResourceLocation("cyclic", "solid_leafbiomass"), new FluidStack((Fluid)Fluids.field_204546_a, 250), new ItemStack((IItemProvider)ItemRegistry.biomass));
        Ingredient leafs = Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196572_aa), new ItemStack((IItemProvider)Blocks.field_196642_W)});
        rec.ingredients.add((Object)leafs);
        rec.ingredients.add((Object)leafs);
        rec.ingredients.add((Object)leafs);
        RECIPES.add(rec);
        rec = new RecipeSolidifier(new ResourceLocation("cyclic", "solid_biomass"), new FluidStack((Fluid)Fluids.field_204546_a, 100), new ItemStack((IItemProvider)ItemRegistry.biomass));
        Ingredient fws = Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196606_bd), new ItemStack((IItemProvider)Blocks.field_196605_bc)});
        rec.ingredients.add((Object)fws);
        rec.ingredients.add((Object)fws);
        rec.ingredients.add((Object)fws);
        RECIPES.add(rec);
        RecipeSolidifier.addRecipe("honeyamber", new ItemStack((IItemProvider)Items.field_151059_bz), new ItemStack((IItemProvider)Items.field_151137_ax), new ItemStack((IItemProvider)Blocks.field_196814_hQ), new FluidStack((Fluid)FluidHoneyHolder.STILL.get(), 500), new ItemStack((IItemProvider)ItemRegistry.gem_amber));
        RecipeSolidifier.addRecipe("honeyfireamber", new ItemStack((IItemProvider)Items.field_151059_bz), new ItemStack((IItemProvider)Blocks.field_150451_bX), new ItemStack((IItemProvider)Items.field_151043_k), new FluidStack((Fluid)FluidMagmaHolder.STILL.get(), 1000), new ItemStack((IItemProvider)ItemRegistry.gem_amber));
        RecipeSolidifier.addRecipe("purp", new ItemStack((IItemProvider)Blocks.field_150343_Z), new ItemStack((IItemProvider)ItemRegistry.gem_amber), new ItemStack((IItemProvider)Items.field_185161_cS), new FluidStack((Fluid)FluidSlimeHolder.STILL.get(), 1000), new ItemStack((IItemProvider)ItemRegistry.gem_obsidian));
        RecipeSolidifier.addRecipe("purpflower", new ItemStack((IItemProvider)Blocks.field_150343_Z), new ItemStack((IItemProvider)ItemRegistry.gem_amber), new ItemStack((IItemProvider)Items.field_221690_bg), new FluidStack((Fluid)FluidSlimeHolder.STILL.get(), 1000), new ItemStack((IItemProvider)ItemRegistry.gem_obsidian));
        RecipeSolidifier.addRecipe("gravelmelt", new ItemStack((IItemProvider)Blocks.field_150346_d), new ItemStack((IItemProvider)Blocks.field_150346_d), new ItemStack((IItemProvider)Blocks.field_150346_d), new FluidStack((Fluid)FluidMagmaHolder.STILL.get(), 100), new ItemStack((IItemProvider)Blocks.field_150351_n, 9));
        RecipeSolidifier.addRecipe("sandmelt", new ItemStack((IItemProvider)Blocks.field_150359_w), new ItemStack((IItemProvider)Blocks.field_150359_w), new ItemStack((IItemProvider)Blocks.field_150359_w), new FluidStack((Fluid)FluidMagmaHolder.STILL.get(), 10), new ItemStack((IItemProvider)Blocks.field_150354_m, 3));
        RecipeSolidifier.addRecipe("gunpowder", new ItemStack((IItemProvider)Blocks.field_196611_F), new ItemStack((IItemProvider)Items.field_151065_br), new ItemStack((IItemProvider)Items.field_196106_bc), new FluidStack((Fluid)FluidMagmaHolder.STILL.get(), 100), new ItemStack((IItemProvider)Items.field_151016_H, 2));
        RecipeSolidifier.addRecipe("expglass", new ItemStack((IItemProvider)Items.field_151069_bo), new ItemStack((IItemProvider)Items.field_151069_bo), new ItemStack((IItemProvider)Items.field_151069_bo), new FluidStack((Fluid)FluidXpJuiceHolder.STILL.get(), 600), new ItemStack((IItemProvider)Items.field_151062_by, 3));
        RecipeSolidifier.addRecipe("expglassfood", new ItemStack((IItemProvider)Items.field_151102_aT), new ItemStack((IItemProvider)Items.field_151102_aT), new ItemStack((IItemProvider)Items.field_151102_aT), new FluidStack((Fluid)FluidXpJuiceHolder.STILL.get(), 1000), new ItemStack((IItemProvider)ItemRegistry.experience_food));
        ModCyclic.LOGGER.info("Solidifier Recipes added " + RECIPES.size());
    }

    private static void addRecipe(String name, ItemStack a, ItemStack b, ItemStack c, FluidStack fluidStack, ItemStack res) {
        ResourceLocation id = new ResourceLocation("cyclic", "solidifier_" + name);
        if (hashes.contains(id.toString())) {
            ModCyclic.LOGGER.error("Duplicate solidifier recipe id " + id.toString());
        }
        RECIPES.add(new RecipeSolidifier(id, a, b, c, fluidStack, res));
        hashes.add(id.toString());
    }
}

