/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.solidifier;

import com.lothrazar.cyclic.ConfigManager;
import com.lothrazar.cyclic.base.FluidTankBase;
import com.lothrazar.cyclic.base.TileEntityBase;
import com.lothrazar.cyclic.block.solidifier.ContainerSolidifier;
import com.lothrazar.cyclic.block.solidifier.RecipeSolidifier;
import com.lothrazar.cyclic.capability.CustomEnergyStorage;
import com.lothrazar.cyclic.capability.ItemStackHandlerSided;
import com.lothrazar.cyclic.registry.BlockRegistry;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class TileSolidifier
extends TileEntityBase
implements ITickableTileEntity,
INamedContainerProvider {
    public static final int TIMER_FULL = 100;
    public static final int MAX = 64000;
    public static final int CAPACITY = 64000;
    public static final int TRANSFER_FLUID_PER_TICK = 50;
    private RecipeSolidifier currentRecipe;
    FluidTankBase tank;
    private ItemStackHandlerSided inputSlots;
    private ItemStackHandlerSided outputSlot;
    private final LazyOptional<FluidTankBase> tankWrapper = LazyOptional.of(() -> this.tank);
    private final LazyOptional<IEnergyStorage> energyWrapper = LazyOptional.of(this::createEnergy);
    private final LazyOptional<IItemHandler> inputsSlotWrapper = LazyOptional.of(() -> this.inputSlots);
    private final LazyOptional<IItemHandler> outputSlotWrapper = LazyOptional.of(() -> this.outputSlot);

    public TileSolidifier() {
        super(BlockRegistry.Tiles.solidifier);
        this.tank = new FluidTankBase(this, 64000, this.isFluidValid());
        this.inputSlots = new ItemStackHandlerSided(3);
        this.outputSlot = new ItemStackHandlerSided(1);
    }

    private IEnergyStorage createEnergy() {
        return new CustomEnergyStorage(64000, 64000);
    }

    public Predicate<FluidStack> isFluidValid() {
        return p -> true;
    }

    @Override
    public void setField(int field, int value) {
        switch (Fields.values()[field]) {
            case TIMER: {
                this.timer = value;
                break;
            }
            case REDSTONE: {
                this.setNeedsRedstone(value);
                break;
            }
            case RENDER: {
                this.renderParticles = value % 2;
            }
        }
    }

    @Override
    public int getField(int field) {
        switch (Fields.values()[field]) {
            case TIMER: {
                return this.timer;
            }
            case REDSTONE: {
                return this.getNeedsRedstone();
            }
            case RENDER: {
                return this.renderParticles;
            }
        }
        return super.getField(field);
    }

    public ITextComponent func_145748_c_() {
        return new StringTextComponent(this.func_200662_C().getRegistryName().func_110623_a());
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerSolidifier(i, this.field_145850_b, this.field_174879_c, playerInventory, playerEntity);
    }

    @Override
    public void func_230337_a_(BlockState bs, CompoundNBT tag) {
        this.tank.readFromNBT(tag.func_74775_l("fluid"));
        this.energyWrapper.ifPresent(h -> ((INBTSerializable)h).deserializeNBT((INBT)tag.func_74775_l("energy")));
        this.inputsSlotWrapper.ifPresent(h -> ((INBTSerializable)h).deserializeNBT((INBT)tag.func_74775_l("inv")));
        this.outputSlotWrapper.ifPresent(h -> ((INBTSerializable)h).deserializeNBT((INBT)tag.func_74775_l("invoutput")));
        super.func_230337_a_(bs, tag);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        CompoundNBT fluid = new CompoundNBT();
        this.tank.writeToNBT(fluid);
        tag.func_218657_a("fluid", (INBT)fluid);
        this.energyWrapper.ifPresent(h -> {
            CompoundNBT compound = (CompoundNBT)((INBTSerializable)h).serializeNBT();
            tag.func_218657_a("energy", (INBT)compound);
        });
        this.inputsSlotWrapper.ifPresent(h -> {
            CompoundNBT compound = (CompoundNBT)((INBTSerializable)h).serializeNBT();
            tag.func_218657_a("inv", (INBT)compound);
        });
        this.outputSlotWrapper.ifPresent(h -> {
            CompoundNBT compound = (CompoundNBT)((INBTSerializable)h).serializeNBT();
            tag.func_218657_a("invoutput", (INBT)compound);
        });
        return super.func_189515_b(tag);
    }

    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction side) {
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.tankWrapper.cast();
        }
        if (cap == CapabilityEnergy.ENERGY) {
            return this.energyWrapper.cast();
        }
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (side == Direction.DOWN) {
                return this.outputSlotWrapper.cast();
            }
            return this.inputsSlotWrapper.cast();
        }
        return super.getCapability(cap, side);
    }

    public FluidStack getFluid() {
        return this.tank == null ? FluidStack.EMPTY : this.tank.getFluid();
    }

    public float getCapacity() {
        return 64000.0f;
    }

    @Override
    public void setFluid(FluidStack fluid) {
        this.tank.setFluid(fluid);
    }

    public void func_73660_a() {
        IEnergyStorage en = (IEnergyStorage)this.energyWrapper.orElse(null);
        if (en == null) {
            return;
        }
        this.findMatchingRecipe();
        if (this.currentRecipe == null) {
            return;
        }
        --this.timer;
        if (this.timer < 0) {
            this.timer = 0;
        }
        int cost = (Integer)ConfigManager.SOLIDIFIERPOWER.get();
        if (en.getEnergyStored() < cost) {
            return;
        }
        if (this.timer == 0 && this.tryProcessRecipe()) {
            this.timer = 100;
            en.extractEnergy(cost, false);
        }
    }

    private void findMatchingRecipe() {
        if (this.currentRecipe != null && this.currentRecipe.matches((TileEntityBase)this, this.field_145850_b)) {
            return;
        }
        this.currentRecipe = null;
        for (RecipeSolidifier rec : RecipeSolidifier.RECIPES) {
            if (!rec.matches((TileEntityBase)this, this.field_145850_b)) continue;
            this.currentRecipe = rec;
            break;
        }
    }

    private boolean tryProcessRecipe() {
        FluidStack test = this.tank.drain(this.currentRecipe.getRecipeFluid(), IFluidHandler.FluidAction.SIMULATE);
        if (test.getAmount() == this.currentRecipe.getRecipeFluid().getAmount()) {
            if (!this.outputSlot.insertItem(0, this.currentRecipe.func_77571_b(), true).func_190926_b()) {
                return false;
            }
            this.inputSlots.getStackInSlot(0).func_190918_g(1);
            this.inputSlots.getStackInSlot(1).func_190918_g(1);
            this.inputSlots.getStackInSlot(2).func_190918_g(1);
            this.tank.drain(this.currentRecipe.getRecipeFluid(), IFluidHandler.FluidAction.EXECUTE);
            this.outputSlot.insertItem(0, this.currentRecipe.func_77571_b(), false);
            return true;
        }
        return false;
    }

    public ItemStack getStackInputSlot(int slot) {
        return this.inputSlots.getStackInSlot(slot);
    }

    public static enum Fields {
        REDSTONE,
        TIMER,
        RENDER;

    }
}

