/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.structurereadercreative;

import com.lothrazar.cyclic.ModCyclic;
import com.lothrazar.cyclic.base.TileEntityBase;
import com.lothrazar.cyclic.block.structurereadercreative.ContainerReader;
import com.lothrazar.cyclic.data.BlockPosDim;
import com.lothrazar.cyclic.item.LocationGpsItem;
import com.lothrazar.cyclic.item.StructureDiskItem;
import com.lothrazar.cyclic.registry.BlockRegistry;
import com.lothrazar.cyclic.registry.ItemRegistry;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ResourceLocationException;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileReader
extends TileEntityBase
implements INamedContainerProvider,
ITickableTileEntity {
    private static final int SLOT_GPSSTART = 0;
    private static final int SLOT_GPSEND = 1;
    private static final int SLOT_RESULT = 2;
    private LazyOptional<IItemHandler> inventory = LazyOptional.of(this::createHandler);
    private String schematicName = "creativeschematic";

    public TileReader() {
        super(BlockRegistry.Tiles.structure_reader);
    }

    private IItemHandler createHandler() {
        return new ItemStackHandler(3){

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                if (slot == 0 || slot == 1) {
                    return stack.func_77973_b() instanceof LocationGpsItem;
                }
                return true;
            }
        };
    }

    @Override
    public void setFieldString(int field, String value) {
        ModCyclic.LOGGER.info("TE save " + value);
        this.schematicName = value;
    }

    @Override
    public String getFieldString(int field) {
        return this.schematicName;
    }

    public ITextComponent func_145748_c_() {
        return new StringTextComponent(this.func_200662_C().getRegistryName().func_110623_a());
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerReader(i, this.field_145850_b, this.field_174879_c, playerInventory, playerEntity);
    }

    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventory.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void func_230337_a_(BlockState bs, CompoundNBT tag) {
        tag.func_74778_a("schematicName", this.schematicName);
        this.inventory.ifPresent(h -> ((INBTSerializable)h).deserializeNBT((INBT)tag.func_74775_l("inv")));
        super.func_230337_a_(bs, tag);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        this.schematicName = tag.func_74779_i("schematicName");
        this.inventory.ifPresent(h -> {
            CompoundNBT compound = (CompoundNBT)((INBTSerializable)h).serializeNBT();
            tag.func_218657_a("inv", (INBT)compound);
        });
        return super.func_189515_b(tag);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.inventory.ifPresent(inv -> {
                ItemStack stack = inv.getStackInSlot(0);
                BlockPosDim targetPos = LocationGpsItem.getPosition(stack);
                stack = inv.getStackInSlot(1);
                BlockPosDim endPos = LocationGpsItem.getPosition(stack);
                ItemStack resultStack = inv.getStackInSlot(2);
                if (targetPos != null && endPos != null && resultStack.func_190926_b()) {
                    ResourceLocation saved = this.saveCut(targetPos.getPos(), endPos.getPos());
                    ModCyclic.LOGGER.info("copy saved? = " + saved);
                    ItemStack newDisk = new ItemStack((IItemProvider)ItemRegistry.structure_disk);
                    StructureDiskItem.saveDisk(newDisk, saved);
                    inv.insertItem(2, newDisk, false);
                }
            });
        }
    }

    private ResourceLocation saveCut(BlockPos targetPos, BlockPos endPos) {
        ServerWorld serverworld = (ServerWorld)this.field_145850_b;
        TemplateManager templatemanager = serverworld.func_184163_y();
        try {
            ResourceLocation nameResource = ResourceLocation.func_208304_a((String)this.schematicName);
            Template template = templatemanager.func_200220_a(nameResource);
            int xSize = Math.abs(targetPos.func_177958_n() - endPos.func_177958_n());
            int ySize = Math.abs(targetPos.func_177956_o() - endPos.func_177956_o());
            int zSize = Math.abs(targetPos.func_177952_p() - endPos.func_177952_p());
            BlockPos size = new BlockPos(xSize, ySize, zSize);
            BlockPos start = new BlockPos(Math.min(targetPos.func_177958_n(), endPos.func_177958_n()), Math.min(targetPos.func_177956_o(), endPos.func_177956_o()), Math.min(targetPos.func_177952_p(), endPos.func_177952_p()));
            BlockPos end = new BlockPos(Math.max(targetPos.func_177958_n(), endPos.func_177958_n()), Math.max(targetPos.func_177956_o(), endPos.func_177956_o()), Math.max(targetPos.func_177952_p(), endPos.func_177952_p()));
            template.func_186254_a(this.field_145850_b, start, size, false, Blocks.field_189881_dj);
            template.func_186252_a("cyclic");
            if (templatemanager.func_195429_b(nameResource)) {
                ModCyclic.LOGGER.info("copied schematic for FREEE");
                return nameResource;
            }
        }
        catch (ResourceLocationException var8) {
            ModCyclic.LOGGER.error("schematic", (Throwable)var8);
        }
        return null;
    }

    @Override
    public void setField(int field, int value) {
    }
}

