/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.structurewriter;

import com.lothrazar.cyclic.ModCyclic;
import com.lothrazar.cyclic.base.TileEntityBase;
import com.lothrazar.cyclic.block.structurewriter.ContainerWriter;
import com.lothrazar.cyclic.data.BlockPosDim;
import com.lothrazar.cyclic.item.LocationGpsItem;
import com.lothrazar.cyclic.item.StructureDiskItem;
import com.lothrazar.cyclic.registry.BlockRegistry;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileWriter
extends TileEntityBase
implements INamedContainerProvider,
ITickableTileEntity {
    private static final int SLOT_DISK = 0;
    private static final int SLOT_GPS = 1;
    private LazyOptional<IItemHandler> inventory = LazyOptional.of(this::createHandler);
    private int shapeIndex = 0;
    StructureStatus structStatus = StructureStatus.NONE;
    StructureMode mode = StructureMode.PREVIEW;
    private Mirror mirror = Mirror.NONE;
    private Rotation rotation = Rotation.NONE;

    public TileWriter() {
        super(BlockRegistry.Tiles.structure_writer);
    }

    private IItemHandler createHandler() {
        return new ItemStackHandler(2){

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                if (slot == 0) {
                    return stack.func_77973_b() instanceof StructureDiskItem;
                }
                return stack.func_77973_b() instanceof LocationGpsItem;
            }

            public int getSlotLimit(int slot) {
                return 1;
            }
        };
    }

    public ITextComponent func_145748_c_() {
        return new StringTextComponent(this.func_200662_C().getRegistryName().func_110623_a());
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerWriter(i, this.field_145850_b, this.field_174879_c, playerInventory, playerEntity);
    }

    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventory.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void func_230337_a_(BlockState bs, CompoundNBT tag) {
        this.shapeIndex = tag.func_74762_e("shapeIndex");
        this.structStatus = StructureStatus.values()[tag.func_74762_e("struct_status")];
        this.inventory.ifPresent(h -> ((INBTSerializable)h).deserializeNBT((INBT)tag.func_74775_l("inv")));
        super.func_230337_a_(bs, tag);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag.func_74768_a("shapeIndex", this.shapeIndex);
        tag.func_74768_a("struct_status", this.structStatus.ordinal());
        this.inventory.ifPresent(h -> {
            CompoundNBT compound = (CompoundNBT)((INBTSerializable)h).serializeNBT();
            tag.func_218657_a("inv", (INBT)compound);
        });
        return super.func_189515_b(tag);
    }

    public void func_73660_a() {
        this.inventory.ifPresent(inv -> {
            ItemStack disk = inv.getStackInSlot(0);
            ItemStack gps = inv.getStackInSlot(1);
            BlockPosDim posTarget = LocationGpsItem.getPosition(gps);
            if (!disk.func_190926_b() && disk.func_77973_b() instanceof StructureDiskItem && posTarget != null) {
                this.structStatus = StructureStatus.INVALID;
                ResourceLocation structureLoc = StructureDiskItem.readDisk(disk);
                if (structureLoc != null) {
                    this.structStatus = StructureStatus.VALID;
                    ModCyclic.LOGGER.info("found " + structureLoc);
                    if (!this.field_145850_b.field_72995_K && this.mode == StructureMode.BUILD && this.build(structureLoc, disk, posTarget.getPos())) {
                        StructureDiskItem.deleteDisk(disk);
                        inv.extractItem(0, 64, false);
                        inv.insertItem(0, disk, false);
                    }
                }
            } else {
                this.structStatus = StructureStatus.NONE;
            }
        });
    }

    private boolean build(ResourceLocation location, ItemStack disk, BlockPos blockPos) {
        ServerWorld serverworld = (ServerWorld)this.field_145850_b;
        TemplateManager templatemanager = serverworld.func_184163_y();
        Template template = templatemanager.func_200219_b(location);
        PlacementSettings placementsettings = new PlacementSettings().func_186214_a(this.mirror).func_186220_a(this.rotation).func_186222_a(true).func_186218_a((ChunkPos)null);
        boolean DOBUILD = true;
        if (DOBUILD) {
            ModCyclic.LOGGER.info("Build starting at " + blockPos);
            template.func_237144_a_((IWorld)this.field_145850_b, blockPos, placementsettings, this.field_145850_b.field_73012_v);
            return true;
        }
        return false;
    }

    @Override
    public void setField(int field, int value) {
        switch (Fields.values()[field]) {
            case REDSTONE: {
                this.setNeedsRedstone(value);
                break;
            }
            case STATUS: {
                this.structStatus = StructureStatus.values()[value];
                break;
            }
            case MODE: {
                this.mode = StructureMode.values()[value];
            }
        }
    }

    @Override
    public int getField(int field) {
        switch (Fields.values()[field]) {
            case REDSTONE: {
                return this.getNeedsRedstone();
            }
            case STATUS: {
                return this.structStatus.ordinal();
            }
            case MODE: {
                return this.mode.ordinal();
            }
        }
        return 0;
    }

    public List<BlockPos> getShape() {
        return null;
    }

    static enum StructureMode {
        PREVIEW,
        BUILD;

    }

    static enum StructureStatus {
        NONE,
        INVALID,
        VALID;

    }

    public static enum Fields {
        REDSTONE,
        STATUS,
        MODE;

    }
}

