/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.gui;

import com.lothrazar.cyclic.registry.TextureRegistry;
import com.lothrazar.cyclic.render.FluidRenderMap;
import com.lothrazar.cyclic.util.UtilFluid;
import com.lothrazar.cyclic.util.UtilRender;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.fluid.Fluids;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fluids.FluidStack;

public class FluidBar {
    private Screen parent;
    private int x;
    private int y;
    private int capacity;
    private int width = 18;
    private int height = 62;
    public int guiLeft;
    public int guiTop;

    public FluidBar(Screen p, int x, int y, int cap) {
        this.parent = p;
        this.x = x;
        this.y = y;
        this.capacity = cap;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void draw(MatrixStack ms, FluidStack fluid) {
        boolean u = false;
        boolean v = false;
        int x = this.guiLeft + this.getX();
        int y = this.guiTop + this.getY();
        this.parent.getMinecraft().func_110434_K().func_110577_a(TextureRegistry.FLUID_WIDGET);
        Screen.func_238463_a_((MatrixStack)ms, (int)x, (int)y, (float)0.0f, (float)0.0f, (int)this.width, (int)this.height, (int)this.width, (int)this.height);
        if (fluid == null || this.getCapacity() == 0 || fluid.getAmount() == 0) {
            return;
        }
        float capacity = this.getCapacity();
        float amount = fluid.getAmount();
        float scale = amount / capacity;
        int fluidAmount = (int)(scale * (float)this.height);
        TextureAtlasSprite icon = UtilFluid.getBaseFluidTexture(fluid.getFluid(), FluidRenderMap.FluidType.STILL);
        if (fluid.getFluid() == Fluids.field_204546_a) {
            RenderSystem.color3f((float)0.0f, (float)0.0f, (float)1.0f);
        }
        this.drawTiledSprite(x + 1, y + 1, this.height - 2, this.width - 2, fluidAmount - 2, icon);
        if (fluid.getFluid() == Fluids.field_204546_a) {
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    protected void drawTiledSprite(int xPosition, int yPosition, int yOffset, int desiredWidth, int desiredHeight, TextureAtlasSprite sprite) {
        UtilRender.drawTiledSprite(xPosition, yPosition, yOffset, desiredWidth, desiredHeight, sprite, this.width - 2, this.width - 2, this.parent.func_230927_p_());
    }

    public boolean isMouseover(int mouseX, int mouseY) {
        return this.guiLeft + this.x < mouseX && mouseX < this.guiLeft + this.x + this.width && this.guiTop + this.y < mouseY && mouseY < this.guiTop + this.y + this.height;
    }

    public void renderHoveredToolTip(MatrixStack ms, int mouseX, int mouseY, FluidStack current) {
        if (this.isMouseover(mouseX, mouseY) && current != null && !current.isEmpty()) {
            String tt = current.getAmount() + "/" + this.getCapacity() + " " + current.getDisplayName().getString();
            ArrayList<TranslationTextComponent> list = new ArrayList<TranslationTextComponent>();
            list.add(new TranslationTextComponent(tt));
            this.parent.func_238654_b_(ms, list, mouseX, mouseY);
        }
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getCapacity() {
        return this.capacity;
    }
}

