/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.item;

import com.lothrazar.cyclic.ModCyclic;
import com.lothrazar.cyclic.base.ItemBase;
import com.lothrazar.cyclic.data.BlockPosDim;
import com.lothrazar.cyclic.util.UtilChat;
import com.lothrazar.cyclic.util.UtilNBT;
import com.lothrazar.cyclic.util.UtilWorld;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class LocationGpsItem
extends ItemBase {
    private static final String NBT_SIDE = "side";
    private static final String NBT_DIM = "dim";

    public LocationGpsItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        BlockPosDim dim = LocationGpsItem.getPosition(stack);
        if (dim != null) {
            tooltip.add((ITextComponent)new TranslationTextComponent(dim.toString()));
            if (flagIn.func_194127_a()) {
                String side = "S: " + dim.getSide().toString().toUpperCase();
                tooltip.add((ITextComponent)new TranslationTextComponent(side));
                String sideF = "F: " + dim.getSidePlayerFacing().toString().toUpperCase();
                tooltip.add((ITextComponent)new TranslationTextComponent(sideF));
                tooltip.add((ITextComponent)new TranslationTextComponent("H: " + dim.getHitVec().toString()));
            }
        } else {
            TranslationTextComponent t = new TranslationTextComponent(this.func_77658_a() + ".tooltip");
            t.func_240699_a_(TextFormatting.GRAY);
            tooltip.add((ITextComponent)t);
        }
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        PlayerEntity player = context.func_195999_j();
        Hand hand = context.func_221531_n();
        BlockPos pos = context.func_195995_a();
        Direction side = context.func_196000_l();
        ItemStack held = player.func_184586_b(hand);
        player.func_184609_a(hand);
        UtilNBT.setItemStackBlockPos(held, pos);
        held.func_196082_o().func_74778_a(NBT_DIM, UtilWorld.dimensionToString(player.field_70170_p));
        UtilNBT.setItemStackNBTVal(held, NBT_SIDE, side.ordinal());
        UtilNBT.setItemStackNBTVal(held, "sidefacing", player.func_174811_aO().ordinal());
        UtilChat.sendStatusMessage(player, UtilChat.lang("item.location.saved") + UtilChat.blockPosToString(pos));
        Vector3d vec = context.func_221532_j();
        held.func_196082_o().func_74780_a("hitx", vec.field_72450_a - (double)pos.func_177958_n());
        held.func_196082_o().func_74780_a("hity", vec.field_72448_b - (double)pos.func_177956_o());
        held.func_196082_o().func_74780_a("hitz", vec.field_72449_c - (double)pos.func_177952_p());
        return ActionResultType.SUCCESS;
    }

    public static BlockPosDim getPosition(ItemStack item) {
        BlockPos pos = UtilNBT.getItemStackBlockPos(item);
        if (pos == null) {
            return null;
        }
        CompoundNBT tag = item.func_196082_o();
        BlockPosDim dim = new BlockPosDim(pos, tag.func_74779_i(NBT_DIM));
        try {
            dim.setSidePlayerFacing(Direction.values()[tag.func_74762_e("sidefacing")]);
            dim.setSide(Direction.values()[tag.func_74762_e(NBT_SIDE)]);
            Vector3d vec = new Vector3d(tag.func_74769_h("hitx"), tag.func_74769_h("hity"), tag.func_74769_h("hitz"));
            dim.setHitVec(vec);
        }
        catch (Throwable e) {
            ModCyclic.LOGGER.error("SIde error in GPS", e);
        }
        return dim;
    }
}

