/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.item;

import com.google.common.collect.Sets;
import com.lothrazar.cyclic.util.UtilShape;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTier;
import net.minecraft.item.Items;
import net.minecraft.item.ToolItem;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SChangeBlockPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ToolType;

public class MattockItem
extends ToolItem {
    static final int RADIUS = 1;

    public MattockItem(Item.Properties builder) {
        super(5.0f, -3.0f, (IItemTier)ItemTier.DIAMOND, (Set)Sets.newHashSet(), builder);
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, PlayerEntity player) {
        World world = player.field_70170_p;
        BlockRayTraceResult ray = MattockItem.func_219968_a((World)world, (PlayerEntity)player, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.NONE);
        if (ray != null && ray.func_216346_c() == RayTraceResult.Type.BLOCK) {
            BlockRayTraceResult brt = ray;
            Direction sideHit = brt.func_216354_b();
            List<BlockPos> shape = sideHit == Direction.UP || sideHit == Direction.DOWN ? UtilShape.squareHorizontalHollow(pos, 1) : (sideHit == Direction.EAST || sideHit == Direction.WEST ? UtilShape.squareVerticalZ(pos, 1) : UtilShape.squareVerticalX(pos, 1));
            for (BlockPos posCurrent : shape) {
                BlockState bsCurrent = world.func_180495_p(posCurrent);
                if (!player.func_175151_a(posCurrent, sideHit, stack) || !ForgeHooks.canHarvestBlock((BlockState)bsCurrent, (PlayerEntity)player, (IBlockReader)world, (BlockPos)posCurrent) || !(this.func_150893_a(stack, bsCurrent) > 1.0f)) continue;
                stack.func_179548_a(world, bsCurrent, posCurrent, player);
                Block blockCurrent = bsCurrent.func_177230_c();
                if (world.field_72995_K) {
                    world.func_217379_c(2001, posCurrent, Block.func_196246_j((BlockState)bsCurrent));
                    if (!blockCurrent.removedByPlayer(bsCurrent, world, posCurrent, player, true, bsCurrent.func_204520_s())) continue;
                    blockCurrent.func_176206_d((IWorld)world, posCurrent, bsCurrent);
                    continue;
                }
                if (!(player instanceof ServerPlayerEntity)) continue;
                ServerPlayerEntity mp = (ServerPlayerEntity)player;
                int xpGivenOnDrop = ForgeHooks.onBlockBreakEvent((World)world, (GameType)((ServerPlayerEntity)player).field_71134_c.func_73081_b(), (ServerPlayerEntity)((ServerPlayerEntity)player), (BlockPos)posCurrent);
                if (xpGivenOnDrop < 0) continue;
                if (blockCurrent.removedByPlayer(bsCurrent, world, posCurrent, player, true, bsCurrent.func_204520_s())) {
                    TileEntity tile = world.func_175625_s(posCurrent);
                    blockCurrent.func_176206_d((IWorld)world, posCurrent, bsCurrent);
                    blockCurrent.func_180657_a(world, player, posCurrent, bsCurrent, tile, stack);
                    blockCurrent.func_180637_b(world, posCurrent, xpGivenOnDrop);
                }
                mp.field_71135_a.func_147359_a((IPacket)new SChangeBlockPacket((IBlockReader)world, posCurrent));
            }
        }
        return super.onBlockStartBreak(stack, pos, player);
    }

    public int getHarvestLevel(ItemStack stack, ToolType tool, @Nullable PlayerEntity player, @Nullable BlockState blockState) {
        return Math.max(Items.field_151046_w.getHarvestLevel(stack, tool, player, blockState), Items.field_151047_v.getHarvestLevel(stack, tool, player, blockState));
    }

    public float func_150893_a(ItemStack stack, BlockState state) {
        return Math.max(Items.field_151046_w.func_150893_a(stack, state), Items.field_151047_v.func_150893_a(stack, state));
    }
}

