/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.util;

import com.lothrazar.cyclic.ModCyclic;
import com.lothrazar.cyclic.data.Model3D;
import com.lothrazar.cyclic.data.OffsetEnum;
import com.lothrazar.cyclic.render.RenderResizableCuboid;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.awt.Color;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;

public class UtilRender {
    public static final int MAX_LIGHT_X = 0xF000F0;
    public static final int MAX_LIGHT_Y = 0xF000F0;
    public static final int FULL_LIGHT = 0xF000F0;

    public static void drawTiledSprite(int xPosition, int yPosition, int yOffset, int desiredWidth, int desiredHeight, TextureAtlasSprite sprite, int textureWidth, int textureHeight, int zLevel) {
        if (desiredWidth == 0 || desiredHeight == 0 || textureWidth == 0 || textureHeight == 0) {
            return;
        }
        Minecraft.func_71410_x().field_71446_o.func_110577_a(PlayerContainer.field_226615_c_);
        int xTileCount = desiredWidth / textureWidth;
        int xRemainder = desiredWidth - xTileCount * textureWidth;
        int yTileCount = desiredHeight / textureHeight;
        int yRemainder = desiredHeight - yTileCount * textureHeight;
        int yStart = yPosition + yOffset;
        float uMin = sprite.func_94209_e();
        float uMax = sprite.func_94212_f();
        float vMin = sprite.func_94206_g();
        float vMax = sprite.func_94210_h();
        float uDif = uMax - uMin;
        float vDif = vMax - vMin;
        RenderSystem.enableBlend();
        RenderSystem.enableAlphaTest();
        BufferBuilder vertexBuffer = Tessellator.func_178181_a().func_178180_c();
        vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        block0: for (int xTile = 0; xTile <= xTileCount; ++xTile) {
            int width;
            int n = width = xTile == xTileCount ? xRemainder : textureWidth;
            if (width == 0) break;
            int x = xPosition + xTile * textureWidth;
            int maskRight = textureWidth - width;
            int shiftedX = x + textureWidth - maskRight;
            float uMaxLocal = uMax - uDif * (float)maskRight / (float)textureWidth;
            for (int yTile = 0; yTile <= yTileCount; ++yTile) {
                int height;
                int n2 = height = yTile == yTileCount ? yRemainder : textureHeight;
                if (height == 0) continue block0;
                int y = yStart - (yTile + 1) * textureHeight;
                int maskTop = textureHeight - height;
                float vMaxLocal = vMax - vDif * (float)maskTop / (float)textureHeight;
                vertexBuffer.func_225582_a_((double)x, (double)(y + textureHeight), (double)zLevel).func_225583_a_(uMin, vMaxLocal).func_181675_d();
                vertexBuffer.func_225582_a_((double)shiftedX, (double)(y + textureHeight), (double)zLevel).func_225583_a_(uMaxLocal, vMaxLocal).func_181675_d();
                vertexBuffer.func_225582_a_((double)shiftedX, (double)(y + maskTop), (double)zLevel).func_225583_a_(uMaxLocal, vMin).func_181675_d();
                vertexBuffer.func_225582_a_((double)x, (double)(y + maskTop), (double)zLevel).func_225583_a_(uMin, vMin).func_181675_d();
            }
        }
        vertexBuffer.func_178977_d();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)vertexBuffer);
        RenderSystem.disableAlphaTest();
        RenderSystem.disableBlend();
    }

    public static void renderCube(Matrix4f matrix, IVertexBuilder builder, BlockPos pos, Color color) {
        float red = (float)color.getRed() / 255.0f;
        float green = (float)color.getGreen() / 255.0f;
        float blue = (float)color.getBlue() / 255.0f;
        float alpha = 0.125f;
        float startX = 0.0f;
        float startY = 0.0f;
        float startZ = -1.0f;
        float endX = 1.0f;
        float endY = 1.0f;
        float endZ = 0.0f;
        builder.func_227888_a_(matrix, startX, startY, startZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, endX, startY, startZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, endX, startY, endZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, startX, startY, endZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, startX, endY, startZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, startX, endY, endZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, endX, endY, endZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, endX, endY, startZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, startX, startY, startZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, startX, endY, startZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, endX, endY, startZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, endX, startY, startZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, startX, startY, endZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, endX, startY, endZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, endX, endY, endZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, startX, endY, endZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, endX, startY, startZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, endX, endY, startZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, endX, endY, endZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, endX, startY, endZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, startX, startY, startZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, startX, startY, endZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, startX, endY, endZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
        builder.func_227888_a_(matrix, startX, endY, startZ).func_227885_a_(red, green, blue, alpha).func_181675_d();
    }

    public static void renderModelBrightnessColorQuads(MatrixStack.Entry matrixEntry, IVertexBuilder builder, float red, float green, float blue, float alpha, List<BakedQuad> quads, int combinedLights, int combinedOverlay) {
        for (BakedQuad bakedquad : quads) {
            float b;
            float g;
            float r;
            if (bakedquad.func_178212_b()) {
                r = red * 1.0f;
                g = green * 1.0f;
                b = blue * 1.0f;
            } else {
                r = 1.0f;
                g = 1.0f;
                b = 1.0f;
            }
            builder.addVertexData(matrixEntry, bakedquad, r, g, b, alpha, combinedLights, combinedOverlay);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderLaser(LaserConfig conf, MatrixStack matrixStack) {
        if (conf.first == null || conf.second == null) {
            return;
        }
        double offsetX = conf.xOffset.getOffset();
        double offsetY = conf.yOffset.getOffset();
        double offsetZ = conf.zOffset.getOffset();
        UtilRender.renderLaser((double)conf.first.func_177958_n() + offsetX, (double)conf.first.func_177956_o() + offsetY, (double)conf.first.func_177952_p() + offsetZ, (double)conf.second.func_177958_n() + offsetX, (double)conf.second.func_177956_o() + offsetY, (double)conf.second.func_177952_p() + offsetZ, conf.rotationTime, conf.alpha, conf.beamWidth, conf.color, conf.timer, matrixStack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderLaser(double firstX, double firstY, double firstZ, double secondX, double secondY, double secondZ, double rotationTime, float alpha, double beamWidth, float[] color, double timer, MatrixStack matrixStack) {
        Tessellator tessy = Tessellator.func_178181_a();
        BufferBuilder buffer = tessy.func_178180_c();
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        float r = color[0];
        float g = color[1];
        float b = color[2];
        Vector3d vecFirst = new Vector3d(firstX, firstY, firstZ);
        Vector3d vecSecond = new Vector3d(secondX, secondY, secondZ);
        Vector3d combinedVec = vecSecond.func_178788_d(vecFirst);
        double rot = rotationTime > 0.0 ? 360.0 * ((double)world.func_82737_E() % rotationTime / rotationTime) : 0.0;
        double pitch = Math.atan2(combinedVec.field_72448_b, Math.sqrt(combinedVec.field_72450_a * combinedVec.field_72450_a + combinedVec.field_72449_c * combinedVec.field_72449_c));
        double yaw = Math.atan2(-combinedVec.field_72449_c, combinedVec.field_72450_a);
        float length = (float)combinedVec.func_72433_c();
        length = (float)((double)length * (timer / 100.0));
        RenderSystem.pushMatrix();
        RenderSystem.rotatef((float)((float)(180.0 * yaw / Math.PI)), (float)0.0f, (float)1.0f, (float)0.0f);
        RenderSystem.rotatef((float)((float)(180.0 * pitch / Math.PI)), (float)0.0f, (float)0.0f, (float)1.0f);
        RenderSystem.rotatef((float)((float)rot), (float)1.0f, (float)0.0f, (float)0.0f);
        PlayerEntity player = ModCyclic.proxy.getClientPlayer();
        ActiveRenderInfo renderInfo = Minecraft.func_71410_x().field_71460_t.func_215316_n();
        double staticPlayerX = player.field_70142_S;
        double staticPlayerY = player.field_70137_T;
        double staticPlayerZ = player.field_70136_U;
        staticPlayerX = renderInfo.func_216785_c().func_82615_a();
        staticPlayerY = renderInfo.func_216785_c().func_82617_b();
        staticPlayerZ = renderInfo.func_216785_c().func_82616_c();
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(secondX - staticPlayerX, secondY - staticPlayerY, secondZ - staticPlayerZ);
        Matrix4f matrix4f = matrixStack.func_227866_c_().func_227870_a_();
        RenderSystem.multMatrix((Matrix4f)matrix4f);
        RenderSystem.disableTexture();
        RenderSystem.disableLighting();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        for (double i = 0.0; i < 4.0; i += 1.0) {
            float width = (float)(beamWidth * (i / 4.0));
            buffer.func_225582_a_((double)length, (double)width, (double)width).func_225587_b_(0, 0).func_227885_a_(r, g, b, alpha).func_181675_d();
            buffer.func_225582_a_(0.0, (double)width, (double)width).func_225587_b_(0, 0).func_227885_a_(r, g, b, alpha).func_181675_d();
            buffer.func_225582_a_(0.0, (double)(-width), (double)width).func_225587_b_(0, 0).func_227885_a_(r, g, b, alpha).func_181675_d();
            buffer.func_225582_a_((double)length, (double)(-width), (double)width).func_225587_b_(0, 0).func_227885_a_(r, g, b, alpha).func_181675_d();
            buffer.func_225582_a_((double)length, (double)(-width), (double)(-width)).func_225587_b_(0, 0).func_227885_a_(r, g, b, alpha).func_181675_d();
            buffer.func_225582_a_(0.0, (double)(-width), (double)(-width)).func_225587_b_(0, 0).func_227885_a_(r, g, b, alpha).func_181675_d();
            buffer.func_225582_a_(0.0, (double)width, (double)(-width)).func_225587_b_(0, 0).func_227885_a_(r, g, b, alpha).func_181675_d();
            buffer.func_225582_a_((double)length, (double)width, (double)(-width)).func_225587_b_(0, 0).func_227885_a_(r, g, b, alpha).func_181675_d();
            buffer.func_225582_a_((double)length, (double)width, (double)(-width)).func_225587_b_(0, 0).func_227885_a_(r, g, b, alpha).func_181675_d();
            buffer.func_225582_a_(0.0, (double)width, (double)(-width)).func_225587_b_(0, 0).func_227885_a_(r, g, b, alpha).func_181675_d();
            buffer.func_225582_a_(0.0, (double)width, (double)width).func_225587_b_(0, 0).func_227885_a_(r, g, b, alpha).func_181675_d();
            buffer.func_225582_a_((double)length, (double)width, (double)width).func_225587_b_(0, 0).func_227885_a_(r, g, b, alpha).func_181675_d();
            buffer.func_225582_a_((double)length, (double)(-width), (double)width).func_225587_b_(0, 0).func_227885_a_(r, g, b, alpha).func_181675_d();
            buffer.func_225582_a_(0.0, (double)(-width), (double)width).func_225587_b_(0, 0).func_227885_a_(r, g, b, alpha).func_181675_d();
            buffer.func_225582_a_(0.0, (double)(-width), (double)(-width)).func_225587_b_(0, 0).func_227885_a_(r, g, b, alpha).func_181675_d();
            buffer.func_225582_a_((double)length, (double)(-width), (double)(-width)).func_225587_b_(0, 0).func_227885_a_(r, g, b, alpha).func_181675_d();
        }
        tessy.func_78381_a();
        matrixStack.func_227865_b_();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.disableBlend();
        RenderSystem.enableLighting();
        RenderSystem.disableTexture();
        RenderSystem.popMatrix();
    }

    public static void drawBlock(BufferBuilder bufferbuilder, double x, double y, double z, float minU, float maxU, float minV, float maxV, double x_size, double y_size, double z_size) {
        bufferbuilder.func_225582_a_(-x_size + x, y_size + y, -z_size + z).func_225583_a_(maxU, maxV).func_181675_d();
        bufferbuilder.func_225582_a_(-x_size + x, y_size + y, z_size + z).func_225583_a_(maxU, minV).func_181675_d();
        bufferbuilder.func_225582_a_(x_size + x, y_size + y, z_size + z).func_225583_a_(minU, minV).func_181675_d();
        bufferbuilder.func_225582_a_(x_size + x, y_size + y, -z_size + z).func_225583_a_(minU, maxV).func_181675_d();
        bufferbuilder.func_225582_a_(-x_size + x, -y_size + y, z_size + z).func_225583_a_(minU, minV).func_181675_d();
        bufferbuilder.func_225582_a_(-x_size + x, -y_size + y, -z_size + z).func_225583_a_(minU, maxV).func_181675_d();
        bufferbuilder.func_225582_a_(x_size + x, -y_size + y, -z_size + z).func_225583_a_(maxU, maxV).func_181675_d();
        bufferbuilder.func_225582_a_(x_size + x, -y_size + y, z_size + z).func_225583_a_(maxU, minV).func_181675_d();
        bufferbuilder.func_225582_a_(x_size + x, -y_size + y, z_size + z).func_225583_a_(maxU, minV).func_181675_d();
        bufferbuilder.func_225582_a_(x_size + x, -y_size + y, -z_size + z).func_225583_a_(maxU, maxV).func_181675_d();
        bufferbuilder.func_225582_a_(x_size + x, y_size + y, -z_size + z).func_225583_a_(minU, maxV).func_181675_d();
        bufferbuilder.func_225582_a_(x_size + x, y_size + y, z_size + z).func_225583_a_(minU, minV).func_181675_d();
        bufferbuilder.func_225582_a_(-x_size + x, -y_size + y, -z_size + z).func_225583_a_(minU, maxV).func_181675_d();
        bufferbuilder.func_225582_a_(-x_size + x, -y_size + y, z_size + z).func_225583_a_(minU, minV).func_181675_d();
        bufferbuilder.func_225582_a_(-x_size + x, y_size + y, z_size + z).func_225583_a_(maxU, minV).func_181675_d();
        bufferbuilder.func_225582_a_(-x_size + x, y_size + y, -z_size + z).func_225583_a_(maxU, maxV).func_181675_d();
        bufferbuilder.func_225582_a_(-x_size + x, -y_size + y, -z_size + z).func_225583_a_(minU, maxV).func_181675_d();
        bufferbuilder.func_225582_a_(-x_size + x, y_size + y, -z_size + z).func_225583_a_(minU, minV).func_181675_d();
        bufferbuilder.func_225582_a_(x_size + x, y_size + y, -z_size + z).func_225583_a_(maxU, minV).func_181675_d();
        bufferbuilder.func_225582_a_(x_size + x, -y_size + y, -z_size + z).func_225583_a_(maxU, maxV).func_181675_d();
        bufferbuilder.func_225582_a_(x_size + x, -y_size + y, z_size + z).func_225583_a_(maxU, minV).func_181675_d();
        bufferbuilder.func_225582_a_(x_size + x, y_size + y, z_size + z).func_225583_a_(maxU, maxV).func_181675_d();
        bufferbuilder.func_225582_a_(-x_size + x, y_size + y, z_size + z).func_225583_a_(minU, maxV).func_181675_d();
        bufferbuilder.func_225582_a_(-x_size + x, -y_size + y, z_size + z).func_225583_a_(minU, minV).func_181675_d();
    }

    public static void renderObject(@Nullable Model3D object, @Nonnull MatrixStack matrix, IVertexBuilder buffer, int argb, int light) {
        if (object != null) {
            RenderResizableCuboid.INSTANCE.renderCube(object, matrix, buffer, argb, light);
        }
    }

    public static int calculateGlowLight(int light, @Nonnull FluidStack fluid) {
        return fluid.isEmpty() ? light : UtilRender.calculateGlowLight(light, fluid.getFluid().getAttributes().getLuminosity(fluid));
    }

    public static int calculateGlowLight(int light, int glow) {
        if (glow >= 15) {
            return 0xF000F0;
        }
        int blockLight = LightTexture.func_228450_a_((int)light);
        int skyLight = LightTexture.func_228454_b_((int)light);
        return LightTexture.func_228451_a_((int)Math.max(blockLight, glow), (int)Math.max(skyLight, glow));
    }

    public static int getColorARGB(@Nonnull FluidStack fluidStack, float fluidScale) {
        if (fluidStack.isEmpty()) {
            return -1;
        }
        return UtilRender.getColorARGB(fluidStack);
    }

    private static int getColorARGB(@Nonnull FluidStack fluidStack) {
        return fluidStack.getFluid().getAttributes().getColor(fluidStack);
    }

    public static float getRed(int color) {
        return (float)(color >> 16 & 0xFF) / 255.0f;
    }

    public static float getGreen(int color) {
        return (float)(color >> 8 & 0xFF) / 255.0f;
    }

    public static float getBlue(int color) {
        return (float)(color & 0xFF) / 255.0f;
    }

    public static float getAlpha(int color) {
        return (float)(color >> 24 & 0xFF) / 255.0f;
    }

    public static class LaserConfig {
        public static final int MAX_TIMER = 100;
        BlockPos first;
        BlockPos second;
        double rotationTime;
        float alpha;
        double beamWidth;
        float[] color;
        public int timer = 100;
        public OffsetEnum xOffset = OffsetEnum.CENTER;
        public OffsetEnum yOffset = OffsetEnum.CENTER;
        public OffsetEnum zOffset = OffsetEnum.CENTER;

        public LaserConfig(BlockPos first, BlockPos second, double rotationTime, float alpha, double beamWidth, float[] color) {
            this.first = first;
            this.second = second;
            this.rotationTime = rotationTime;
            this.alpha = alpha;
            this.beamWidth = beamWidth;
            this.color = color;
        }

        public String toString() {
            return this.second + " : " + this.first;
        }
    }
}

