/*
 * Decompiled with CFR 0.152.
 */
package com.lilypuree.decorative_blocks.setup;

import com.google.common.collect.ImmutableMap;
import com.lilypuree.decorative_blocks.blocks.BarPanelBlock;
import com.lilypuree.decorative_blocks.blocks.BeamBlock;
import com.lilypuree.decorative_blocks.blocks.BrazierBlock;
import com.lilypuree.decorative_blocks.blocks.ChainBlock;
import com.lilypuree.decorative_blocks.blocks.ChandelierBlock;
import com.lilypuree.decorative_blocks.blocks.PalisadeBlock;
import com.lilypuree.decorative_blocks.blocks.PillarBlock;
import com.lilypuree.decorative_blocks.blocks.RockyDirtBlock;
import com.lilypuree.decorative_blocks.blocks.SeatBlock;
import com.lilypuree.decorative_blocks.blocks.SupportBlock;
import com.lilypuree.decorative_blocks.datagen.types.IWoodType;
import com.lilypuree.decorative_blocks.datagen.types.ModWoodTypes;
import com.lilypuree.decorative_blocks.datagen.types.WoodDecorativeBlockTypes;
import com.lilypuree.decorative_blocks.entity.DummyEntityForSitting;
import com.lilypuree.decorative_blocks.items.BurnableBlockItem;
import com.lilypuree.decorative_blocks.setup.ModSetup;
import net.minecraft.block.Block;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;

public class Registration {
    public static final DeferredRegister<Item> ITEMS = new DeferredRegister(ForgeRegistries.ITEMS, "decorative_blocks");
    public static final DeferredRegister<Block> BLOCKS = new DeferredRegister(ForgeRegistries.BLOCKS, "decorative_blocks");
    public static final DeferredRegister<EntityType<?>> ENTITIES = new DeferredRegister(ForgeRegistries.ENTITIES, "decorative_blocks");
    public static final RegistryObject<BarPanelBlock> BAR_PANEL = BLOCKS.register("bar_panel", () -> new BarPanelBlock(Block.Properties.func_200949_a((Material)Material.field_151573_f, (MaterialColor)MaterialColor.field_151646_E).func_200943_b(5.0f).func_200947_a(SoundType.field_185852_e)));
    public static final RegistryObject<ChainBlock> CHAIN = BLOCKS.register("chain", () -> new ChainBlock(Block.Properties.func_200949_a((Material)Material.field_151573_f, (MaterialColor)MaterialColor.field_151646_E).func_200943_b(4.3f).func_200947_a(SoundType.field_185852_e)));
    public static final RegistryObject<ChandelierBlock> CHANDELIER = BLOCKS.register("chandelier", () -> new ChandelierBlock(Block.Properties.func_200945_a((Material)Material.field_151594_q).func_200943_b(0.3f).func_200947_a(SoundType.field_185848_a)));
    public static final RegistryObject<BrazierBlock> BRAZIER = BLOCKS.register("brazier", () -> new BrazierBlock(Block.Properties.func_200945_a((Material)Material.field_151573_f).func_200943_b(3.0f).func_200947_a(SoundType.field_185852_e)));
    public static final RegistryObject<PillarBlock> STONE_PILLAR = BLOCKS.register("stone_pillar", () -> new PillarBlock(Block.Properties.func_200945_a((Material)Material.field_151576_e).func_200948_a(1.5f, 6.5f)));
    public static final RegistryObject<Block> ROCKY_DIRT = BLOCKS.register("rocky_dirt", () -> new RockyDirtBlock());
    public static final Item.Properties modItemProperties = new Item.Properties().func_200916_a(ModSetup.ITEM_GROUP);
    public static final RegistryObject<Item> BAR_PANEL_ITEM = ITEMS.register("bar_panel", () -> new BlockItem((Block)BAR_PANEL.get(), modItemProperties));
    public static final RegistryObject<Item> CHAIN_ITEM = ITEMS.register("chain", () -> new BlockItem((Block)CHAIN.get(), modItemProperties));
    public static final RegistryObject<Item> CHANDELIER_ITEM = ITEMS.register("chandelier", () -> new BurnableBlockItem((Block)CHANDELIER.get(), modItemProperties, 1600));
    public static final RegistryObject<Item> BRAZIER_ITEM = ITEMS.register("brazier", () -> new BlockItem((Block)BRAZIER.get(), modItemProperties));
    public static final RegistryObject<Item> STONE_PILLAR_ITEM = ITEMS.register("stone_pillar", () -> new BlockItem((Block)STONE_PILLAR.get(), modItemProperties));
    public static final RegistryObject<Item> ROCKY_DIRT_ITEM = ITEMS.register("rocky_dirt", () -> new BlockItem((Block)ROCKY_DIRT.get(), modItemProperties));
    public static final RegistryObject<EntityType<DummyEntityForSitting>> DUMMY_ENTITY_TYPE = ENTITIES.register("dummy", () -> EntityType.Builder.func_220322_a(DummyEntityForSitting::new, (EntityClassification)EntityClassification.MISC).setTrackingRange(256).setUpdateInterval(20).func_220321_a(1.0E-4f, 1.0E-4f).func_206830_a("decorative_blocks:dummy"));
    public static final ImmutableMap<String, RegistryObject<Block>> DECORATIVE_BLOCKS;
    public static final ImmutableMap<String, RegistryObject<Item>> DECORATIVE_ITEMBLOCKS;

    public static void register() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ITEMS.register(modEventBus);
        BLOCKS.register(modEventBus);
        ENTITIES.register(modEventBus);
    }

    public static Block getWoodDecorativeBlock(IWoodType wood, WoodDecorativeBlockTypes decorativeBlockType) {
        String name = wood + "_" + (Object)((Object)decorativeBlockType);
        return (Block)((RegistryObject)DECORATIVE_BLOCKS.get((Object)name)).get();
    }

    public static RotatedPillarBlock getBeamBlock(IWoodType wood) {
        return (RotatedPillarBlock)Registration.getWoodDecorativeBlock(wood, WoodDecorativeBlockTypes.BEAM);
    }

    public static PalisadeBlock getPalisadeBlock(IWoodType wood) {
        return (PalisadeBlock)Registration.getWoodDecorativeBlock(wood, WoodDecorativeBlockTypes.PALISADE);
    }

    public static SeatBlock getSeatBlock(IWoodType wood) {
        return (SeatBlock)Registration.getWoodDecorativeBlock(wood, WoodDecorativeBlockTypes.SEAT);
    }

    public static SupportBlock getSupportBlock(IWoodType wood) {
        return (SupportBlock)Registration.getWoodDecorativeBlock(wood, WoodDecorativeBlockTypes.SUPPORT);
    }

    private static Block createDecorativeBlock(IWoodType wood, WoodDecorativeBlockTypes woodDecorativeBlockType) {
        Block.Properties woodProperty = Block.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)MaterialColor.field_151663_o).func_200943_b(1.2f).func_200947_a(SoundType.field_185848_a);
        Block.Properties palisadeProperty = Block.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)MaterialColor.field_151663_o).func_200948_a(2.0f, 4.0f).func_200947_a(SoundType.field_185848_a);
        switch (woodDecorativeBlockType) {
            default: {
                return new BeamBlock(woodProperty);
            }
            case SEAT: {
                return new SeatBlock(woodProperty);
            }
            case SUPPORT: {
                return new SupportBlock(woodProperty);
            }
            case PALISADE: 
        }
        return new PalisadeBlock(palisadeProperty);
    }

    static {
        ImmutableMap.Builder decorativeBlockBuilder = ImmutableMap.builder();
        ImmutableMap.Builder itemBuilder = ImmutableMap.builder();
        for (WoodDecorativeBlockTypes type : WoodDecorativeBlockTypes.values()) {
            for (IWoodType wood : ModWoodTypes.allWoodTypes()) {
                String name = wood + "_" + (Object)((Object)type);
                Block decorativeBlock = Registration.createDecorativeBlock(wood, type);
                decorativeBlockBuilder.put((Object)name, (Object)BLOCKS.register(name, () -> decorativeBlock));
                itemBuilder.put((Object)name, (Object)ITEMS.register(name, () -> new BurnableBlockItem(decorativeBlock, modItemProperties, 300)));
            }
        }
        DECORATIVE_BLOCKS = decorativeBlockBuilder.build();
        DECORATIVE_ITEMBLOCKS = itemBuilder.build();
    }
}

