/*
 * Decompiled with CFR 0.152.
 */
package com.lilypuree.decorative_blocks.blocks;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BonfireBlock
extends Block
implements IWaterLoggable {
    private static final VoxelShape BONFIRE_SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);

    public BonfireBlock(Block.Properties properties) {
        super(properties);
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        BlockPos blockpos = pos.func_177977_b();
        return worldIn.func_180495_p(blockpos).func_224755_d((IBlockReader)worldIn, blockpos, Direction.UP);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return BONFIRE_SHAPE;
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return VoxelShapes.func_197880_a();
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        if (!entityIn.func_70045_F() && entityIn instanceof LivingEntity && !EnchantmentHelper.func_189869_j((LivingEntity)((LivingEntity)entityIn))) {
            entityIn.func_70097_a(DamageSource.field_76372_a, 1.0f);
        }
        super.func_196262_a(state, worldIn, pos, entityIn);
    }

    public boolean isBurning(BlockState state, IBlockReader world, BlockPos pos) {
        return true;
    }

    public int func_149750_m(BlockState state) {
        return 15;
    }

    public boolean func_220067_a(BlockState state, IBlockReader worldIn, BlockPos pos, EntityType<?> type) {
        return false;
    }

    public boolean addDestroyEffects(BlockState state, World world, BlockPos pos, ParticleManager manager) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (rand.nextInt(18) == 0) {
            worldIn.func_184134_a((double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), SoundEvents.field_187643_bs, SoundCategory.BLOCKS, 1.5f + rand.nextFloat(), rand.nextFloat() * 0.7f + 0.3f, false);
        }
        if (rand.nextInt(10) == 0) {
            worldIn.func_184134_a((double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), SoundEvents.field_219605_aC, SoundCategory.BLOCKS, (float)((double)0.6f + (double)rand.nextFloat() * 0.3), rand.nextFloat() * 0.6f + 0.5f, false);
        }
        for (int i = 0; i < 3; ++i) {
            double x = (double)pos.func_177958_n() + rand.nextDouble();
            double y = (double)pos.func_177956_o() + rand.nextDouble() * 0.5 + 1.5;
            double z = (double)pos.func_177952_p() + rand.nextDouble();
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197594_E, x, y, z, -0.03 + rand.nextDouble() * 0.06, rand.nextDouble() * 0.1, -0.03 + rand.nextDouble() * 0.06);
        }
    }

    public boolean func_204510_a(IBlockReader worldIn, BlockPos pos, BlockState state, Fluid fluidIn) {
        return false;
    }

    public boolean func_204509_a(IWorld world, BlockPos pos, BlockState state, IFluidState fluidStateIn) {
        if (fluidStateIn.func_206886_c() == Fluids.field_204546_a) {
            if (!world.func_201670_d()) {
                world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
                world.func_184133_a(null, pos, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 1.2f, 0.6f);
            } else {
                BonfireBlock.spawnExtinguishSmoke(world.func_201672_e(), pos);
            }
            return true;
        }
        return false;
    }

    public static void spawnExtinguishSmoke(World world, BlockPos pos) {
        Random rand = world.func_201674_k();
        for (int i = 0; i < 5; ++i) {
            double d0 = world.func_201674_k().nextGaussian() * 0.02;
            double d1 = world.func_201674_k().nextGaussian() * 0.02;
            double d2 = world.func_201674_k().nextGaussian() * 0.02;
            world.func_195594_a((IParticleData)ParticleTypes.field_197613_f, (double)pos.func_177958_n() + (double)world.field_73012_v.nextFloat(), (double)pos.func_177956_o() + 0.4 + (double)world.field_73012_v.nextFloat(), (double)pos.func_177952_p() + (double)world.field_73012_v.nextFloat(), d0, d1, d2);
        }
        world.func_195594_a((IParticleData)ParticleTypes.field_197601_L, (double)pos.func_177958_n() + 0.25 + rand.nextDouble() / 2.0 * (double)(rand.nextBoolean() ? 1 : -1), (double)pos.func_177956_o() + 0.4, (double)pos.func_177952_p() + 0.25 + rand.nextDouble() / 2.0 * (double)(rand.nextBoolean() ? 1 : -1), 0.0, 0.005, 0.0);
    }

    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.func_220082_b(state, worldIn, pos, oldState, isMoving);
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        return this.func_196260_a(stateIn, (IWorldReader)worldIn, currentPos) ? stateIn : Blocks.field_150350_a.func_176223_P();
    }
}

