/*
 * Decompiled with CFR 0.152.
 */
package com.lilypuree.decorative_blocks.fluid;

import com.lilypuree.decorative_blocks.setup.Registration;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.ILiquidContainer;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidAttributes;

public abstract class ThatchFluid
extends FlowingFluid {
    ResourceLocation thatchStillTexture = new ResourceLocation("decorative_blocks", "block/thatch_still");
    ResourceLocation thatchFlowingTexture = new ResourceLocation("decorative_blocks", "block/thatch_flowing");

    protected FluidAttributes createAttributes() {
        return FluidAttributes.builder((ResourceLocation)this.thatchStillTexture, (ResourceLocation)this.thatchFlowingTexture).overlay(this.thatchStillTexture).sound(SoundEvents.field_219625_by, SoundEvents.field_219625_by).density(200).viscosity(2000).build((Fluid)this);
    }

    public Fluid func_210197_e() {
        return (Fluid)Registration.FLOWING_THATCH.get();
    }

    public Fluid func_210198_f() {
        return (Fluid)Registration.STILL_THATCH.get();
    }

    public Item func_204524_b() {
        return Items.field_151133_ar;
    }

    public int func_185698_b(IWorldReader worldIn) {
        return 2;
    }

    public BlockState func_204527_a(IFluidState state) {
        return (BlockState)((Block)Registration.THATCH.get()).func_176223_P().func_206870_a((IProperty)FlowingFluidBlock.field_176367_b, (Comparable)Integer.valueOf(ThatchFluid.func_207205_e((IFluidState)state)));
    }

    public boolean func_207187_a(Fluid fluidIn) {
        return fluidIn == Registration.STILL_THATCH.get() || fluidIn == Registration.FLOWING_THATCH.get();
    }

    public int func_204528_b(IWorldReader worldIn) {
        return 4;
    }

    protected void func_205580_a(IWorld worldIn, BlockPos pos, BlockState state) {
        TileEntity tileentity = state.func_177230_c().func_149716_u() ? worldIn.func_175625_s(pos) : null;
        Block.func_220059_a((BlockState)state, (World)worldIn.func_201672_e(), (BlockPos)pos, (TileEntity)tileentity);
    }

    public boolean func_215665_a(IFluidState p_215665_1_, IBlockReader p_215665_2_, BlockPos p_215665_3_, Fluid p_215665_4_, Direction p_215665_5_) {
        return false;
    }

    public int func_205569_a(IWorldReader p_205569_1_) {
        return 8;
    }

    protected boolean func_205579_d() {
        return false;
    }

    protected void func_205574_a(IWorld worldIn, BlockPos pos, BlockState blockStateIn, Direction direction, IFluidState fluidStateIn) {
        if (direction == Direction.DOWN) {
            boolean shouldFlowInto = false;
            for (Direction dir : Direction.Plane.HORIZONTAL) {
                BlockPos supportPos = pos.func_177972_a(dir);
                BlockState supportBlock = worldIn.func_180495_p(supportPos);
                IFluidState sourceFluid = worldIn.func_204610_c(pos.func_177972_a(dir).func_177984_a());
                if (!supportBlock.func_224755_d((IBlockReader)worldIn, supportPos, dir.func_176734_d()) || sourceFluid.func_206888_e()) continue;
                shouldFlowInto = true;
            }
            if (!shouldFlowInto) {
                return;
            }
        }
        if (blockStateIn.func_177230_c() instanceof ILiquidContainer) {
            ((ILiquidContainer)blockStateIn.func_177230_c()).func_204509_a(worldIn, pos, blockStateIn, fluidStateIn);
        } else {
            if (!blockStateIn.func_196958_f()) {
                this.func_205580_a(worldIn, pos, blockStateIn);
            }
            worldIn.func_180501_a(pos, fluidStateIn.func_206883_i(), 3);
        }
    }

    protected boolean func_207196_h() {
        return true;
    }

    protected float func_210195_d() {
        return 100.0f;
    }

    public static class Source
    extends ThatchFluid {
        protected void func_207184_a(StateContainer.Builder<Fluid, IFluidState> builder) {
            super.func_207184_a(builder);
        }

        public int func_207192_d(IFluidState p_207192_1_) {
            return 8;
        }

        public boolean func_207193_c(IFluidState state) {
            return true;
        }
    }

    public static class Flowing
    extends ThatchFluid {
        protected void func_207184_a(StateContainer.Builder<Fluid, IFluidState> builder) {
            super.func_207184_a(builder);
            builder.func_206894_a(new IProperty[]{field_207210_b});
        }

        public int func_207192_d(IFluidState p_207192_1_) {
            return (Integer)p_207192_1_.func_177229_b((IProperty)field_207210_b);
        }

        public boolean func_207193_c(IFluidState state) {
            return false;
        }
    }
}

