/*
 * Decompiled with CFR 0.152.
 */
package com.lilypuree.decorative_blocks.setup;

import com.lilypuree.decorative_blocks.Config;
import com.lilypuree.decorative_blocks.blocks.BrazierBlock;
import com.lilypuree.decorative_blocks.entity.DummyEntityForSitting;
import com.lilypuree.decorative_blocks.entity.ItemEntityBonfireActivator;
import com.lilypuree.decorative_blocks.fluid.ThatchFluidBlock;
import com.lilypuree.decorative_blocks.setup.Registration;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.PotionEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.HoeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.state.Property;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="decorative_blocks", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ModSetup {
    public static final ItemGroup ITEM_GROUP = new ItemGroup("decorative_blocks"){

        public ItemStack func_78016_d() {
            return new ItemStack((IItemProvider)Registration.BRAZIER.get());
        }
    };
    private static boolean didSendMessage = false;
    private static Item bonfireActivatorItem = null;

    public void init(FMLCommonSetupEvent e) {
    }

    @SubscribeEvent
    public static void onServerSetUp(FMLServerStartingEvent event) {
    }

    @SubscribeEvent
    public static void onEntityMountEvent(EntityMountEvent event) {
        Entity seat;
        if (!event.getWorldObj().field_72995_K && event.isDismounting() && (seat = event.getEntityBeingMounted()) instanceof DummyEntityForSitting) {
            seat.func_70106_y();
        }
    }

    @SubscribeEvent
    public static void onProjectileCollisionEvent(ProjectileImpactEvent.Throwable event) {
        ThrowableEntity potion = event.getThrowable();
        World world = potion.func_130014_f_();
        BlockPos pos = potion.func_233580_cy_();
        BlockState state = world.func_180495_p(pos);
        if (world.field_72995_K) {
            return;
        }
        if (potion instanceof PotionEntity && PotionUtils.func_185191_c((ItemStack)((PotionEntity)potion).func_184543_l()) == Potions.field_185230_b && state.func_177230_c() == Registration.BRAZIER.get() && ((Boolean)state.func_177229_b((Property)BrazierBlock.LIT)).booleanValue()) {
            world.func_175656_a(pos, (BlockState)state.func_206870_a((Property)BrazierBlock.LIT, (Comparable)Boolean.FALSE));
            world.func_184133_a((PlayerEntity)null, pos, SoundEvents.field_187541_bC, SoundCategory.BLOCKS, 0.8f, 1.0f);
        }
    }

    @SubscribeEvent
    public static void onLeftClickEvent(PlayerInteractEvent.LeftClickBlock event) {
        BlockPos pos;
        World world = event.getWorld();
        Block block = world.func_180495_p(pos = event.getPos()).func_177230_c();
        if (block == Registration.BONFIRE.get()) {
            event.setCanceled(true);
            world.func_217378_a(null, 1009, pos, 0);
            world.func_217377_a(pos, false);
        }
    }

    @SubscribeEvent
    public static void onRightClickEvent(PlayerInteractEvent.RightClickBlock event) {
        World world = event.getWorld();
        Item item = event.getItemStack().func_77973_b();
        BlockPos pos = event.getPos();
        if (!world.func_175667_e(pos)) {
            return;
        }
        Block block = world.func_180495_p(pos).func_177230_c();
        PlayerEntity player = event.getPlayer();
        if (item == Items.field_151097_aZ && block == Blocks.field_150407_cf) {
            if (world.field_72995_K) {
                player.func_184609_a(event.getHand());
            } else if (((Boolean)Config.THATCH_ENABLED.get()).booleanValue()) {
                world.func_175656_a(pos, ((Block)Registration.THATCH.get()).func_176223_P());
                world.func_184133_a(null, pos, SoundEvents.field_219625_by, SoundCategory.BLOCKS, 0.8f, 1.0f);
                event.getItemStack().func_222118_a(1, event.getEntityLiving(), p_220036_0_ -> p_220036_0_.func_213361_c(EquipmentSlotType.MAINHAND));
            }
        }
        if (item instanceof HoeItem) {
            BlockState blockstate1;
            BlockRayTraceResult rayTraceResult = Item.func_219968_a((World)world, (PlayerEntity)player, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.SOURCE_ONLY);
            if (rayTraceResult.func_216346_c() != RayTraceResult.Type.BLOCK) {
                return;
            }
            BlockRayTraceResult blockraytraceresult = rayTraceResult;
            BlockPos blockpos = blockraytraceresult.func_216350_a();
            Direction direction = blockraytraceresult.func_216354_b();
            BlockPos blockpos1 = blockpos.func_177972_a(direction);
            if (world.func_175660_a(player, blockpos) && player.func_175151_a(blockpos1, direction, event.getItemStack()) && (blockstate1 = world.func_180495_p(blockpos)).func_177230_c() instanceof ThatchFluidBlock) {
                event.setCanceled(true);
                if ((Integer)blockstate1.func_177229_b((Property)FlowingFluidBlock.field_176367_b) == 0) {
                    if (world.func_201670_d()) {
                        player.func_184609_a(event.getHand());
                    } else {
                        world.func_184133_a(null, blockpos, SoundEvents.field_219625_by, SoundCategory.BLOCKS, 0.8f, 1.0f);
                        world.func_180501_a(blockpos, Blocks.field_150350_a.func_176223_P(), 11);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void onEntityDamage(LivingDamageEvent event) {
        if (event.getSource() == DamageSource.field_76379_h) {
            LivingEntity entity = event.getEntityLiving();
            BlockPos pos = entity.func_233580_cy_();
            World world = entity.func_130014_f_();
            if (world.func_204610_c(pos).func_206886_c() == ((FlowingFluid)Registration.STILL_THATCH.get()).getFluid()) {
                event.setAmount(event.getAmount() * 0.2f);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerToss(ItemTossEvent event) {
        PlayerEntity player = event.getPlayer();
        ItemEntity thrownItemEntity = event.getEntityItem();
        if (bonfireActivatorItem == null && !ModSetup.isBonfireActivatorConfigValueValid()) {
            if (!didSendMessage) {
                player.func_145747_a((ITextComponent)new TranslationTextComponent("message.decorative_blocks.invalid_bonfire_activator_config"), player.func_110124_au());
                didSendMessage = true;
            }
            return;
        }
        if (thrownItemEntity.func_92059_d().func_77973_b() == bonfireActivatorItem) {
            event.setCanceled(true);
            ItemEntityBonfireActivator bonfireActivator = new ItemEntityBonfireActivator(thrownItemEntity);
            player.func_130014_f_().func_217376_c((Entity)bonfireActivator);
        }
    }

    public static boolean isBonfireActivatorConfigValueValid() {
        String bonfireActivator = (String)Config.BONFIRE_ACTIVATOR.get();
        ResourceLocation bonfireActivatorResourceLocation = ResourceLocation.func_208304_a((String)bonfireActivator);
        if (bonfireActivatorResourceLocation != null && ForgeRegistries.ITEMS.containsKey(bonfireActivatorResourceLocation)) {
            bonfireActivatorItem = (Item)ForgeRegistries.ITEMS.getValue(bonfireActivatorResourceLocation);
            return true;
        }
        return false;
    }
}

