/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.dynamical_compass.elements.recipes.shapless_nbt;

import de.geheimagentnr1.dynamical_compass.elements.recipes.RecipeSerializers;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.RecipeItemHelper;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.util.RecipeMatcher;

public class ShapelessNBTRecipe
implements ICraftingRecipe {
    public static final String registry_name = "crafting_shapeless_nbt";
    private final ResourceLocation id;
    private final String group;
    private final ItemStack recipeOutput;
    private final NonNullList<Ingredient> recipeItems;
    private final boolean isSimple;
    private final boolean merge_nbt;

    public ShapelessNBTRecipe(ResourceLocation idIn, String groupIn, ItemStack recipeOutputIn, NonNullList<Ingredient> recipeItemsIn, boolean _merge_nbt) {
        this.id = idIn;
        this.group = groupIn;
        this.recipeOutput = recipeOutputIn;
        this.recipeItems = recipeItemsIn;
        this.isSimple = recipeItemsIn.stream().allMatch(Ingredient::isSimple);
        this.merge_nbt = _merge_nbt;
    }

    @Nonnull
    public ResourceLocation func_199560_c() {
        return this.id;
    }

    @Nonnull
    public IRecipeSerializer<?> func_199559_b() {
        return RecipeSerializers.SHAPELESS_NBT;
    }

    @Nonnull
    public String func_193358_e() {
        return this.group;
    }

    @Nonnull
    public ItemStack func_77571_b() {
        return this.recipeOutput;
    }

    @Nonnull
    public NonNullList<Ingredient> func_192400_c() {
        return this.recipeItems;
    }

    public boolean matches(CraftingInventory inv, @Nonnull World worldIn) {
        RecipeItemHelper recipeitemhelper = new RecipeItemHelper();
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        int i = 0;
        for (int j = 0; j < inv.func_70302_i_(); ++j) {
            ItemStack itemstack = inv.func_70301_a(j);
            if (itemstack.func_190926_b()) continue;
            ++i;
            if (this.isSimple) {
                recipeitemhelper.func_221264_a(itemstack, 1);
                continue;
            }
            inputs.add(itemstack);
        }
        return i == this.recipeItems.size() && (this.isSimple ? recipeitemhelper.func_194116_a((IRecipe)this, null) : RecipeMatcher.findMatches(inputs, this.recipeItems) != null);
    }

    @Nonnull
    public ItemStack getCraftingResult(@Nonnull CraftingInventory inv) {
        if (this.merge_nbt) {
            for (int j = 0; j < inv.func_70302_i_(); ++j) {
                ItemStack itemstack = inv.func_70301_a(j);
                if (itemstack.func_77973_b() != this.recipeOutput.func_77973_b()) continue;
                ItemStack result = this.recipeOutput.func_77946_l();
                result.func_196082_o().func_197643_a(itemstack.func_196082_o());
                return result;
            }
        }
        return this.recipeOutput.func_77946_l();
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= this.recipeItems.size();
    }

    public boolean isMergeNbt() {
        return this.merge_nbt;
    }
}

