/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.dynamical_compass.elements.items.dynamical_compass;

import de.geheimagentnr1.dynamical_compass.elements.items.dynamical_compass.DynamicalCompassItemStackHelper;
import java.security.SecureRandom;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class DynamicalCompassPropertyGetter
implements IItemPropertyGetter {
    @OnlyIn(value=Dist.CLIENT)
    public float call(@Nonnull ItemStack stack, @Nullable World world, @Nullable LivingEntity livingEntity) {
        double angel;
        if (livingEntity == null && !stack.func_82839_y()) {
            return 0.0f;
        }
        boolean isLivingEntityNotNull = livingEntity != null;
        Entity entity = (Entity)Objects.requireNonNull(isLivingEntityNotNull ? livingEntity : stack.func_82836_z());
        if (world == null) {
            world = entity.field_70170_p;
        }
        if (DynamicalCompassItemStackHelper.isDimensionEqual(stack, world)) {
            double rotation = isLivingEntityNotNull ? (double)entity.field_70177_z : this.getFrameRotation((ItemFrameEntity)entity);
            rotation = MathHelper.func_191273_b((double)(rotation / 360.0), (double)1.0);
            double d2 = this.getSpawnToAngle(stack, entity) / 6.2831854820251465;
            angel = 0.5 - (rotation - 0.25 - d2);
        } else {
            angel = new SecureRandom().nextDouble();
        }
        if (isLivingEntityNotNull) {
            angel = this.wobble(stack, world, angel);
        }
        return MathHelper.func_188207_b((float)((float)angel), (float)1.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    private double wobble(ItemStack stack, World worldIn, double angel) {
        double rotation = DynamicalCompassItemStackHelper.getRotation(stack);
        if (worldIn.func_82737_E() != DynamicalCompassItemStackHelper.getLastUpdateTick(stack)) {
            double rota = DynamicalCompassItemStackHelper.getRota(stack);
            double d0 = angel - rotation;
            d0 = MathHelper.func_191273_b((double)(d0 + 0.5), (double)1.0) - 0.5;
            rota += d0 * 0.1;
            rotation = MathHelper.func_191273_b((double)(rotation + (rota *= 0.8)), (double)1.0);
            DynamicalCompassItemStackHelper.setRotationRotaAndLastUpdateTick(stack, rotation, rota, worldIn.func_82737_E());
        }
        return rotation;
    }

    @OnlyIn(value=Dist.CLIENT)
    private double getFrameRotation(ItemFrameEntity itemFrameEntity) {
        return MathHelper.func_188209_b((int)(180 + itemFrameEntity.func_174811_aO().func_176736_b() * 90));
    }

    @OnlyIn(value=Dist.CLIENT)
    private double getSpawnToAngle(ItemStack stack, Entity entity) {
        BlockPos blockpos = DynamicalCompassItemStackHelper.getDestinationPos(stack);
        return StrictMath.atan2((double)blockpos.func_177952_p() - entity.func_226281_cx_(), (double)blockpos.func_177958_n() - entity.func_226277_ct_());
    }
}

