/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.dynamical_compass.elements.recipes.shapless_nbt;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.geheimagentnr1.dynamical_compass.elements.recipes.shapless_nbt.ShapelessNBTRecipe;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class ShapelessNBTRecipeSerializer
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<ShapelessNBTRecipe> {
    private static final int MAX_WIDTH = 3;
    private static final int MAX_HEIGHT = 3;

    @Nonnull
    public ShapelessNBTRecipe read(@Nonnull ResourceLocation recipeId, @Nonnull JsonObject json) {
        String group = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
        NonNullList<Ingredient> ingredients = ShapelessNBTRecipeSerializer.readIngredients(JSONUtils.func_151214_t((JsonObject)json, (String)"ingredients"));
        if (ingredients.isEmpty()) {
            throw new JsonParseException("No ingredients for shapeless recipe");
        }
        if (ingredients.size() > 9) {
            throw new JsonParseException("Too many ingredients for shapeless recipe the max is 9");
        }
        JsonObject resultJson = JSONUtils.func_152754_s((JsonObject)json, (String)"result");
        ItemStack result = ShapedRecipe.func_199798_a((JsonObject)resultJson);
        try {
            result.func_196082_o().func_197643_a(JsonToNBT.func_180713_a((String)JSONUtils.func_151200_h((JsonObject)resultJson, (String)"nbt")));
        }
        catch (CommandSyntaxException exception) {
            throw new IllegalStateException(exception);
        }
        boolean merge_nbt = JSONUtils.func_151212_i((JsonObject)resultJson, (String)"merge_nbt");
        return new ShapelessNBTRecipe(recipeId, group, result, ingredients, merge_nbt);
    }

    private static NonNullList<Ingredient> readIngredients(JsonArray ingredientsJson) {
        NonNullList ingredients = NonNullList.func_191196_a();
        for (int i = 0; i < ingredientsJson.size(); ++i) {
            Ingredient ingredient = Ingredient.func_199802_a((JsonElement)ingredientsJson.get(i));
            if (ingredient.func_203189_d()) continue;
            ingredients.add((Object)ingredient);
        }
        return ingredients;
    }

    public ShapelessNBTRecipe read(@Nonnull ResourceLocation recipeId, PacketBuffer buffer) {
        String group = buffer.func_150789_c(Short.MAX_VALUE);
        int i = buffer.func_150792_a();
        NonNullList ingredients = NonNullList.func_191197_a((int)i, (Object)Ingredient.field_193370_a);
        for (int j = 0; j < ingredients.size(); ++j) {
            ingredients.set(j, (Object)Ingredient.func_199566_b((PacketBuffer)buffer));
        }
        ItemStack result = buffer.func_150791_c();
        boolean merge_nbt = buffer.readBoolean();
        return new ShapelessNBTRecipe(recipeId, group, result, (NonNullList<Ingredient>)ingredients, merge_nbt);
    }

    public void write(PacketBuffer buffer, ShapelessNBTRecipe recipe) {
        buffer.func_180714_a(recipe.func_193358_e());
        buffer.func_150787_b(recipe.func_192400_c().size());
        for (Ingredient ingredient : recipe.func_192400_c()) {
            ingredient.func_199564_a(buffer);
        }
        buffer.func_150788_a(recipe.func_77571_b());
        buffer.writeBoolean(recipe.isMergeNbt());
    }
}

