/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.dynamical_compass.elements.items.dynamical_compass;

import java.util.Objects;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class DynamicalCompassItemStackHelper {
    private static final String destinationName = "destination";
    private static final String dimensionName = "destination_dimension";
    private static final String posName = "destination_pos";
    private static final String lockedName = "locked";
    private static final String directionDataName = "directionData";
    private static final String rotationName = "rotation";
    private static final String rotaName = "rota";
    private static final String lastUpdateTickName = "last_update_tick";

    public static void setDimensionAndPos(ItemStack stack, World world, BlockPos pos) {
        CompoundNBT compound = new CompoundNBT();
        compound.func_74778_a(dimensionName, Objects.requireNonNull(world.func_234923_W_().func_240901_a_()).toString());
        compound.func_218657_a(posName, (INBT)NBTUtil.func_186859_a((BlockPos)pos));
        stack.func_196082_o().func_218657_a(destinationName, (INBT)compound);
    }

    static boolean isDimensionEqual(ItemStack stack, World world) {
        return Objects.equals(world.func_234923_W_().func_240901_a_(), ResourceLocation.func_208304_a((String)stack.func_196082_o().func_74775_l(destinationName).func_74779_i(dimensionName)));
    }

    static BlockPos getDestinationPos(ItemStack stack) {
        return NBTUtil.func_186861_c((CompoundNBT)stack.func_196082_o().func_74775_l(destinationName).func_74775_l(posName));
    }

    static boolean isLocked(ItemStack stack) {
        return stack.func_196082_o().func_74767_n(lockedName);
    }

    public static void setLocked(ItemStack stack, boolean locked) {
        stack.func_196082_o().func_74757_a(lockedName, locked);
    }

    static void setRotationRotaAndLastUpdateTick(ItemStack stack, double rotation, double rota, long lastUpdateTick) {
        CompoundNBT compound = new CompoundNBT();
        compound.func_74780_a(rotationName, rotation);
        compound.func_74780_a(rotaName, rota);
        compound.func_74772_a(lastUpdateTickName, lastUpdateTick);
        stack.func_196082_o().func_218657_a(directionDataName, (INBT)compound);
    }

    static double getRotation(ItemStack stack) {
        return stack.func_196082_o().func_74775_l(directionDataName).func_74769_h(rotationName);
    }

    static double getRota(ItemStack stack) {
        return stack.func_196082_o().func_74775_l(directionDataName).func_74769_h(rotaName);
    }

    static long getLastUpdateTick(ItemStack stack) {
        return stack.func_196082_o().func_74775_l(directionDataName).func_74763_f(lastUpdateTickName);
    }
}

