/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.recipes_lib.elements.recipes.ingredients.nbt;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.geheimagentnr1.recipes_lib.elements.recipes.ingredients.IngredientSerializers;
import de.geheimagentnr1.recipes_lib.elements.recipes.ingredients.nbt.MatchType;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;

public class NBTIngredient
extends Ingredient {
    static final String registry_name = "nbt";
    private final ItemStack stack;
    private final MatchType matchType;

    NBTIngredient(ItemStack _stack, MatchType _matchType) {
        super(Stream.of(new Ingredient.SingleItemList(_stack)));
        this.stack = _stack;
        this.matchType = _matchType;
    }

    public boolean test(@Nullable ItemStack input) {
        if (input == null || this.stack.func_77973_b() != input.func_77973_b() || this.stack.func_77952_i() != input.func_77952_i()) {
            return false;
        }
        switch (this.matchType) {
            case EQUAL: {
                return this.stack.areShareTagsEqual(input);
            }
            case CONTAINS: {
                return this.containsNBT((INBT)this.stack.func_77978_p(), (INBT)input.func_77978_p());
            }
            case CONTAINS_NONE: {
                return this.containsNoneNBT((INBT)this.stack.func_77978_p(), (INBT)input.func_77978_p());
            }
            case NOT_EQUAL: {
                return !this.stack.areShareTagsEqual(input);
            }
        }
        return false;
    }

    private boolean containsNBT(@Nullable INBT nbt1, @Nullable INBT nbt2) {
        if (nbt1 == nbt2) {
            return true;
        }
        if (nbt1 == null) {
            return true;
        }
        if (nbt2 == null) {
            return false;
        }
        if (nbt1.getClass().equals(nbt2.getClass())) {
            if (nbt1 instanceof CompoundNBT) {
                CompoundNBT compoundnbt = (CompoundNBT)nbt1;
                CompoundNBT compoundnbt1 = (CompoundNBT)nbt2;
                for (String s : compoundnbt.func_150296_c()) {
                    INBT inbt1 = compoundnbt.func_74781_a(s);
                    if (this.containsNBT(inbt1, compoundnbt1.func_74781_a(s))) continue;
                    return false;
                }
                return true;
            }
            if (nbt1 instanceof ListNBT) {
                ListNBT listnbt = (ListNBT)nbt1;
                ListNBT listnbt1 = (ListNBT)nbt2;
                if (listnbt.isEmpty()) {
                    return listnbt1.isEmpty();
                }
                for (INBT inbt : listnbt) {
                    boolean containsNone = true;
                    for (INBT value : listnbt1) {
                        if (!this.containsNBT(inbt, value)) continue;
                        containsNone = false;
                        break;
                    }
                    if (!containsNone) continue;
                    return false;
                }
                return true;
            }
            return nbt1.equals(nbt2);
        }
        return false;
    }

    private boolean containsNoneNBT(@Nullable INBT nbt1, @Nullable INBT nbt2) {
        if (nbt1 == nbt2) {
            return false;
        }
        if (nbt1 == null) {
            return false;
        }
        if (nbt2 == null) {
            return true;
        }
        if (nbt1.getClass().equals(nbt2.getClass())) {
            if (nbt1 instanceof CompoundNBT) {
                CompoundNBT compoundnbt = (CompoundNBT)nbt1;
                CompoundNBT compoundnbt1 = (CompoundNBT)nbt2;
                for (String s : compoundnbt.func_150296_c()) {
                    INBT inbt1 = compoundnbt.func_74781_a(s);
                    if (this.containsNoneNBT(inbt1, compoundnbt1.func_74781_a(s))) continue;
                    return false;
                }
                return true;
            }
            if (nbt1 instanceof ListNBT) {
                ListNBT listnbt = (ListNBT)nbt1;
                ListNBT listnbt1 = (ListNBT)nbt2;
                if (listnbt.isEmpty()) {
                    return false;
                }
                for (INBT inbt : listnbt) {
                    boolean contains = false;
                    for (INBT value : listnbt1) {
                        if (this.containsNoneNBT(inbt, value)) continue;
                        contains = true;
                        break;
                    }
                    if (!contains) continue;
                    return false;
                }
                return true;
            }
            return !nbt1.equals(nbt2);
        }
        return false;
    }

    public boolean isSimple() {
        return false;
    }

    @Nonnull
    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return IngredientSerializers.NBT_INGREDIENT;
    }

    @Nonnull
    public JsonElement func_200304_c() {
        JsonObject json = new JsonObject();
        json.addProperty("type", Objects.requireNonNull(CraftingHelper.getID(IngredientSerializers.NBT_INGREDIENT)).toString());
        json.addProperty("item", Objects.requireNonNull(this.stack.func_77973_b().getRegistryName()).toString());
        json.addProperty("count", (Number)this.stack.func_190916_E());
        if (this.stack.func_77942_o()) {
            json.addProperty(registry_name, this.stack.func_196082_o().toString());
        }
        return json;
    }

    ItemStack getStack() {
        return this.stack;
    }

    MatchType getMatchType() {
        return this.matchType;
    }
}

