/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.recipes_lib.elements.recipes.nbt.shapless_nbt;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import de.geheimagentnr1.recipes_lib.elements.recipes.nbt.NBTRecipeFactory;
import de.geheimagentnr1.recipes_lib.elements.recipes.nbt.NBTRecipeSerializer;
import de.geheimagentnr1.recipes_lib.elements.recipes.nbt.shapless_nbt.ShapelessNBTRecipe;
import de.geheimagentnr1.recipes_lib.elements.recipes.nbt.shapless_nbt.ShapelessNBTRecipeFactory;
import de.geheimagentnr1.recipes_lib.util.Pair;
import javax.annotation.Nonnull;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;

public class ShapelessNBTRecipeSerializer
extends NBTRecipeSerializer<ShapelessNBTRecipe> {
    private static final ShapelessNBTRecipeFactory SHAPELESS_NBT_RECIPE_FACTORY = new ShapelessNBTRecipeFactory();

    public ShapelessNBTRecipeSerializer() {
        this.setRegistryName("crafting_shapeless_nbt");
    }

    @Override
    @Nonnull
    protected Pair<NonNullList<Ingredient>, NBTRecipeFactory<ShapelessNBTRecipe>> readRecipeData(@Nonnull JsonObject json) {
        NonNullList<Ingredient> ingredients = this.readIngredients(JSONUtils.func_151214_t((JsonObject)json, (String)"ingredients"));
        if (ingredients.isEmpty()) {
            throw new JsonParseException("No ingredients for shapeless recipe");
        }
        if (ingredients.size() > 9) {
            throw new JsonParseException("Too many ingredients for shapeless recipe the max is 9");
        }
        return new Pair<NonNullList<Ingredient>, NBTRecipeFactory<ShapelessNBTRecipe>>(ingredients, SHAPELESS_NBT_RECIPE_FACTORY);
    }

    private NonNullList<Ingredient> readIngredients(JsonArray ingredientsJson) {
        NonNullList ingredients = NonNullList.func_191196_a();
        for (int i = 0; i < ingredientsJson.size(); ++i) {
            Ingredient ingredient = Ingredient.func_199802_a((JsonElement)ingredientsJson.get(i));
            if (ingredient.func_203189_d()) continue;
            ingredients.add((Object)ingredient);
        }
        return ingredients;
    }

    @Override
    @Nonnull
    protected Pair<Integer, NBTRecipeFactory<ShapelessNBTRecipe>> readRecipeData(@Nonnull PacketBuffer buffer) {
        return new Pair<Integer, NBTRecipeFactory<ShapelessNBTRecipe>>(buffer.func_150792_a(), SHAPELESS_NBT_RECIPE_FACTORY);
    }

    @Override
    protected void writeRecipeData(@Nonnull PacketBuffer buffer, @Nonnull ShapelessNBTRecipe recipe) {
        buffer.func_150787_b(recipe.func_192400_c().size());
    }
}

