/*
 * Decompiled with CFR 0.152.
 */
package com.eractnod.ediblebugs;

import com.eractnod.ediblebugs.config.Config;
import com.eractnod.ediblebugs.config.EdiblebugsConfig;
import com.eractnod.ediblebugs.recipe.AllRecipes;
import com.eractnod.ediblebugs.setup.ClientProxy;
import com.eractnod.ediblebugs.setup.EdiblebugsSetup;
import com.eractnod.ediblebugs.setup.IProxy;
import com.eractnod.ediblebugs.setup.ModSetup;
import com.eractnod.ediblebugs.setup.ServerProxy;
import com.eractnod.ediblebugs.worldgen.TermiteMoundGen;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.TableLootEntry;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.gen.feature.Feature;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="ediblebugs")
public class EdibleBugs {
    public static final String MODID = "ediblebugs";
    public static IProxy proxy = (IProxy)DistExecutor.safeRunForDist(() -> ClientProxy::new, () -> ServerProxy::new);
    public static ModSetup setup = new ModSetup();
    private static final Logger LOGGER = LogManager.getLogger();

    public EdibleBugs() {
        Config.loadConfig(Config.CLIENT_CONFIG, FMLPaths.CONFIGDIR.get().resolve("ediblebugs-client.toml"));
        Config.loadConfig(Config.COMMON_CONFIG, FMLPaths.CONFIGDIR.get().resolve("ediblebugs-common.toml"));
        EdiblebugsSetup.register();
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(IRecipeSerializer.class, EdibleBugs::registerRecipes);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(Feature.class, TermiteMoundGen::registerFeatures);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.HIGH, TermiteMoundGen::onLoadEvent);
    }

    public static void registerRecipes(RegistryEvent.Register<IRecipeSerializer<?>> event) {
        AllRecipes.register(event);
    }

    private void setup(FMLCommonSetupEvent event) {
        setup.init();
        proxy.init();
    }

    @SubscribeEvent
    public void onLootLoad(LootTableLoadEvent event) {
        if (((Boolean)EdiblebugsConfig.ALLOWWOODBUGS.get()).booleanValue()) {
            if (event.getName().equals((Object)new ResourceLocation("minecraft", "blocks/oak_log"))) {
                event.getTable().addPool(LootPool.func_216096_a().func_216045_a((LootEntry.Builder)TableLootEntry.func_216171_a((ResourceLocation)new ResourceLocation(MODID, "blocks/oak_log"))).func_216044_b());
            }
            if (event.getName().equals((Object)new ResourceLocation("minecraft", "blocks/spruce_log"))) {
                event.getTable().addPool(LootPool.func_216096_a().func_216045_a((LootEntry.Builder)TableLootEntry.func_216171_a((ResourceLocation)new ResourceLocation(MODID, "blocks/spruce_log"))).func_216044_b());
            }
            if (event.getName().equals((Object)new ResourceLocation("minecraft", "blocks/birch_log"))) {
                event.getTable().addPool(LootPool.func_216096_a().func_216045_a((LootEntry.Builder)TableLootEntry.func_216171_a((ResourceLocation)new ResourceLocation(MODID, "blocks/birch_log"))).func_216044_b());
            }
            if (event.getName().equals((Object)new ResourceLocation("minecraft", "blocks/jungle_log"))) {
                event.getTable().addPool(LootPool.func_216096_a().func_216045_a((LootEntry.Builder)TableLootEntry.func_216171_a((ResourceLocation)new ResourceLocation(MODID, "blocks/jungle_log"))).func_216044_b());
            }
            if (event.getName().equals((Object)new ResourceLocation("minecraft", "blocks/acacia_log"))) {
                event.getTable().addPool(LootPool.func_216096_a().func_216045_a((LootEntry.Builder)TableLootEntry.func_216171_a((ResourceLocation)new ResourceLocation(MODID, "blocks/acacia_log"))).func_216044_b());
            }
            if (event.getName().equals((Object)new ResourceLocation("minecraft", "blocks/dark_oak_log"))) {
                event.getTable().addPool(LootPool.func_216096_a().func_216045_a((LootEntry.Builder)TableLootEntry.func_216171_a((ResourceLocation)new ResourceLocation(MODID, "blocks/dark_oak_log"))).func_216044_b());
            }
        }
        if (((Boolean)EdiblebugsConfig.ALLOWSANDBUGS.get()).booleanValue() && event.getName().equals((Object)new ResourceLocation("minecraft", "blocks/sand"))) {
            event.getTable().addPool(LootPool.func_216096_a().func_216045_a((LootEntry.Builder)TableLootEntry.func_216171_a((ResourceLocation)new ResourceLocation(MODID, "blocks/sand"))).func_216044_b());
        }
        if (((Boolean)EdiblebugsConfig.ALLOWDIRTBUGS.get()).booleanValue() && event.getName().equals((Object)new ResourceLocation("minecraft", "blocks/dirt"))) {
            event.getTable().addPool(LootPool.func_216096_a().func_216045_a((LootEntry.Builder)TableLootEntry.func_216171_a((ResourceLocation)new ResourceLocation(MODID, "blocks/dirt"))).func_216044_b());
        }
        if (((Boolean)EdiblebugsConfig.ALLOWGRASSBUGS.get()).booleanValue() && event.getName().equals((Object)new ResourceLocation("minecraft", "blocks/grass_block"))) {
            event.getTable().addPool(LootPool.func_216096_a().func_216045_a((LootEntry.Builder)TableLootEntry.func_216171_a((ResourceLocation)new ResourceLocation(MODID, "blocks/grass_block"))).func_216044_b());
        }
    }
}

