/*
 * Decompiled with CFR 0.152.
 */
package com.eractnod.ediblebugs.module.fryer;

import com.eractnod.ediblebugs.module.ModBlocks;
import com.eractnod.ediblebugs.module.fryer.FryerTile;
import com.eractnod.ediblebugs.module.fryer.SlotFryer;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.IntReferenceHolder;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class FryerContainer
extends Container {
    private FryerTile tileEntity;
    private PlayerEntity playerEntity;
    private IItemHandler playerInventory;
    private World world;
    private int lastCookTime;
    private int lastBurnTime;
    private int lastItemBurnTime;
    private final List<IContainerListener> listeners = Lists.newArrayList();

    public FryerContainer(int windowId, World world, BlockPos pos, PlayerInventory playerInventory, PlayerEntity player) {
        super(ModBlocks.FRYER_CONTAINER, windowId);
        this.tileEntity = (FryerTile)world.func_175625_s(pos);
        this.playerEntity = player;
        this.playerInventory = new InvWrapper((IInventory)playerInventory);
        this.world = world;
        this.func_75146_a(new Slot((IInventory)this.tileEntity, 0, 56, 17));
        this.func_75146_a(new Slot((IInventory)this.tileEntity, 1, 56, 53));
        this.func_75146_a(new SlotFryer(player, (IInventory)this.tileEntity, 2, 116, 35));
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.func_75146_a(new Slot((IInventory)playerInventory, k, 8 + k * 18, 142));
        }
        this.func_216958_a(new IntReferenceHolder(){

            public int func_221495_b() {
                return FryerContainer.this.getFurnaceCookTime();
            }

            public void func_221494_a(int value) {
                FryerContainer.this.tileEntity.setFurnaceCookTime(value);
            }
        });
        this.func_216958_a(new IntReferenceHolder(){

            public int func_221495_b() {
                return FryerContainer.this.getFurnaceCookTimeTotal();
            }

            public void func_221494_a(int value) {
                FryerContainer.this.tileEntity.setFurnaceCookTimeTotal(value);
            }
        });
        this.func_216958_a(new IntReferenceHolder(){

            public int func_221495_b() {
                return FryerContainer.this.getFurnaceBurnTime();
            }

            public void func_221494_a(int value) {
                FryerContainer.this.tileEntity.setFurnaceBurnTime(value);
            }
        });
    }

    public int getFurnaceCookTime() {
        return this.tileEntity.cookTime;
    }

    public int getFurnaceCookTimeTotal() {
        return this.tileEntity.cookTimeTotal;
    }

    public int getFurnaceBurnTime() {
        return this.tileEntity.burnTime;
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return FryerContainer.func_216963_a((IWorldPosCallable)IWorldPosCallable.func_221488_a((World)this.tileEntity.func_145831_w(), (BlockPos)this.tileEntity.func_174877_v()), (PlayerEntity)this.playerEntity, (Block)ModBlocks.FRYER);
    }

    public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (index == 2) {
                if (!this.func_75135_a(itemstack1, 3, 39, true)) {
                    return ItemStack.field_190927_a;
                }
                slot.func_75220_a(itemstack1, itemstack);
            } else if (index != 1 && index != 0 ? (this.Result(itemstack1) ? !this.func_75135_a(itemstack1, 0, 1, false) : (this.isFuel(itemstack1) ? !this.func_75135_a(itemstack1, 1, 2, false) : (index >= 3 && index < 30 ? !this.func_75135_a(itemstack1, 30, 39, false) : index >= 30 && index < 39 && !this.func_75135_a(itemstack1, 3, 30, false)))) : !this.func_75135_a(itemstack1, 3, 39, false)) {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (itemstack1.func_190916_E() == itemstack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(playerIn, itemstack1);
        }
        return itemstack;
    }

    protected boolean isFuel(ItemStack stack) {
        return FryerTile.isFuel(stack);
    }

    protected boolean Result(ItemStack stack) {
        return true;
    }

    private int addSlotRange(IItemHandler handler, int index, int x, int y, int amount, int dx) {
        for (int i = 0; i < amount; ++i) {
            this.func_75146_a((Slot)new SlotItemHandler(handler, index, x, y));
            x += dx;
            ++index;
        }
        return index;
    }

    private int addSlotBox(IItemHandler handler, int index, int x, int y, int horAmount, int dx, int verAmount, int dy) {
        for (int j = 0; j < verAmount; ++j) {
            index = this.addSlotRange(handler, index, x, y, horAmount, dx);
            y += dy;
        }
        return index;
    }

    private void layoutPlayerInventorySlots(int leftCol, int topRow) {
        this.addSlotBox(this.playerInventory, 9, leftCol, topRow, 9, 18, 3, 18);
        this.addSlotRange(this.playerInventory, 0, leftCol, topRow += 58, 9, 18);
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getCookProgressionScaled() {
        int i = this.tileEntity.cookTime;
        int j = this.tileEntity.cookTimeTotal;
        return j != 0 && i != 0 ? i * 24 / j : 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getBurnLeftScaled() {
        int i = 1600;
        if (i == 0) {
            i = 200;
        }
        return this.tileEntity.burnTime * 13 / i;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_217061_l() {
        return this.tileEntity.burnTime > 0;
    }
}

