/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.environmentalcreepers.event;

import fi.dy.masa.environmentalcreepers.EnvironmentalCreepers;
import fi.dy.masa.environmentalcreepers.config.Configs;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SExplosionPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameters;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class ExplosionEventHandler {
    private final Field fieldExplosionSize = ObfuscationReflectionHelper.findField(Explosion.class, (String)"field_77280_f");
    private final Field fieldExplosionMode = ObfuscationReflectionHelper.findField(Explosion.class, (String)"field_222260_b");
    private final Field fieldCausesFire = ObfuscationReflectionHelper.findField(Explosion.class, (String)"field_77286_a");

    @SubscribeEvent
    public void onExplosionStart(ExplosionEvent.Start event) {
        Explosion explosion = event.getExplosion();
        if (Configs.Lists.explosionClassListType == Configs.ListType.WHITELIST && !Configs.EXPLOSION_CLASS_WHITELIST.contains(explosion.getClass()) || Configs.Lists.explosionClassListType == Configs.ListType.BLACKLIST && Configs.EXPLOSION_CLASS_BLACKLIST.contains(explosion.getClass())) {
            if (Configs.Generic.verboseLogging) {
                EnvironmentalCreepers.logInfo("Explosion (blocked by white- or blacklist): class: {}, position: {}", explosion.getClass().getName(), explosion.getPosition());
            }
            return;
        }
        if (Configs.Generic.verboseLogging) {
            EnvironmentalCreepers.logInfo("Explosion: class: {}, position: {}", explosion.getClass().getName(), explosion.getPosition());
        }
        if (explosion.func_94613_c() instanceof CreeperEntity) {
            if (Configs.Toggles.modifyCreeperExplosionDropChance && !Configs.Toggles.disableCreeperExplosionBlockDamage) {
                this.replaceExplosion(event, true);
            }
        } else if (Configs.Toggles.modifyOtherExplosionDropChance && !Configs.Toggles.disableOtherExplosionBlockDamage) {
            this.replaceExplosion(event, false);
        }
    }

    @SubscribeEvent
    public void onExplosionDetonate(ExplosionEvent.Detonate event) {
        Explosion explosion = event.getExplosion();
        if (Configs.Lists.explosionClassListType == Configs.ListType.WHITELIST && !Configs.EXPLOSION_CLASS_WHITELIST.contains(explosion.getClass()) || Configs.Lists.explosionClassListType == Configs.ListType.BLACKLIST && Configs.EXPLOSION_CLASS_BLACKLIST.contains(explosion.getClass())) {
            return;
        }
        if (explosion.func_94613_c() instanceof CreeperEntity) {
            if (Configs.Toggles.disableCreeperExplosionItemDamage) {
                this.removeItemEntities(event.getAffectedEntities(), true);
            }
            if (Configs.Toggles.disableCreeperExplosionBlockDamage) {
                EnvironmentalCreepers.logInfo("ExplosionEventHandler - clearAffectedBlockPositions() - Type: 'Creeper'", new Object[0]);
                explosion.func_180342_d();
            }
            if (Configs.Toggles.enableCreeperExplosionChainReaction) {
                this.causeCreeperChainReaction(event.getWorld(), explosion.getPosition());
            }
        } else {
            if (Configs.Toggles.disableOtherExplosionItemDamage) {
                this.removeItemEntities(event.getAffectedEntities(), false);
            }
            if (Configs.Toggles.disableOtherExplosionBlockDamage) {
                EnvironmentalCreepers.logInfo("ExplosionEventHandler - clearAffectedBlockPositions() - Type: 'Other'", new Object[0]);
                explosion.func_180342_d();
            }
        }
    }

    private void removeItemEntities(List<Entity> list, boolean isCreeper) {
        EnvironmentalCreepers.logInfo("ExplosionEventHandler.removeItemEntities() - Type: '{}'", isCreeper ? "Creeper" : "Other");
        Iterator<Entity> iter = list.iterator();
        Configs.ListType type = Configs.Lists.entityClassListType;
        while (iter.hasNext()) {
            Entity entity = iter.next();
            if (!(entity instanceof ItemEntity) || type != Configs.ListType.NONE && (type != Configs.ListType.WHITELIST || !Configs.EXPLOSION_ENTITY_WHITELIST.contains(entity.getClass())) && (type != Configs.ListType.BLACKLIST || Configs.EXPLOSION_ENTITY_BLACKLIST.contains(entity.getClass()))) continue;
            iter.remove();
        }
    }

    private void replaceExplosion(ExplosionEvent.Start event, boolean isCreeper) {
        World world = event.getWorld();
        Explosion explosion = event.getExplosion();
        if (Configs.Generic.verboseLogging) {
            EnvironmentalCreepers.logInfo("Replacing the explosion for type '{}' (class: {})", isCreeper ? "Creeper" : "Other", explosion.getClass().getName());
        }
        try {
            float explosionSize;
            boolean causesFire = this.fieldCausesFire.getBoolean(explosion);
            Explosion.Mode mode = (Explosion.Mode)this.fieldExplosionMode.get(explosion);
            if (isCreeper && Configs.Toggles.modifyCreeperExplosionStrength) {
                explosionSize = ((CreeperEntity)explosion.func_94613_c()).func_70830_n() ? (float)Configs.Generic.creeperExplosionStrengthCharged : (float)Configs.Generic.creeperExplosionStrengthNormal;
                this.fieldExplosionSize.setFloat(explosion, explosionSize);
            } else {
                explosionSize = this.fieldExplosionSize.getFloat(explosion);
            }
            explosion.func_77278_a();
            if (world instanceof ServerWorld) {
                ServerWorld serverWorld = (ServerWorld)world;
                this.doExplosionB(world, explosion, mode, false, causesFire, explosionSize, isCreeper);
                if (mode == Explosion.Mode.NONE) {
                    explosion.func_180342_d();
                }
                Vec3d pos = explosion.getPosition();
                for (PlayerEntity player : serverWorld.func_217369_A()) {
                    if (!(player.func_70092_e(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c) < 4096.0)) continue;
                    ((ServerPlayerEntity)player).field_71135_a.func_147359_a((IPacket)new SExplosionPacket(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, explosionSize, explosion.func_180343_e(), (Vec3d)explosion.func_77277_b().get(player)));
                }
            } else {
                this.doExplosionB(world, explosion, mode, true, causesFire, explosionSize, isCreeper);
            }
        }
        catch (IllegalAccessException e) {
            EnvironmentalCreepers.logger.error("IllegalAccessException while reflecting explosion fields", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            EnvironmentalCreepers.logger.error("IllegalArgumentException while reflecting explosion fields", (Throwable)e);
        }
        event.setCanceled(true);
    }

    private void doExplosionB(World world, Explosion explosion, Explosion.Mode mode, boolean spawnParticles, boolean causesFire, float explosionSize, boolean isCreeper) {
        Vec3d posVec = explosion.getPosition();
        Random rand = world.field_73012_v;
        boolean breaksBlock = mode != Explosion.Mode.NONE && (isCreeper ? !Configs.Toggles.disableCreeperExplosionBlockDamage : !Configs.Toggles.disableOtherExplosionBlockDamage);
        world.func_184148_a(null, posVec.field_72450_a, posVec.field_72448_b, posVec.field_72449_c, SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 4.0f, (1.0f + (rand.nextFloat() - rand.nextFloat()) * 0.2f) * 0.7f);
        if (explosionSize >= 2.0f && breaksBlock) {
            world.func_195594_a((IParticleData)ParticleTypes.field_197626_s, posVec.field_72450_a, posVec.field_72448_b, posVec.field_72449_c, 1.0, 0.0, 0.0);
        } else {
            world.func_195594_a((IParticleData)ParticleTypes.field_197627_t, posVec.field_72450_a, posVec.field_72448_b, posVec.field_72449_c, 1.0, 0.0, 0.0);
        }
        float dropChance = (float)(isCreeper ? Configs.Generic.creeperExplosionBlockDropChance : Configs.Generic.otherExplosionBlockDropChance);
        EnvironmentalCreepers.logInfo("ExplosionEventHandler.doExplosionB() - Type: '{}', drop chance: {}", isCreeper ? "Creeper" : "Other", Float.valueOf(dropChance));
        if (breaksBlock) {
            for (BlockPos pos : explosion.func_180343_e()) {
                BlockState state = world.func_180495_p(pos);
                if (spawnParticles) {
                    double d0 = (float)pos.func_177958_n() + rand.nextFloat();
                    double d1 = (float)pos.func_177956_o() + rand.nextFloat();
                    double d2 = (float)pos.func_177952_p() + rand.nextFloat();
                    double d3 = d0 - posVec.field_72450_a;
                    double d4 = d1 - posVec.field_72448_b;
                    double d5 = d2 - posVec.field_72449_c;
                    double d6 = MathHelper.func_76133_a((double)(d3 * d3 + d4 * d4 + d5 * d5));
                    d3 /= d6;
                    d4 /= d6;
                    d5 /= d6;
                    double d7 = 0.5 / (d6 / (double)explosionSize + 0.1);
                    world.func_195594_a((IParticleData)ParticleTypes.field_197598_I, (d0 + posVec.field_72450_a) / 2.0, (d1 + posVec.field_72448_b) / 2.0, (d2 + posVec.field_72449_c) / 2.0, d3 *= (d7 *= (double)(rand.nextFloat() * rand.nextFloat() + 0.3f)), d4 *= d7, d5 *= d7);
                    world.func_195594_a((IParticleData)ParticleTypes.field_197601_L, d0, d1, d2, d3, d4, d5);
                }
                if (state.isAir((IBlockReader)world, pos)) continue;
                if (world instanceof ServerWorld && state.canDropFromExplosion((IBlockReader)world, pos, explosion) && dropChance > 0.0f) {
                    ServerWorld serverWorld = (ServerWorld)world;
                    TileEntity te = state.hasTileEntity() ? world.func_175625_s(pos) : null;
                    LootContext.Builder builder = new LootContext.Builder(serverWorld).func_216023_a(rand).func_216015_a(LootParameters.field_216286_f, (Object)pos).func_216015_a(LootParameters.field_216289_i, (Object)ItemStack.field_190927_a).func_216021_b(LootParameters.field_216288_h, (Object)te);
                    if (dropChance < 1.0f) {
                        float size = 1.0f / dropChance;
                        builder.func_216015_a(LootParameters.field_216290_j, (Object)Float.valueOf(size));
                    }
                    Block.func_220078_b((BlockState)state, (LootContext.Builder)builder);
                }
                state.onBlockExploded(world, pos, explosion);
            }
        }
        if (causesFire) {
            for (BlockPos pos : explosion.func_180343_e()) {
                if (!world.func_180495_p(pos).isAir((IBlockReader)world, pos) || !world.func_180495_p(pos.func_177977_b()).func_200015_d((IBlockReader)world, pos.func_177977_b()) || rand.nextInt(3) != 0) continue;
                world.func_175656_a(pos, Blocks.field_150480_ab.func_176223_P());
            }
        }
    }

    private void causeCreeperChainReaction(World world, Vec3d explosionPos) {
        EnvironmentalCreepers.logInfo("ExplosionEventHandler.causeCreeperChainReaction() - Explosion Position: '{}'", explosionPos);
        double r = Configs.Generic.creeperChainReactionMaxDistance;
        double rSq = r * r;
        AxisAlignedBB bb = new AxisAlignedBB(explosionPos.field_72450_a - r, explosionPos.field_72448_b - r, explosionPos.field_72449_c - r, explosionPos.field_72450_a + r, explosionPos.field_72448_b + r, explosionPos.field_72449_c + r);
        List list = world.func_175647_a(CreeperEntity.class, bb, ent -> ent instanceof LivingEntity && ent.func_110143_aJ() > 0.0f);
        for (CreeperEntity creeper : list) {
            if (creeper.func_146078_ca() || !((double)world.field_73012_v.nextFloat() < Configs.Generic.creeperChainReactionChance) || !(creeper.func_70092_e(explosionPos.field_72450_a, explosionPos.field_72448_b, explosionPos.field_72449_c) <= rSq)) continue;
            EnvironmentalCreepers.logInfo("ExplosionEventHandler.causeCreeperChainReaction() - Igniting Creeper: '{}'", creeper.toString());
            creeper.func_146079_cb();
        }
    }
}

