/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.environmentalcreepers;

import com.mojang.brigadier.CommandDispatcher;
import fi.dy.masa.environmentalcreepers.commands.CommandReloadConfig;
import fi.dy.masa.environmentalcreepers.config.Configs;
import fi.dy.masa.environmentalcreepers.event.ExplosionEventHandler;
import java.io.File;
import net.minecraft.command.CommandSource;
import net.minecraft.world.storage.FolderName;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.ExtensionPoint;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLFingerprintViolationEvent;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="environmentalcreepers")
public class EnvironmentalCreepers {
    public static final Logger logger = LogManager.getLogger((String)"environmentalcreepers");

    public EnvironmentalCreepers() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, Configs.COMMON_CONFIG, "environmentalcreepers.toml");
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onCommonSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onFingerPrintViolation);
        ModLoadingContext.get().registerExtensionPoint(ExtensionPoint.DISPLAYTEST, () -> Pair.of(() -> "OHNOES\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31", (incoming, isNetwork) -> true));
        MinecraftForge.EVENT_BUS.register((Object)new ExplosionEventHandler());
        MinecraftForge.EVENT_BUS.addListener(this::onServerAboutToStart);
        MinecraftForge.EVENT_BUS.addListener(this::onServerStarting);
        MinecraftForge.EVENT_BUS.addListener(this::serverStopping);
        Configs.loadConfig(FMLPaths.CONFIGDIR.get().resolve("environmentalcreepers.toml"));
    }

    private void onCommonSetup(FMLCommonSetupEvent event) {
        Configs.setGlobalConfigDirAndLoadConfigs(FMLPaths.CONFIGDIR.get().toFile());
    }

    private void onFingerPrintViolation(FMLFingerprintViolationEvent event) {
        if (!event.isDirectory()) {
            logger.warn("*********************************************************************************************");
            logger.warn("*****                                    WARNING                                        *****");
            logger.warn("*****                                                                                   *****");
            logger.warn("*****   The signature of the mod file '{}' does not match the expected fingerprint!     *****", (Object)event.getSource().getName());
            logger.warn("*****   This might mean that the mod file has been tampered with!                       *****");
            logger.warn("*****   If you did not download the mod {} directly from Curse/CurseForge,       *****", (Object)"Environmental Creepers");
            logger.warn("*****   or using one of the well known launchers, and you did not                       *****");
            logger.warn("*****   modify the mod file at all yourself, then it's possible,                        *****");
            logger.warn("*****   that it may contain malware or other unwanted things!                           *****");
            logger.warn("*********************************************************************************************");
        }
    }

    private void onServerAboutToStart(FMLServerAboutToStartEvent event) {
        File dataDir = event.getServer().func_240776_a_(new FolderName("environmentalcreepers")).toFile();
        Configs.loadConfigsFromPerWorldConfigIfExists(dataDir);
    }

    private void onServerStarting(FMLServerStartingEvent event) {
        CommandReloadConfig.register((CommandDispatcher<CommandSource>)event.getCommandDispatcher());
    }

    private void serverStopping(FMLServerStoppingEvent event) {
        Configs.loadConfigsFromGlobalConfigFile();
    }

    public static void logInfo(String message, Object ... params) {
        if (Configs.Generic.verboseLogging) {
            logger.info(message, params);
        }
    }
}

