/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.environmentalcreepers.config;

import com.google.common.io.Files;
import fi.dy.masa.environmentalcreepers.EnvironmentalCreepers;
import java.io.File;

public class ConfigFileUtils {
    public static void createDirIfNotExists(File dir) {
        if (!dir.exists()) {
            try {
                dir.mkdirs();
            }
            catch (Exception e) {
                EnvironmentalCreepers.logger.warn("Failed to create the directory '{}'", (Object)dir.getAbsolutePath(), (Object)e);
            }
        }
    }

    public static void tryCopyConfigIfMissing(File fileToReplace, File replacementFile) {
        if (replacementFile.exists() && replacementFile.isFile() && replacementFile.canRead() && !fileToReplace.exists()) {
            try {
                EnvironmentalCreepers.logger.info("Copying the file '{}' to the new location '{}'", (Object)replacementFile.getAbsolutePath(), (Object)fileToReplace.getAbsolutePath());
                Files.copy((File)replacementFile, (File)fileToReplace);
            }
            catch (Exception e) {
                EnvironmentalCreepers.logger.warn("Failed to copy the file '{}' to the new location '{}'", (Object)replacementFile.getAbsolutePath(), (Object)fileToReplace.getAbsolutePath(), (Object)e);
            }
        }
    }
}

