/*
 * Decompiled with CFR 0.152.
 */
package harmonised.explosiont.events;

import harmonised.explosiont.config.Config;
import harmonised.explosiont.events.ChunkDataHandler;
import harmonised.explosiont.util.BlockInfo;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.event.world.ExplosionEvent;

public class ExplosionHandler {
    private static final boolean ExplosionHealingEnabled = Config.config.ExplosionHealingEnabled.get();
    private static final boolean OnlyHealCreepers = Config.config.OnlyHealCreepers.get();
    private static final int healDelayExplosion = Config.config.healDelayExplosion.get();
    private static final double ticksPerHealExplosion = Config.config.ticksPerHealExplosion.get();

    public static void handleExplosion(ExplosionEvent.Detonate event) {
        if (ExplosionHealingEnabled) {
            if (OnlyHealCreepers && !(event.getExplosion().func_199591_b().func_76346_g() instanceof CreeperEntity)) {
                return;
            }
            ArrayList<BlockInfo> blocks = new ArrayList<BlockInfo>();
            World world = event.getWorld();
            ResourceLocation dimResLoc = world.func_234922_V_().func_240901_a_();
            if (!ChunkDataHandler.toHealDimMap.containsKey(dimResLoc)) {
                ChunkDataHandler.toHealDimMap.put(dimResLoc, new HashMap());
            }
            if (!ChunkDataHandler.toHealDimMap.get(dimResLoc).containsKey(0)) {
                ChunkDataHandler.toHealDimMap.get(dimResLoc).put(0, new ArrayList());
            }
            List<BlockInfo> blocksToHeal = ChunkDataHandler.toHealDimMap.get(dimResLoc).get(0);
            int i = 0;
            List affectedBlocks = event.getAffectedBlocks();
            affectedBlocks.sort(Comparator.comparingInt(Vector3i::func_177956_o));
            for (BlockPos blockPos : affectedBlocks) {
                BlockState blockState = world.func_180495_p(blockPos);
                Block block = blockState.func_177230_c();
                if (block.equals(Blocks.field_150350_a) || block.equals(Blocks.field_201941_jj) || block.equals(Blocks.field_201940_ji) || block.equals(Blocks.field_150480_ab) || !world.func_180495_p(blockPos).canDropFromExplosion((IBlockReader)world, blockPos, event.getExplosion())) continue;
                if (block.equals(Blocks.field_150427_aO)) {
                    blockState = Blocks.field_150480_ab.func_176223_P();
                }
                TileEntity tileEntity = world.func_175625_s(blockPos);
                CompoundNBT tileEntityNBT = null;
                if (tileEntity != null) {
                    tileEntityNBT = tileEntity.serializeNBT();
                }
                BlockInfo blockInfo = new BlockInfo(dimResLoc, blockState, blockPos, (int)((double)healDelayExplosion + ticksPerHealExplosion * (double)i), 0, tileEntityNBT);
                blocks.add(blockInfo);
                ++i;
            }
            blocks.forEach(info -> {
                if (!info.state.func_200132_m()) {
                    world.func_175713_t(info.pos);
                    world.func_175656_a(info.pos, Blocks.field_150350_a.func_176223_P());
                }
            });
            blocks.forEach(info -> {
                if (info.state.func_200132_m()) {
                    world.func_175713_t(info.pos);
                    world.func_175656_a(info.pos, Blocks.field_150350_a.func_176223_P());
                }
            });
            blocksToHeal.removeAll(blocks);
            blocksToHeal.addAll(blocks);
            blocksToHeal.sort(Comparator.comparingInt(info -> info.pos.func_177956_o()));
        }
    }
}

