/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.fakeblocks;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

public class Config {
    public static final ServerConfig SERVER;
    public static final ForgeConfigSpec SERVER_SPEC;
    public static final ClientConfig CLIENT;
    public static final ForgeConfigSpec CLIENT_SPEC;

    @Nullable
    private static Block getBlock(String name) {
        return (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(name));
    }

    static {
        Pair specPairServer = new ForgeConfigSpec.Builder().configure(ServerConfig::new);
        SERVER_SPEC = (ForgeConfigSpec)specPairServer.getRight();
        SERVER = (ServerConfig)specPairServer.getLeft();
        Pair specPairClient = new ForgeConfigSpec.Builder().configure(ClientConfig::new);
        CLIENT_SPEC = (ForgeConfigSpec)specPairClient.getRight();
        CLIENT = (ClientConfig)specPairClient.getLeft();
    }

    public static class ClientConfig {
        public ClientConfig(ForgeConfigSpec.Builder builder) {
        }
    }

    public static class ServerConfig {
        private static ForgeConfigSpec.ConfigValue<List<? extends String>> FAKE_BLOCK_BLACKLIST;

        public ServerConfig(ForgeConfigSpec.Builder builder) {
            FAKE_BLOCK_BLACKLIST = builder.comment("The blocks that should not be able to be put into the fake block").defineList("fake_block_blacklist", Arrays.asList("minecraft:bedrock"), Objects::nonNull);
        }

        public List<Block> getFakeBlockBlacklist() {
            return ((List)FAKE_BLOCK_BLACKLIST.get()).stream().map(x$0 -> Config.getBlock(x$0)).filter(Objects::nonNull).collect(Collectors.toList());
        }
    }
}

