/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.integration.jei;

import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import vectorwing.farmersdelight.client.gui.CookingPotScreen;
import vectorwing.farmersdelight.crafting.CookingPotRecipe;
import vectorwing.farmersdelight.crafting.CuttingBoardRecipe;
import vectorwing.farmersdelight.integration.jei.cooking.CookingRecipeCategory;
import vectorwing.farmersdelight.integration.jei.cutting.CuttingRecipeCategory;
import vectorwing.farmersdelight.registry.ModItems;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    private static ResourceLocation ID = new ResourceLocation("farmersdelight", "jei_plugin");

    public void registerCategories(IRecipeCategoryRegistration registry) {
        registry.addRecipeCategories(new IRecipeCategory[]{new CookingRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new CuttingRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        registration.addRecipes(JEIPlugin.findRecipesByType(CookingPotRecipe.TYPE), CookingRecipeCategory.UID);
        registration.addRecipes(JEIPlugin.findRecipesByType(CuttingBoardRecipe.TYPE), CuttingRecipeCategory.UID);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModItems.COOKING_POT.get()), new ResourceLocation[]{CookingRecipeCategory.UID});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModItems.CUTTING_BOARD.get()), new ResourceLocation[]{CuttingRecipeCategory.UID});
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(CookingPotScreen.class, 89, 25, 24, 17, new ResourceLocation[]{CookingRecipeCategory.UID});
    }

    private static List<IRecipe<?>> findRecipesByType(IRecipeType<?> type) {
        return Minecraft.func_71410_x().field_71441_e.func_199532_z().func_199510_b().stream().filter(r -> r.func_222127_g() == type).collect(Collectors.toList());
    }

    public ResourceLocation getPluginUid() {
        return ID;
    }
}

