/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.integration.jei.cooking;

import java.util.Arrays;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import vectorwing.farmersdelight.crafting.CookingPotRecipe;
import vectorwing.farmersdelight.registry.ModItems;

public class CookingRecipeCategory
implements IRecipeCategory<CookingPotRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("farmersdelight", "cooking");
    private final String title = I18n.func_135052_a((String)"farmersdelight.jei.cooking", (Object[])new Object[0]);
    private final IDrawable background;
    private final IDrawable icon;
    protected final IDrawable heatIndicator;
    protected final IDrawableAnimated arrow;

    public CookingRecipeCategory(IGuiHelper helper) {
        ResourceLocation backgroundImage = new ResourceLocation("farmersdelight", "textures/gui/cooking_pot.png");
        this.background = helper.createDrawable(backgroundImage, 29, 16, 117, 57);
        this.icon = helper.createDrawableIngredient((Object)new ItemStack((IItemProvider)ModItems.COOKING_POT.get()));
        this.heatIndicator = helper.createDrawable(backgroundImage, 176, 0, 17, 15);
        this.arrow = helper.drawableBuilder(backgroundImage, 176, 15, 24, 17).buildAnimated(200, IDrawableAnimated.StartDirection.LEFT, false);
    }

    public ResourceLocation getUid() {
        return UID;
    }

    public Class<? extends CookingPotRecipe> getRecipeClass() {
        return CookingPotRecipe.class;
    }

    public String getTitle() {
        return this.title;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(CookingPotRecipe cookingPotRecipe, IIngredients ingredients) {
        ingredients.setInputIngredients(cookingPotRecipe.func_192400_c());
        ingredients.setOutput(VanillaTypes.ITEM, (Object)cookingPotRecipe.func_77571_b());
    }

    public void setRecipe(IRecipeLayout recipeLayout, CookingPotRecipe recipe, IIngredients ingredients) {
        int MEAL_DISPLAY = 6;
        int CONTAINER_INPUT = 7;
        int OUTPUT = 8;
        IGuiItemStackGroup itemStacks = recipeLayout.getItemStacks();
        NonNullList<Ingredient> recipeIngredients = recipe.func_192400_c();
        int borderSlotSize = 18;
        for (int row = 0; row < 2; ++row) {
            for (int column = 0; column < 3; ++column) {
                int inputIndex = row * 3 + column;
                if (inputIndex >= recipeIngredients.size()) continue;
                itemStacks.init(inputIndex, true, column * borderSlotSize, row * borderSlotSize);
                itemStacks.set(inputIndex, Arrays.asList(((Ingredient)recipeIngredients.get(inputIndex)).func_193365_a()));
            }
        }
        itemStacks.init(6, true, 94, 9);
        itemStacks.set(6, recipe.func_77571_b().getStack());
        if (!recipe.getOutputContainer().func_190926_b()) {
            itemStacks.init(7, true, 62, 38);
            itemStacks.set(7, recipe.getOutputContainer());
        }
        itemStacks.init(8, true, 94, 38);
        itemStacks.set(8, recipe.func_77571_b().getStack());
    }

    public void draw(CookingPotRecipe recipe, double mouseX, double mouseY) {
        this.arrow.draw(60, 9);
        this.heatIndicator.draw(18, 39);
    }
}

