/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.integration.jei.cutting;

import java.util.Arrays;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import vectorwing.farmersdelight.crafting.CuttingBoardRecipe;
import vectorwing.farmersdelight.integration.jei.cutting.CuttingBoardModel;
import vectorwing.farmersdelight.registry.ModBlocks;
import vectorwing.farmersdelight.registry.ModItems;

public class CuttingRecipeCategory
implements IRecipeCategory<CuttingBoardRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("farmersdelight", "cutting");
    private final String title = I18n.func_135052_a((String)"farmersdelight.jei.cutting", (Object[])new Object[0]);
    private final IDrawable background;
    private final IDrawable icon;
    private final CuttingBoardModel cuttingBoard;

    public CuttingRecipeCategory(IGuiHelper helper) {
        ResourceLocation backgroundImage = new ResourceLocation("farmersdelight", "textures/gui/jei/cutting_board.png");
        this.background = helper.createDrawable(backgroundImage, 0, 0, 117, 57);
        this.icon = helper.createDrawableIngredient((Object)new ItemStack((IItemProvider)ModItems.CUTTING_BOARD.get()));
        this.cuttingBoard = new CuttingBoardModel(() -> new ItemStack((IItemProvider)ModBlocks.CUTTING_BOARD.get()));
    }

    public ResourceLocation getUid() {
        return UID;
    }

    public Class<? extends CuttingBoardRecipe> getRecipeClass() {
        return CuttingBoardRecipe.class;
    }

    public String getTitle() {
        return this.title;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(CuttingBoardRecipe cuttingBoardRecipe, IIngredients ingredients) {
        ingredients.setInputIngredients(cuttingBoardRecipe.getIngredientsAndTool());
        ingredients.setOutputs(VanillaTypes.ITEM, cuttingBoardRecipe.getResults());
    }

    public void setRecipe(IRecipeLayout recipeLayout, CuttingBoardRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup itemStacks = recipeLayout.getItemStacks();
        NonNullList<ItemStack> recipeOutputs = recipe.getResults();
        itemStacks.init(0, true, 15, 7);
        itemStacks.set(0, Arrays.asList(recipe.getTool().func_193365_a()));
        itemStacks.init(1, true, 15, 26);
        itemStacks.set(1, Arrays.asList(((Ingredient)recipe.func_192400_c().get(0)).func_193365_a()));
        int OUTPUT_GRID_X = 77;
        int OUTPUT_GRID_Y = 11;
        int borderSlotSize = 18;
        for (int row = 0; row < 2; ++row) {
            for (int column = 0; column < 2; ++column) {
                int inputIndex = row * 2 + column;
                if (inputIndex >= recipeOutputs.size()) continue;
                itemStacks.init(inputIndex + 2, true, column * borderSlotSize + OUTPUT_GRID_X, row * borderSlotSize + OUTPUT_GRID_Y);
                itemStacks.set(inputIndex + 2, (ItemStack)recipeOutputs.get(inputIndex));
            }
        }
    }

    public void draw(CuttingBoardRecipe recipe, double mouseX, double mouseY) {
        this.cuttingBoard.draw(15, 19);
    }
}

