/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.blocks;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import vectorwing.farmersdelight.tile.BasketTileEntity;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class BasketBlock
extends ContainerBlock
implements IWaterLoggable {
    public static final DirectionProperty FACING = BlockStateProperties.field_208155_H;
    public static final BooleanProperty ENABLED = BlockStateProperties.field_208180_g;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    public static final VoxelShape OUT_SHAPE = VoxelShapes.func_197868_b();
    public static final ImmutableMap<Direction, VoxelShape> SHAPE_FACING = Maps.immutableEnumMap((Map)ImmutableMap.builder().put((Object)Direction.DOWN, (Object)BasketBlock.cutout(BasketBlock.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0), BasketBlock.func_208617_a((double)6.0, (double)3.0, (double)14.0, (double)10.0, (double)5.0, (double)16.0), BasketBlock.func_208617_a((double)14.0, (double)3.0, (double)6.0, (double)16.0, (double)5.0, (double)10.0), BasketBlock.func_208617_a((double)6.0, (double)3.0, (double)0.0, (double)10.0, (double)5.0, (double)2.0), BasketBlock.func_208617_a((double)0.0, (double)3.0, (double)6.0, (double)2.0, (double)5.0, (double)10.0))).put((Object)Direction.UP, (Object)BasketBlock.cutout(BasketBlock.func_208617_a((double)2.0, (double)2.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0), BasketBlock.func_208617_a((double)6.0, (double)11.0, (double)0.0, (double)10.0, (double)13.0, (double)2.0), BasketBlock.func_208617_a((double)14.0, (double)11.0, (double)6.0, (double)16.0, (double)13.0, (double)10.0), BasketBlock.func_208617_a((double)6.0, (double)11.0, (double)14.0, (double)10.0, (double)13.0, (double)16.0), BasketBlock.func_208617_a((double)0.0, (double)11.0, (double)6.0, (double)2.0, (double)13.0, (double)10.0))).put((Object)Direction.NORTH, (Object)BasketBlock.cutout(BasketBlock.func_208617_a((double)2.0, (double)2.0, (double)0.0, (double)14.0, (double)14.0, (double)14.0), BasketBlock.func_208617_a((double)6.0, (double)0.0, (double)3.0, (double)10.0, (double)2.0, (double)5.0), BasketBlock.func_208617_a((double)14.0, (double)6.0, (double)3.0, (double)16.0, (double)10.0, (double)5.0), BasketBlock.func_208617_a((double)6.0, (double)14.0, (double)3.0, (double)10.0, (double)16.0, (double)5.0), BasketBlock.func_208617_a((double)0.0, (double)6.0, (double)3.0, (double)2.0, (double)10.0, (double)5.0))).put((Object)Direction.SOUTH, (Object)BasketBlock.cutout(BasketBlock.func_208617_a((double)2.0, (double)2.0, (double)2.0, (double)14.0, (double)14.0, (double)16.0), BasketBlock.func_208617_a((double)6.0, (double)14.0, (double)11.0, (double)10.0, (double)16.0, (double)13.0), BasketBlock.func_208617_a((double)14.0, (double)6.0, (double)11.0, (double)16.0, (double)10.0, (double)13.0), BasketBlock.func_208617_a((double)6.0, (double)0.0, (double)11.0, (double)10.0, (double)2.0, (double)13.0), BasketBlock.func_208617_a((double)0.0, (double)6.0, (double)11.0, (double)2.0, (double)10.0, (double)13.0))).put((Object)Direction.WEST, (Object)BasketBlock.cutout(BasketBlock.func_208617_a((double)0.0, (double)2.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0), BasketBlock.func_208617_a((double)3.0, (double)14.0, (double)6.0, (double)5.0, (double)16.0, (double)10.0), BasketBlock.func_208617_a((double)3.0, (double)6.0, (double)14.0, (double)5.0, (double)10.0, (double)16.0), BasketBlock.func_208617_a((double)3.0, (double)0.0, (double)6.0, (double)5.0, (double)2.0, (double)10.0), BasketBlock.func_208617_a((double)3.0, (double)6.0, (double)0.0, (double)5.0, (double)10.0, (double)2.0))).put((Object)Direction.EAST, (Object)BasketBlock.cutout(BasketBlock.func_208617_a((double)2.0, (double)2.0, (double)2.0, (double)16.0, (double)14.0, (double)14.0), BasketBlock.func_208617_a((double)11.0, (double)14.0, (double)6.0, (double)13.0, (double)16.0, (double)10.0), BasketBlock.func_208617_a((double)11.0, (double)6.0, (double)0.0, (double)13.0, (double)10.0, (double)2.0), BasketBlock.func_208617_a((double)11.0, (double)0.0, (double)6.0, (double)13.0, (double)2.0, (double)10.0), BasketBlock.func_208617_a((double)11.0, (double)6.0, (double)14.0, (double)13.0, (double)10.0, (double)16.0))).build());

    public BasketBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d).func_200943_b(1.5f).func_200947_a(SoundType.field_185848_a));
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.UP)).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    private static VoxelShape cutout(VoxelShape ... cutouts) {
        VoxelShape shape = OUT_SHAPE;
        for (VoxelShape cutout : cutouts) {
            shape = VoxelShapes.func_197882_b((VoxelShape)shape, (VoxelShape)cutout, (IBooleanFunction)IBooleanFunction.field_223234_e_);
        }
        return shape.func_197753_c();
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, ENABLED, WATERLOGGED});
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        TileEntity tileentity;
        if (!worldIn.field_72995_K && (tileentity = worldIn.func_175625_s(pos)) instanceof BasketTileEntity) {
            player.func_213829_a((INamedContainerProvider)((BasketTileEntity)tileentity));
        }
        return ActionResultType.SUCCESS;
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            TileEntity tileentity = worldIn.func_175625_s(pos);
            if (tileentity instanceof IInventory) {
                InventoryHelper.func_180175_a((World)worldIn, (BlockPos)pos, (IInventory)((IInventory)tileentity));
                worldIn.func_175666_e(pos, (Block)this);
            }
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        this.updateState(worldIn, pos, state);
    }

    private void updateState(World worldIn, BlockPos pos, BlockState state) {
        boolean flag;
        boolean bl = flag = !worldIn.func_175640_z(pos);
        if (flag != (Boolean)state.func_177229_b((Property)ENABLED)) {
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)ENABLED, (Comparable)Boolean.valueOf(flag)), 4);
        }
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState blockState, World worldIn, BlockPos pos) {
        return Container.func_178144_a((TileEntity)worldIn.func_175625_s(pos));
    }

    @Nullable
    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new BasketTileEntity();
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        TileEntity tileentity;
        if (stack.func_82837_s() && (tileentity = worldIn.func_175625_s(pos)) instanceof BasketTileEntity) {
            ((BasketTileEntity)tileentity).func_213903_a(stack.func_200301_q());
        }
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        FluidState ifluidstate = context.func_195991_k().func_204610_c(context.func_195995_a());
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_196010_d().func_176734_d())).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.func_206886_c() == Fluids.field_204546_a));
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return (VoxelShape)SHAPE_FACING.get((Object)state.func_177229_b((Property)FACING));
    }

    public VoxelShape func_199600_g(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return OUT_SHAPE;
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return (VoxelShape)SHAPE_FACING.get((Object)state.func_177229_b((Property)FACING));
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }
}

