/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.data;

import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.MethodsReturnNonnullByDefault;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.FrameType;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.IRequirementsStrategy;
import net.minecraft.advancements.criterion.ConsumeItemTrigger;
import net.minecraft.advancements.criterion.EffectsChangedTrigger;
import net.minecraft.advancements.criterion.InventoryChangeTrigger;
import net.minecraft.advancements.criterion.MobEffectsPredicate;
import net.minecraft.advancements.criterion.PlacedBlockTrigger;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.data.AdvancementProvider;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.item.Items;
import net.minecraft.potion.Effect;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import vectorwing.farmersdelight.advancement.CuttingBoardTrigger;
import vectorwing.farmersdelight.registry.ModBlocks;
import vectorwing.farmersdelight.registry.ModEffects;
import vectorwing.farmersdelight.registry.ModItems;
import vectorwing.farmersdelight.utils.TextUtils;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class Advancements
extends AdvancementProvider {
    private final Path PATH;
    public static final Logger LOGGER = LogManager.getLogger();

    public Advancements(DataGenerator generatorIn) {
        super(generatorIn);
        this.PATH = generatorIn.func_200391_b();
    }

    public void func_200398_a(DirectoryCache cache) {
        HashSet set = Sets.newHashSet();
        Consumer<Advancement> consumer = advancement -> {
            if (!set.add(advancement.func_192067_g())) {
                throw new IllegalStateException("Duplicate advancement " + advancement.func_192067_g());
            }
            Path path1 = Advancements.getPath(this.PATH, advancement);
            try {
                IDataProvider.func_218426_a((Gson)new GsonBuilder().setPrettyPrinting().create(), (DirectoryCache)cache, (JsonElement)advancement.func_192075_a().func_200273_b(), (Path)path1);
            }
            catch (IOException ioexception) {
                LOGGER.error("Couldn't save advancement {}", (Object)path1, (Object)ioexception);
            }
        };
        new FarmersDelightAdvancements().accept(consumer);
    }

    private static Path getPath(Path pathIn, Advancement advancementIn) {
        return pathIn.resolve("data/" + advancementIn.func_192067_g().func_110624_b() + "/advancements/" + advancementIn.func_192067_g().func_110623_a() + ".json");
    }

    public static class FarmersDelightAdvancements
    implements Consumer<Consumer<Advancement>> {
        @Override
        public void accept(Consumer<Advancement> consumer) {
            Advancement farmersDelight = Advancement.Builder.func_200278_a().func_203902_a((IItemProvider)ModItems.COOKING_POT.get(), (ITextComponent)TextUtils.getTranslation("advancement.root", new Object[0]), (ITextComponent)TextUtils.getTranslation("advancement.root.desc", new Object[0]), new ResourceLocation("minecraft:textures/block/bricks.png"), FrameType.TASK, false, false, false).func_200275_a("seeds", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{Items.field_151014_N})).func_203904_a(consumer, this.getNameId("main/root"));
            Advancement huntAndGather = FarmersDelightAdvancements.getAdvancement(farmersDelight, (IItemProvider)ModItems.FLINT_KNIFE.get(), "craft_knife", FrameType.TASK, true, true, false).func_200275_a("flint_knife", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ModItems.FLINT_KNIFE.get()})).func_200275_a("iron_knife", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ModItems.IRON_KNIFE.get()})).func_200275_a("diamond_knife", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ModItems.DIAMOND_KNIFE.get()})).func_200275_a("golden_knife", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ModItems.GOLDEN_KNIFE.get()})).func_200270_a(IRequirementsStrategy.field_223215_b_).func_203904_a(consumer, this.getNameId("main/craft_knife"));
            Advancement graspingAtStraws = FarmersDelightAdvancements.getAdvancement(huntAndGather, (IItemProvider)ModItems.STRAW.get(), "harvest_straw", FrameType.TASK, true, true, false).func_200275_a("harvest_straw", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ModItems.STRAW.get()})).func_203904_a(consumer, this.getNameId("main/harvest_straw"));
            Advancement dippingYourRoots = FarmersDelightAdvancements.getAdvancement(graspingAtStraws, (IItemProvider)ModItems.RICE_PANICLE.get(), "plant_rice", FrameType.TASK, true, true, false).func_200275_a("plant_rice", (ICriterionInstance)PlacedBlockTrigger.Instance.func_203934_a((Block)((Block)ModBlocks.RICE_CROP.get()))).func_203904_a(consumer, this.getNameId("main/plant_rice"));
            Advancement plantFood = FarmersDelightAdvancements.getAdvancement(dippingYourRoots, (IItemProvider)ModItems.RICH_SOIL.get(), "get_rich_soil", FrameType.TASK, true, true, false).func_200275_a("get_rich_soil", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ModItems.RICH_SOIL.get()})).func_203904_a(consumer, this.getNameId("main/get_rich_soil"));
            Advancement cantTakeTheHeat = FarmersDelightAdvancements.getAdvancement(huntAndGather, (IItemProvider)ModItems.NETHERITE_KNIFE.get(), "obtain_netherite_knife", FrameType.CHALLENGE, true, true, false).func_200275_a("obtain_netherite_knife", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ModItems.NETHERITE_KNIFE.get()})).func_200271_a(AdvancementRewards.Builder.func_203907_a((int)200)).func_203904_a(consumer, this.getNameId("main/obtain_netherite_knife"));
            Advancement bonfireLit = FarmersDelightAdvancements.getAdvancement(farmersDelight, (IItemProvider)Blocks.field_222433_lV, "place_campfire", FrameType.TASK, true, true, false).func_200275_a("campfire", (ICriterionInstance)PlacedBlockTrigger.Instance.func_203934_a((Block)Blocks.field_222433_lV)).func_203904_a(consumer, this.getNameId("main/place_campfire"));
            Advancement fireUpTheGrill = FarmersDelightAdvancements.getAdvancement(bonfireLit, (IItemProvider)ModItems.STOVE.get(), "craft_stove", FrameType.TASK, true, true, false).func_200275_a("stove", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ModItems.STOVE.get()})).func_203904_a(consumer, this.getNameId("main/craft_stove"));
            Advancement dinnerIsServed = FarmersDelightAdvancements.getAdvancement(fireUpTheGrill, (IItemProvider)ModItems.COOKING_POT.get(), "place_cooking_pot", FrameType.GOAL, true, true, false).func_200275_a("cooking_pot", (ICriterionInstance)PlacedBlockTrigger.Instance.func_203934_a((Block)((Block)ModBlocks.COOKING_POT.get()))).func_203904_a(consumer, this.getNameId("main/place_cooking_pot"));
            Advancement warmAndCozy = FarmersDelightAdvancements.getAdvancement(dinnerIsServed, (IItemProvider)ModItems.CHICKEN_SOUP.get(), "eat_comfort_food", FrameType.TASK, true, true, false).func_200275_a("comfort", (ICriterionInstance)EffectsChangedTrigger.Instance.func_203917_a((MobEffectsPredicate)MobEffectsPredicate.func_204014_a().func_204015_a((Effect)ModEffects.COMFORT.get()))).func_203904_a(consumer, this.getNameId("main/eat_comfort_food"));
            Advancement wellServed = FarmersDelightAdvancements.getAdvancement(warmAndCozy, (IItemProvider)ModItems.STEAK_AND_POTATOES.get(), "eat_nourishing_food", FrameType.TASK, true, true, false).func_200275_a("nourished", (ICriterionInstance)EffectsChangedTrigger.Instance.func_203917_a((MobEffectsPredicate)MobEffectsPredicate.func_204014_a().func_204015_a((Effect)ModEffects.NOURISHED.get()))).func_203904_a(consumer, this.getNameId("main/eat_nourishing_food"));
            Advancement watchYourFingers = FarmersDelightAdvancements.getAdvancement(fireUpTheGrill, (IItemProvider)ModItems.CUTTING_BOARD.get(), "use_cutting_board", FrameType.TASK, true, true, false).func_200275_a("cutting_board", (ICriterionInstance)CuttingBoardTrigger.Instance.simple()).func_203904_a(consumer, this.getNameId("main/use_cutting_board"));
            Advancement masterChef = FarmersDelightAdvancements.getAdvancement(dinnerIsServed, (IItemProvider)ModItems.PASTA_WITH_MUTTON_CHOP.get(), "master_chef", FrameType.CHALLENGE, true, true, false).func_200275_a("mixed_salad", (ICriterionInstance)ConsumeItemTrigger.Instance.func_203913_a((IItemProvider)((IItemProvider)ModItems.MIXED_SALAD.get()))).func_200275_a("beef_stew", (ICriterionInstance)ConsumeItemTrigger.Instance.func_203913_a((IItemProvider)((IItemProvider)ModItems.BEEF_STEW.get()))).func_200275_a("chicken_soup", (ICriterionInstance)ConsumeItemTrigger.Instance.func_203913_a((IItemProvider)((IItemProvider)ModItems.CHICKEN_SOUP.get()))).func_200275_a("vegetable_soup", (ICriterionInstance)ConsumeItemTrigger.Instance.func_203913_a((IItemProvider)((IItemProvider)ModItems.VEGETABLE_SOUP.get()))).func_200275_a("fish_stew", (ICriterionInstance)ConsumeItemTrigger.Instance.func_203913_a((IItemProvider)((IItemProvider)ModItems.FISH_STEW.get()))).func_200275_a("fried_rice", (ICriterionInstance)ConsumeItemTrigger.Instance.func_203913_a((IItemProvider)((IItemProvider)ModItems.FRIED_RICE.get()))).func_200275_a("pumpkin_soup", (ICriterionInstance)ConsumeItemTrigger.Instance.func_203913_a((IItemProvider)((IItemProvider)ModItems.PUMPKIN_SOUP.get()))).func_200275_a("baked_cod_stew", (ICriterionInstance)ConsumeItemTrigger.Instance.func_203913_a((IItemProvider)((IItemProvider)ModItems.BAKED_COD_STEW.get()))).func_200275_a("honey_glazed_ham", (ICriterionInstance)ConsumeItemTrigger.Instance.func_203913_a((IItemProvider)((IItemProvider)ModItems.HONEY_GLAZED_HAM.get()))).func_200275_a("pasta_with_meatballs", (ICriterionInstance)ConsumeItemTrigger.Instance.func_203913_a((IItemProvider)((IItemProvider)ModItems.PASTA_WITH_MEATBALLS.get()))).func_200275_a("pasta_with_mutton_chop", (ICriterionInstance)ConsumeItemTrigger.Instance.func_203913_a((IItemProvider)((IItemProvider)ModItems.PASTA_WITH_MUTTON_CHOP.get()))).func_200275_a("vegetable_noodles", (ICriterionInstance)ConsumeItemTrigger.Instance.func_203913_a((IItemProvider)((IItemProvider)ModItems.VEGETABLE_NOODLES.get()))).func_200275_a("steak_and_potatoes", (ICriterionInstance)ConsumeItemTrigger.Instance.func_203913_a((IItemProvider)((IItemProvider)ModItems.STEAK_AND_POTATOES.get()))).func_200275_a("shepherds_pie", (ICriterionInstance)ConsumeItemTrigger.Instance.func_203913_a((IItemProvider)((IItemProvider)ModItems.SHEPHERDS_PIE.get()))).func_200275_a("ratatouille", (ICriterionInstance)ConsumeItemTrigger.Instance.func_203913_a((IItemProvider)((IItemProvider)ModItems.RATATOUILLE.get()))).func_200275_a("squid_ink_pasta", (ICriterionInstance)ConsumeItemTrigger.Instance.func_203913_a((IItemProvider)((IItemProvider)ModItems.SQUID_INK_PASTA.get()))).func_200275_a("grilled_salmon", (ICriterionInstance)ConsumeItemTrigger.Instance.func_203913_a((IItemProvider)((IItemProvider)ModItems.GRILLED_SALMON.get()))).func_200275_a("stuffed_pumpkin", (ICriterionInstance)ConsumeItemTrigger.Instance.func_203913_a((IItemProvider)((IItemProvider)ModItems.STUFFED_PUMPKIN.get()))).func_200271_a(AdvancementRewards.Builder.func_203907_a((int)200)).func_203904_a(consumer, this.getNameId("main/master_chef"));
        }

        protected static Advancement.Builder getAdvancement(Advancement parent, IItemProvider display, String name, FrameType frame, boolean showToast, boolean announceToChat, boolean hidden) {
            return Advancement.Builder.func_200278_a().func_203905_a(parent).func_203902_a(display, (ITextComponent)TextUtils.getTranslation("advancement." + name, new Object[0]), (ITextComponent)TextUtils.getTranslation("advancement." + name + ".desc", new Object[0]), null, frame, showToast, announceToChat, hidden);
        }

        private String getNameId(String id) {
            return "farmersdelight:" + id;
        }
    }
}

