/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.data.builder;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.MethodsReturnNonnullByDefault;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import vectorwing.farmersdelight.crafting.CuttingBoardRecipe;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class CuttingBoardRecipeBuilder {
    private final Map<Item, Integer> results = new LinkedHashMap<Item, Integer>(4);
    private final Ingredient ingredient;
    private final Ingredient tool;
    private String soundEventID;

    public CuttingBoardRecipeBuilder(Ingredient ingredient, Ingredient tool, IItemProvider mainResult, int count) {
        this.results.put(mainResult.func_199767_j(), count);
        this.ingredient = ingredient;
        this.tool = tool;
    }

    public static CuttingBoardRecipeBuilder cuttingRecipe(Ingredient ingredient, Ingredient tool, IItemProvider mainResult, int count) {
        return new CuttingBoardRecipeBuilder(ingredient, tool, mainResult, count);
    }

    public static CuttingBoardRecipeBuilder cuttingRecipe(Ingredient ingredient, Ingredient tool, IItemProvider mainResult) {
        return new CuttingBoardRecipeBuilder(ingredient, tool, mainResult, 1);
    }

    public CuttingBoardRecipeBuilder addResult(IItemProvider result) {
        return this.addResult(result, 1);
    }

    public CuttingBoardRecipeBuilder addResult(IItemProvider result, int count) {
        this.results.put(result.func_199767_j(), count);
        return this;
    }

    public CuttingBoardRecipeBuilder addSound(String soundEventID) {
        this.soundEventID = soundEventID;
        return this;
    }

    public void build(Consumer<IFinishedRecipe> consumerIn) {
        ResourceLocation location = Registry.field_212630_s.func_177774_c((Object)this.ingredient.func_193365_a()[0].func_77973_b());
        this.build(consumerIn, "farmersdelight:cutting/" + location.func_110623_a());
    }

    public void build(Consumer<IFinishedRecipe> consumerIn, String save) {
        ResourceLocation resourcelocation = Registry.field_212630_s.func_177774_c((Object)this.ingredient.func_193365_a()[0].func_77973_b());
        if (new ResourceLocation(save).equals((Object)resourcelocation)) {
            throw new IllegalStateException("Shapeless Recipe " + save + " should remove its 'save' argument");
        }
        this.build(consumerIn, new ResourceLocation(save));
    }

    public void build(Consumer<IFinishedRecipe> consumerIn, ResourceLocation id) {
        consumerIn.accept(new Result(id, this.ingredient, this.tool, this.results, this.soundEventID == null ? "" : this.soundEventID));
    }

    public static class Result
    implements IFinishedRecipe {
        private final ResourceLocation id;
        private final Ingredient ingredient;
        private final Ingredient tool;
        private final Map<Item, Integer> results;
        private final String soundEventID;

        public Result(ResourceLocation idIn, Ingredient ingredientIn, Ingredient toolIn, Map<Item, Integer> resultsIn, String soundEventIDIn) {
            this.id = idIn;
            this.ingredient = ingredientIn;
            this.tool = toolIn;
            this.results = resultsIn;
            this.soundEventID = soundEventIDIn;
        }

        public void func_218610_a(JsonObject json) {
            JsonArray arrayIngredients = new JsonArray();
            arrayIngredients.add(this.ingredient.func_200304_c());
            json.add("ingredients", (JsonElement)arrayIngredients);
            json.add("tool", this.tool.func_200304_c());
            JsonArray arrayResults = new JsonArray();
            for (Map.Entry<Item, Integer> result : this.results.entrySet()) {
                JsonObject jsonobject = new JsonObject();
                jsonobject.addProperty("item", Registry.field_212630_s.func_177774_c((Object)result.getKey()).toString());
                if (result.getValue() > 1) {
                    jsonobject.addProperty("count", (Number)result.getValue());
                }
                arrayResults.add((JsonElement)jsonobject);
            }
            json.add("result", (JsonElement)arrayResults);
            if (!this.soundEventID.isEmpty()) {
                json.addProperty("sound", this.soundEventID);
            }
        }

        public ResourceLocation func_200442_b() {
            return this.id;
        }

        public IRecipeSerializer<?> func_218609_c() {
            return CuttingBoardRecipe.SERIALIZER;
        }

        @Nullable
        public JsonObject func_200440_c() {
            return null;
        }

        @Nullable
        public ResourceLocation func_200443_d() {
            return null;
        }
    }
}

