/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.world;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.gen.feature.jigsaw.JigsawManager;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.jigsaw.JigsawPiece;
import net.minecraft.world.gen.feature.jigsaw.SingleJigsawPiece;
import net.minecraft.world.gen.feature.structure.DesertVillagePools;
import net.minecraft.world.gen.feature.structure.PlainsVillagePools;
import net.minecraft.world.gen.feature.structure.SavannaVillagePools;
import net.minecraft.world.gen.feature.structure.SnowyVillagePools;
import net.minecraft.world.gen.feature.structure.TaigaVillagePools;
import vectorwing.farmersdelight.utils.MathUtils;

public class VillageStructures {
    public static void init() {
        PlainsVillagePools.func_214744_a();
        SnowyVillagePools.func_214746_a();
        SavannaVillagePools.func_214745_a();
        DesertVillagePools.func_222739_a();
        TaigaVillagePools.func_214806_a();
        ImmutableMap biomeChances = new ImmutableMap.Builder().put((Object)"plains", (Object)5).put((Object)"snowy", (Object)2).put((Object)"savanna", (Object)2).put((Object)"desert", (Object)2).put((Object)"taiga", (Object)3).build();
        for (Map.Entry biome : biomeChances.entrySet()) {
            VillageStructures.addToPool(new ResourceLocation("village/" + (String)biome.getKey() + "/houses"), new ResourceLocation("farmersdelight", "village/houses/" + (String)biome.getKey() + "_compost_pile"), (Integer)biome.getValue());
        }
    }

    private static void addToPool(ResourceLocation pool, ResourceLocation toAdd, int weight) {
        JigsawPattern old = JigsawManager.field_214891_a.func_214933_a(pool);
        List shuffled = old.func_214943_b(MathUtils.RAND);
        ArrayList<Pair> newPieces = new ArrayList<Pair>();
        for (JigsawPiece p : shuffled) {
            newPieces.add(new Pair((Object)p, (Object)1));
        }
        newPieces.add(new Pair((Object)new SingleJigsawPiece(toAdd.toString()), (Object)weight));
        ResourceLocation name = old.func_214947_b();
        JigsawManager.field_214891_a.func_214932_a(new JigsawPattern(pool, name, newPieces, JigsawPattern.PlacementBehaviour.RIGID));
    }
}

