/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.firstaid.client.util;

import ichttt.mods.firstaid.FirstAidConfig;
import ichttt.mods.firstaid.api.damagesystem.AbstractDamageablePart;
import ichttt.mods.firstaid.api.damagesystem.AbstractPlayerDamageModel;
import ichttt.mods.firstaid.client.util.EventCalendar;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class PlayerModelRenderer {
    private static final ResourceLocation HEALTH_RENDER_LOCATION = new ResourceLocation("firstaid", "textures/gui/simple_health.png");
    private static final int SIZE = 64;
    private static int angle = 0;
    private static boolean otherWay = false;

    public static void renderPlayerHealth(AbstractPlayerDamageModel damageModel, Gui gui, boolean flashState, float alpha, float partialTicks) {
        int yOffset = flashState ? 128 : 0;
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)(1.0f - alpha / 255.0f));
        Minecraft.func_71410_x().func_110434_K().func_110577_a(HEALTH_RENDER_LOCATION);
        GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
        if (FirstAidConfig.overlay.enableEasterEggs && (EventCalendar.isAFDay() || EventCalendar.isHalloween())) {
            float angle = (float)PlayerModelRenderer.angle + (otherWay ? -partialTicks : partialTicks) * 2.0f;
            if (FirstAidConfig.overlay.pos == FirstAidConfig.Overlay.Position.BOTTOM_LEFT || FirstAidConfig.overlay.pos == FirstAidConfig.Overlay.Position.TOP_LEFT) {
                GlStateManager.func_179109_b((float)(angle * 1.5f), (float)0.0f, (float)0.0f);
            } else {
                GlStateManager.func_179109_b((float)(angle * 0.5f), (float)0.0f, (float)0.0f);
            }
            GlStateManager.func_179114_b((float)angle, (float)0.0f, (float)0.0f, (float)1.0f);
        }
        if (yOffset != 0) {
            GlStateManager.func_179109_b((float)0.0f, (float)(-yOffset), (float)0.0f);
        }
        PlayerModelRenderer.drawPart(gui, damageModel.HEAD, 16, yOffset + 0, 32, 32);
        PlayerModelRenderer.drawPart(gui, damageModel.BODY, 16, yOffset + 32, 32, 48);
        PlayerModelRenderer.drawPart(gui, damageModel.LEFT_ARM, 0, yOffset + 32, 16, 48);
        PlayerModelRenderer.drawPart(gui, damageModel.RIGHT_ARM, 48, yOffset + 32, 16, 48);
        PlayerModelRenderer.drawPart(gui, damageModel.LEFT_LEG, 16, yOffset + 80, 16, 32);
        PlayerModelRenderer.drawPart(gui, damageModel.RIGHT_LEG, 32, yOffset + 80, 16, 32);
        PlayerModelRenderer.drawPart(gui, damageModel.LEFT_FOOT, 16, yOffset + 112, 16, 16);
        PlayerModelRenderer.drawPart(gui, damageModel.RIGHT_FOOT, 32, yOffset + 112, 16, 16);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
    }

    private static void drawPart(Gui gui, AbstractDamageablePart part, int texX, int texY, int sizeX, int sizeY) {
        int rawTexX = texX;
        int maxHealth = part.getMaxHealth();
        if ((double)part.currentHealth <= 0.001) {
            texX += 192;
        } else if ((double)Math.abs(part.currentHealth - (float)maxHealth) > 0.001) {
            float healthPercentage = part.currentHealth / (float)maxHealth;
            if (healthPercentage >= 1.0f || healthPercentage <= 0.0f) {
                throw new RuntimeException(String.format("Calculated invalid health for part %s with current health %s and max health %d. Got value %s", new Object[]{part.part, Float.valueOf(part.currentHealth), maxHealth, Float.valueOf(healthPercentage)}));
            }
            texX += 64 * ((double)healthPercentage > 0.5 ? 1 : 2);
        }
        gui.func_73729_b(rawTexX, texY, texX, texY, sizeX, sizeY);
    }

    public static void tickFun() {
        if ((angle += otherWay ? -2 : 2) >= 90 || angle <= 0) {
            otherWay = !otherWay;
        }
    }
}

