/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.firstaid.common;

import com.creativemd.playerrevive.api.event.PlayerKilledEvent;
import com.creativemd.playerrevive.api.event.PlayerRevivedEvent;
import ichttt.mods.firstaid.FirstAid;
import ichttt.mods.firstaid.FirstAidConfig;
import ichttt.mods.firstaid.api.CapabilityExtendedHealthSystem;
import ichttt.mods.firstaid.api.IDamageDistribution;
import ichttt.mods.firstaid.api.damagesystem.AbstractPlayerDamageModel;
import ichttt.mods.firstaid.common.CapProvider;
import ichttt.mods.firstaid.common.DataManagerWrapper;
import ichttt.mods.firstaid.common.apiimpl.FirstAidRegistryImpl;
import ichttt.mods.firstaid.common.config.ConfigEntry;
import ichttt.mods.firstaid.common.config.ExtraConfig;
import ichttt.mods.firstaid.common.damagesystem.PlayerDamageModel;
import ichttt.mods.firstaid.common.damagesystem.distribution.DamageDistribution;
import ichttt.mods.firstaid.common.damagesystem.distribution.HealthDistribution;
import ichttt.mods.firstaid.common.damagesystem.distribution.PreferredDamageDistribution;
import ichttt.mods.firstaid.common.items.FirstAidItems;
import ichttt.mods.firstaid.common.network.MessageConfiguration;
import ichttt.mods.firstaid.common.network.MessageSyncDamageModel;
import ichttt.mods.firstaid.common.potion.FirstAidPotion;
import ichttt.mods.firstaid.common.potion.PotionPoisonPatched;
import ichttt.mods.firstaid.common.util.CommonUtils;
import ichttt.mods.firstaid.common.util.ProjectileHelper;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.WeakHashMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.potion.Potion;
import net.minecraft.util.DamageSource;
import net.minecraft.util.FoodStats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraft.world.storage.loot.functions.SetCount;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.tuple.Pair;

public class EventHandler {
    public static final Random rand = new Random();
    public static final SoundEvent HEARTBEAT = (SoundEvent)new SoundEvent(new ResourceLocation("firstaid", "debuff.heartbeat")).setRegistryName(new ResourceLocation("firstaid", "debuff.heartbeat"));
    public static final Potion MORPHINE = new FirstAidPotion(false, 3549, "morphine").func_188413_j();
    public static final Potion POISEN_PATCHED = PotionPoisonPatched.INSTANCE;
    public static final Map<EntityPlayer, Pair<Entity, RayTraceResult>> hitList = new WeakHashMap<EntityPlayer, Pair<Entity, RayTraceResult>>();

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onLivingHurt(LivingHurtEvent event) {
        Entity entityProjectile;
        EntityEquipmentSlot slot;
        Pair<Entity, RayTraceResult> rayTraceResult;
        EntityLivingBase entity = event.getEntityLiving();
        if (entity.field_70170_p.field_72995_K || !(entity instanceof EntityPlayer) || entity instanceof FakePlayer) {
            return;
        }
        float amountToDamage = event.getAmount();
        EntityPlayer player = (EntityPlayer)entity;
        AbstractPlayerDamageModel damageModel = (AbstractPlayerDamageModel)Objects.requireNonNull(player.getCapability(CapabilityExtendedHealthSystem.INSTANCE, null));
        DamageSource source = event.getSource();
        if (amountToDamage == Float.MAX_VALUE) {
            damageModel.forEach(damageablePart -> {
                damageablePart.currentHealth = 0.0f;
            });
            if (player instanceof EntityPlayerMP) {
                FirstAid.NETWORKING.sendTo((IMessage)new MessageSyncDamageModel(damageModel, false), (EntityPlayerMP)player);
            }
            event.setCanceled(true);
            CommonUtils.killPlayer(damageModel, player, source);
            return;
        }
        boolean addStat = amountToDamage < 3.4028235E37f;
        IDamageDistribution damageDistribution = FirstAidRegistryImpl.INSTANCE.getDamageDistribution(source);
        if (source.func_76352_a() && (rayTraceResult = hitList.remove(player)) != null && (slot = ProjectileHelper.getPartByPosition(entityProjectile = (Entity)rayTraceResult.getLeft(), player)) != null) {
            damageDistribution = new PreferredDamageDistribution(slot);
        }
        DamageDistribution.handleDamageTaken(damageDistribution, damageModel, amountToDamage, player, source, addStat, true);
        event.setCanceled(true);
        hitList.remove(player);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onProjectileImpact(ProjectileImpactEvent event) {
        RayTraceResult result = event.getRayTraceResult();
        if (result.field_72313_a != RayTraceResult.Type.ENTITY) {
            return;
        }
        Entity entity = result.field_72308_g;
        if (!entity.field_70170_p.field_72995_K && entity instanceof EntityPlayer) {
            hitList.put((EntityPlayer)entity, (Pair<Entity, RayTraceResult>)Pair.of((Object)event.getEntity(), (Object)event.getRayTraceResult()));
        }
    }

    @SubscribeEvent
    public static void registerCapability(AttachCapabilitiesEvent<Entity> event) {
        Entity obj = (Entity)event.getObject();
        if (obj instanceof EntityPlayer && !(obj instanceof FakePlayer)) {
            EntityPlayer player = (EntityPlayer)obj;
            PlayerDamageModel damageModel = PlayerDamageModel.create();
            event.addCapability(CapProvider.IDENTIFIER, (ICapabilityProvider)new CapProvider(damageModel));
            player.field_70180_af = new DataManagerWrapper(player, player.field_70180_af);
        }
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        FirstAidItems.registerItems((IForgeRegistry<Item>)event.getRegistry());
    }

    @SubscribeEvent
    public static void registerPotion(RegistryEvent.Register<Potion> event) {
        event.getRegistry().register((IForgeRegistryEntry)MORPHINE);
        event.getRegistry().register((IForgeRegistryEntry)POISEN_PATCHED);
    }

    @SubscribeEvent
    public static void registerSound(RegistryEvent.Register<SoundEvent> event) {
        event.getRegistry().register((IForgeRegistryEntry)HEARTBEAT);
    }

    @SubscribeEvent
    public static void tickPlayers(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && CommonUtils.isSurvivalOrAdventure(event.player)) {
            ((AbstractPlayerDamageModel)Objects.requireNonNull(event.player.getCapability(CapabilityExtendedHealthSystem.INSTANCE, null))).tick(event.player.field_70170_p, event.player);
            hitList.remove(event.player);
        }
    }

    @SubscribeEvent
    public static void tickWorld(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        if (FirstAidConfig.externalHealing.sleepHealPercentage <= 0.0) {
            return;
        }
        World world = event.world;
        if (!world.field_72995_K && world instanceof WorldServer && ((WorldServer)world).func_73056_e()) {
            for (EntityPlayer player : world.field_73010_i) {
                AbstractPlayerDamageModel damageModel = (AbstractPlayerDamageModel)Objects.requireNonNull(player.getCapability(CapabilityExtendedHealthSystem.INSTANCE, null));
                Objects.requireNonNull(damageModel, "damage model").sleepHeal(player);
            }
        }
    }

    @SubscribeEvent
    public static void onLootTableLoad(LootTableLoadEvent event) {
        ResourceLocation tableName = event.getName();
        LootPool pool = null;
        int bandage = 0;
        int plaster = 0;
        int morphine = 0;
        if (tableName.equals((Object)LootTableList.field_186420_b)) {
            pool = event.getTable().getPool("main");
            bandage = 8;
            plaster = 16;
            morphine = 4;
        } else if (tableName.equals((Object)LootTableList.field_186428_j) || tableName.equals((Object)LootTableList.field_186427_i) || tableName.equals((Object)LootTableList.field_186424_f)) {
            pool = event.getTable().getPool("main");
            bandage = 20;
            plaster = 24;
            morphine = 8;
        }
        if (pool != null) {
            pool.addEntry((LootEntry)new LootEntryItem(FirstAidItems.BANDAGE, bandage, 0, (LootFunction[])new SetCount[]{new SetCount(new LootCondition[0], new RandomValueRange(1.0f, 3.0f))}, new LootCondition[0], "firstaidbandage"));
            pool.addEntry((LootEntry)new LootEntryItem(FirstAidItems.PLASTER, plaster, 0, (LootFunction[])new SetCount[]{new SetCount(new LootCondition[0], new RandomValueRange(1.0f, 5.0f))}, new LootCondition[0], "firstaidplaster"));
            pool.addEntry((LootEntry)new LootEntryItem(FirstAidItems.MORPHINE, morphine, 0, (LootFunction[])new SetCount[]{new SetCount(new LootCondition[0], new RandomValueRange(1.0f, 2.0f))}, new LootCondition[0], "firstaidmorphine"));
        }
    }

    @SubscribeEvent
    public static void onConfigChange(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("firstaid")) {
            ByteBuf buf;
            LinkedHashMap<ConfigEntry<ExtraConfig.Sync>, ByteBuf> map = new LinkedHashMap<ConfigEntry<ExtraConfig.Sync>, ByteBuf>();
            for (ConfigEntry<ExtraConfig.Sync> option : FirstAid.syncedConfigOptions) {
                if (!option.hasRemoteData()) continue;
                buf = ByteBufAllocator.DEFAULT.buffer();
                option.writeToBuf(buf);
                map.put(option, buf);
                option.revert();
            }
            ConfigManager.sync((String)"firstaid", (Config.Type)Config.Type.INSTANCE);
            for (ConfigEntry<ExtraConfig.Sync> option : FirstAid.syncedConfigOptions) {
                option.updateOrigState();
                if (!map.containsKey(option)) continue;
                buf = (ByteBuf)map.get(option);
                option.readFromBuf(buf);
                buf.release();
            }
            event.setResult(Event.Result.ALLOW);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onHeal(LivingHealEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        if (!entity.hasCapability(CapabilityExtendedHealthSystem.INSTANCE, null)) {
            return;
        }
        event.setCanceled(true);
        if (entity.field_70170_p.field_72995_K || !FirstAidConfig.externalHealing.allowOtherHealingItems) {
            return;
        }
        float amount = event.getAmount();
        if (Arrays.stream(Thread.currentThread().getStackTrace()).anyMatch(stackTraceElement -> stackTraceElement.getClassName().equals(FoodStats.class.getName()))) {
            if (FirstAidConfig.externalHealing.allowNaturalRegeneration) {
                amount *= (float)FirstAidConfig.externalHealing.naturalRegenMultiplier;
            }
        } else {
            amount *= (float)FirstAidConfig.externalHealing.otherRegenMultiplier;
        }
        if (FirstAidConfig.debug) {
            CommonUtils.debugLogStacktrace("External healing: : " + amount);
        }
        HealthDistribution.distributeHealth(amount, (EntityPlayer)entity, true);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.player.field_70170_p.field_72995_K) {
            FirstAid.LOGGER.debug("Sending damage model to " + event.player.func_70005_c_());
            AbstractPlayerDamageModel damageModel = (AbstractPlayerDamageModel)Objects.requireNonNull(event.player.getCapability(CapabilityExtendedHealthSystem.INSTANCE, null));
            if (damageModel.hasTutorial) {
                CapProvider.tutorialDone.add(event.player.func_70005_c_());
            }
            EntityPlayerMP playerMP = (EntityPlayerMP)event.player;
            FirstAid.NETWORKING.sendTo((IMessage)new MessageConfiguration(damageModel, !playerMP.field_71135_a.field_147371_a.func_150731_c()), playerMP);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        hitList.remove(event.player);
    }

    @SubscribeEvent
    public static void onWorldLoad(WorldEvent.Load event) {
        World world = event.getWorld();
        if (!world.field_72995_K) {
            world.func_82736_K().func_82764_b("naturalRegeneration", Boolean.toString(FirstAidConfig.externalHealing.allowNaturalRegeneration));
        }
    }

    @SubscribeEvent
    public static void onDimensionChange(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (!event.player.field_70170_p.field_72995_K && event.player instanceof EntityPlayerMP) {
            FirstAid.NETWORKING.sendTo((IMessage)new MessageSyncDamageModel((AbstractPlayerDamageModel)Objects.requireNonNull(event.player.getCapability(CapabilityExtendedHealthSystem.INSTANCE, null)), true), (EntityPlayerMP)event.player);
        }
    }

    @SubscribeEvent
    public static void onPlayerBleedToDeath(PlayerKilledEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        AbstractPlayerDamageModel damageModel = (AbstractPlayerDamageModel)player.getCapability(CapabilityExtendedHealthSystem.INSTANCE, null);
        if (damageModel != null) {
            damageModel.stopWaitingForHelp(player);
        }
    }

    @SubscribeEvent
    public static void onPlayerRevived(PlayerRevivedEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        AbstractPlayerDamageModel damageModel = (AbstractPlayerDamageModel)player.getCapability(CapabilityExtendedHealthSystem.INSTANCE, null);
        if (damageModel != null) {
            damageModel.revivePlayer(player);
            damageModel.stopWaitingForHelp(player);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        if (!event.isEndConquered() && !event.player.field_70170_p.field_72995_K && event.player instanceof EntityPlayerMP) {
            AbstractPlayerDamageModel damageModel = (AbstractPlayerDamageModel)Objects.requireNonNull(event.player.getCapability(CapabilityExtendedHealthSystem.INSTANCE, null));
            damageModel.runScaleLogic(event.player);
            damageModel.forEach(damageablePart -> damageablePart.heal(damageablePart.getMaxHealth(), event.player, false));
            damageModel.scheduleResync();
        }
    }
}

