/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.firstaid.common.config;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import ichttt.mods.firstaid.FirstAid;
import ichttt.mods.firstaid.FirstAidConfig;
import ichttt.mods.firstaid.common.config.ConfigEntry;
import ichttt.mods.firstaid.common.config.ExtraConfig;
import ichttt.mods.firstaid.common.config.UniqueProperty;
import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.FieldWrapper;
import net.minecraftforge.common.config.ITypeAdapter;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.common.Loader;

public class ExtraConfigManager {
    private static List<String> toDeleteEntries;
    private static final Field CONFIG_FIELD;

    public static void scheduleDelete(String name) {
        if (toDeleteEntries == null) {
            throw new IllegalStateException("Already cleaned up configs");
        }
        toDeleteEntries.add(name);
    }

    private static Configuration getConfigFromField(File f) {
        if (CONFIG_FIELD != null) {
            try {
                return (Configuration)((Map)CONFIG_FIELD.get(null)).get(f.getAbsolutePath());
            }
            catch (Exception e) {
                FirstAid.LOGGER.error("Could not get config from field - enabling fallback", (Throwable)e);
                return null;
            }
        }
        return null;
    }

    public static void postProcessConfigs() {
        Configuration config;
        if (toDeleteEntries.isEmpty()) {
            return;
        }
        Config annotation = FirstAidConfig.class.getAnnotation(Config.class);
        String name = annotation.name();
        if (Strings.isNullOrEmpty((String)name)) {
            name = annotation.modid();
        }
        if ((config = ExtraConfigManager.getConfigFromField(new File(Loader.instance().getConfigDir(), name + ".cfg"))) == null) {
            FirstAid.LOGGER.warn("Skipping post processing due to null config");
            return;
        }
        for (String s : toDeleteEntries) {
            String[] path = s.split("\\.");
            String catString = "general" + (path.length > 1 ? "." + s.substring(0, s.length() - (path[path.length - 1].length() + 1)) : "");
            if (config.hasCategory(catString)) {
                ConfigCategory cat = config.getCategory(catString);
                if (!cat.containsKey(path[path.length - 1])) continue;
                FirstAid.LOGGER.info("Removing prop " + s);
                cat.remove((Object)path[path.length - 1]);
                continue;
            }
            FirstAid.LOGGER.warn("Unable to find config category {} for removal of old config options", (Object)catString);
        }
        if (config.hasChanged()) {
            config.save();
        }
        toDeleteEntries = null;
    }

    public static <T extends Annotation> List<ConfigEntry<T>> getAnnotatedFields(Class<T> annotationClass, Class<?> clazz) {
        return ExtraConfigManager.getAnnotatedFields(annotationClass, clazz, "general", null);
    }

    private static <T extends Annotation> List<ConfigEntry<T>> getAnnotatedFields(Class<T> annotationClass, Class<?> clazz, String category, Object instance) {
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        for (Field f : clazz.getDeclaredFields()) {
            T annotation = f.getAnnotation(annotationClass);
            if (annotation != null && FieldWrapper.hasWrapperFor((Field)f)) {
                UniqueProperty.Type type;
                ITypeAdapter typeAdapter = FieldWrapper.get((Object)instance, (Field)f, (String)category).getTypeAdapter();
                if (typeAdapter == null) {
                    type = UniqueProperty.Type.UNKNOWN;
                } else {
                    try {
                        Method m = typeAdapter.getClass().getDeclaredMethod("getType", new Class[0]);
                        m.setAccessible(true);
                        Property.Type propType = (Property.Type)m.invoke((Object)typeAdapter, new Object[0]);
                        type = UniqueProperty.Type.fromType(propType);
                    }
                    catch (ClassCastException | ReflectiveOperationException e) {
                        FirstAid.LOGGER.fatal("Error getting type from type adapter for field " + f, (Throwable)e);
                        type = UniqueProperty.Type.UNKNOWN;
                    }
                }
                listBuilder.add(new ConfigEntry<T>(f, instance, annotation, annotationClass == ExtraConfig.Sync.class, UniqueProperty.fromProperty(f, "firstaid", category, type)));
            }
            if (FieldWrapper.hasWrapperFor((Field)f) || f.getType().getSuperclass() == null || !f.getType().getSuperclass().equals(Object.class)) continue;
            String sub = (category.isEmpty() ? "" : category + ".") + ExtraConfigManager.getName(f).toLowerCase(Locale.ENGLISH);
            if (annotation != null) {
                listBuilder.add(new ConfigEntry<T>(f, instance, annotation, annotationClass == ExtraConfig.Sync.class, new UniqueProperty(ExtraConfigManager.getName(f), UniqueProperty.getLangKey(f, "firstaid", category), UniqueProperty.Type.CATEGORY)));
            }
            try {
                Object newInstance = f.get(instance);
                listBuilder.addAll(ExtraConfigManager.getAnnotatedFields(annotationClass, newInstance.getClass(), sub, newInstance));
            }
            catch (IllegalAccessException e) {
                FirstAid.LOGGER.error("Error creating new instance of field " + f, (Throwable)e);
            }
        }
        ImmutableList list = listBuilder.build();
        if (instance == null) {
            FirstAid.LOGGER.debug("Found {} annotations of the type {} for the {}", (Object)list.size(), annotationClass, clazz);
        }
        return listBuilder.build();
    }

    private static String getName(Field f) {
        if (f.isAnnotationPresent(Config.Name.class)) {
            return f.getAnnotation(Config.Name.class).value();
        }
        return f.getName();
    }

    static {
        Field field;
        toDeleteEntries = new ArrayList<String>();
        FirstAid.LOGGER.debug("Setting up forge internal reflection");
        try {
            field = ConfigManager.class.getDeclaredField("CONFIGS");
            field.setAccessible(true);
            field.get(null);
        }
        catch (IllegalArgumentException | ReflectiveOperationException e) {
            FirstAid.LOGGER.error("Could not setup forge reflection - disabling config post processing", (Throwable)e);
            field = null;
        }
        CONFIG_FIELD = field;
    }
}

