/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.firstaid.client;

import ichttt.mods.firstaid.FirstAid;
import ichttt.mods.firstaid.FirstAidConfig;
import ichttt.mods.firstaid.api.damagesystem.AbstractDamageablePart;
import ichttt.mods.firstaid.api.damagesystem.AbstractPlayerDamageModel;
import ichttt.mods.firstaid.api.enums.EnumPlayerPart;
import ichttt.mods.firstaid.client.gui.GuiHealthScreen;
import ichttt.mods.firstaid.client.util.HealthRenderUtils;
import ichttt.mods.firstaid.client.util.PlayerModelRenderer;
import ichttt.mods.firstaid.common.util.CommonUtils;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.client.gui.GuiIngame;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.resource.IResourceType;
import net.minecraftforge.resource.ISelectiveResourceReloadListener;
import net.minecraftforge.resource.VanillaResourceType;

public class HUDHandler
implements ISelectiveResourceReloadListener {
    public static final HUDHandler INSTANCE = new HUDHandler();
    private static final int FADE_TIME = 30;
    private final Map<EnumPlayerPart, String> TRANSLATION_MAP = new EnumMap<EnumPlayerPart, String>(EnumPlayerPart.class);
    private int maxLength;
    public int ticker = -1;

    public void onResourceManagerReload(@Nonnull IResourceManager resourceManager, @Nonnull Predicate<IResourceType> resourcePredicate) {
        if (!resourcePredicate.test((IResourceType)VanillaResourceType.LANGUAGES)) {
            return;
        }
        FirstAid.LOGGER.debug("Building GUI translation table");
        this.TRANSLATION_MAP.clear();
        this.maxLength = 0;
        for (EnumPlayerPart part : EnumPlayerPart.VALUES) {
            String translated = I18n.func_135052_a((String)("gui." + part.toString().toLowerCase(Locale.ENGLISH)), (Object[])new Object[0]);
            this.maxLength = Math.max(this.maxLength, Minecraft.func_71410_x().field_71466_p.func_78256_a(translated));
            this.TRANSLATION_MAP.put(part, translated);
        }
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public void renderOverlay(Minecraft mc, float partialTicks) {
        mc.field_71424_I.func_76320_a("prepare");
        if (FirstAidConfig.overlay.overlayMode == FirstAidConfig.Overlay.OverlayMode.OFF || mc.field_71439_g == null || GuiHealthScreen.isOpen && FirstAidConfig.overlay.overlayMode != FirstAidConfig.Overlay.OverlayMode.PLAYER_MODEL || !CommonUtils.isSurvivalOrAdventure((EntityPlayer)mc.field_71439_g)) {
            return;
        }
        AbstractPlayerDamageModel damageModel = CommonUtils.getDamageModel((EntityPlayer)mc.field_71439_g);
        if (!FirstAid.isSynced) {
            return;
        }
        boolean playerDead = damageModel.isDead((EntityPlayer)mc.field_71439_g);
        if (FirstAidConfig.overlay.hideOnNoChange) {
            for (AbstractDamageablePart damageablePart : damageModel) {
                if (!HealthRenderUtils.healthChanged(damageablePart, playerDead)) continue;
                this.ticker = Math.max(this.ticker, 100);
                break;
            }
            if (this.ticker <= 0) {
                return;
            }
        }
        mc.func_110434_K().func_110577_a(Gui.field_110324_m);
        GuiIngame gui = mc.field_71456_v;
        int xOffset = FirstAidConfig.overlay.xOffset;
        int yOffset = FirstAidConfig.overlay.yOffset;
        boolean playerModel = FirstAidConfig.overlay.overlayMode == FirstAidConfig.Overlay.OverlayMode.PLAYER_MODEL;
        switch (FirstAidConfig.overlay.pos) {
            case TOP_LEFT: {
                if (!playerModel) break;
                ++xOffset;
                break;
            }
            case TOP_RIGHT: {
                xOffset = mc.field_195558_d.func_198107_o() - xOffset - (playerModel ? 34 : damageModel.getMaxRenderSize() - this.maxLength);
                break;
            }
            case BOTTOM_LEFT: {
                if (playerModel) {
                    ++xOffset;
                }
                yOffset = mc.field_195558_d.func_198087_p() - yOffset - (playerModel ? 66 : 80);
                break;
            }
            case BOTTOM_RIGHT: {
                xOffset = mc.field_195558_d.func_198107_o() - xOffset - (playerModel ? 34 : damageModel.getMaxRenderSize() - this.maxLength);
                yOffset = mc.field_195558_d.func_198087_p() - yOffset - (playerModel ? 62 : 80);
                break;
            }
            default: {
                throw new RuntimeException("Invalid config option for position: " + (Object)((Object)FirstAidConfig.overlay.pos));
            }
        }
        if (mc.field_71462_r instanceof GuiChat && FirstAidConfig.overlay.pos == FirstAidConfig.Overlay.Position.BOTTOM_LEFT) {
            return;
        }
        if (mc.field_71474_y.field_74330_P && FirstAidConfig.overlay.pos == FirstAidConfig.Overlay.Position.TOP_LEFT) {
            return;
        }
        boolean enableAlphaBlend = FirstAidConfig.overlay.hideOnNoChange && this.ticker < 30;
        int alpha = enableAlphaBlend ? MathHelper.func_76125_a((int)((int)((float)(30 - this.ticker) * 255.0f / 30.0f)), (int)FirstAidConfig.overlay.alpha, (int)250) : FirstAidConfig.overlay.alpha;
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)xOffset, (float)yOffset, (float)0.0f);
        if (enableAlphaBlend) {
            GlStateManager.func_179147_l();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        }
        mc.field_71424_I.func_76318_c("render");
        if (FirstAidConfig.overlay.overlayMode == FirstAidConfig.Overlay.OverlayMode.PLAYER_MODEL) {
            PlayerModelRenderer.renderPlayerHealth(damageModel, (Gui)gui, alpha);
        } else {
            int xTranslation = this.maxLength;
            for (AbstractDamageablePart part : damageModel) {
                mc.field_71466_p.func_175063_a(this.TRANSLATION_MAP.get((Object)part.part), 0.0f, 0.0f, 0xFFFFFF - (alpha << 24 & 0xFF000001));
                if (FirstAidConfig.overlay.overlayMode == FirstAidConfig.Overlay.OverlayMode.NUMBERS) {
                    HealthRenderUtils.drawHealthString(part, xTranslation, 0.0f, false);
                } else {
                    HealthRenderUtils.drawHealth(part, xTranslation, 0.0f, (Gui)gui, false);
                }
                GlStateManager.func_179109_b((float)0.0f, (float)10.0f, (float)0.0f);
            }
        }
        mc.field_71424_I.func_76319_b();
        mc.field_71424_I.func_76320_a("cleanup");
        if (enableAlphaBlend) {
            GlStateManager.func_179084_k();
        }
        GlStateManager.func_179121_F();
    }
}

