/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.firstaid.client.gui;

import ichttt.mods.firstaid.FirstAid;
import ichttt.mods.firstaid.FirstAidConfig;
import ichttt.mods.firstaid.api.damagesystem.AbstractDamageablePart;
import ichttt.mods.firstaid.api.damagesystem.AbstractPlayerDamageModel;
import ichttt.mods.firstaid.api.enums.EnumPlayerPart;
import ichttt.mods.firstaid.client.ClientHooks;
import ichttt.mods.firstaid.client.HUDHandler;
import ichttt.mods.firstaid.client.gui.GuiHoldButton;
import ichttt.mods.firstaid.client.util.EventCalendar;
import ichttt.mods.firstaid.client.util.HealthRenderUtils;
import ichttt.mods.firstaid.common.apiimpl.FirstAidRegistryImpl;
import ichttt.mods.firstaid.common.network.MessageApplyHealingItem;
import ichttt.mods.firstaid.common.network.MessageClientRequest;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.StringUtils;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public class GuiHealthScreen
extends GuiScreen {
    public static final int xSize = 256;
    public static final int ySize = 137;
    public static final ItemStack BED_ITEMSTACK = new ItemStack((IItemProvider)Items.field_196098_bI);
    private static final DecimalFormat FORMAT = new DecimalFormat("##.#");
    public static GuiHealthScreen INSTANCE;
    public static boolean isOpen;
    private final AbstractPlayerDamageModel damageModel;
    private final List<GuiHoldButton> holdButtons = new ArrayList<GuiHoldButton>();
    private final boolean disableButtons;
    private final float bedScaleFactor = EventCalendar.isGuiFun() ? 2.0f : 1.25f;
    public int guiLeft;
    public int guiTop;
    private GuiButton head;
    private GuiButton leftArm;
    private GuiButton leftLeg;
    private GuiButton leftFoot;
    private GuiButton body;
    private GuiButton rightArm;
    private GuiButton rightLeg;
    private GuiButton rightFoot;
    private EnumHand activeHand;

    public GuiHealthScreen(AbstractPlayerDamageModel damageModel) {
        this.damageModel = damageModel;
        this.disableButtons = true;
    }

    public GuiHealthScreen(AbstractPlayerDamageModel damageModel, EnumHand activeHand) {
        this.damageModel = damageModel;
        this.activeHand = activeHand;
        this.disableButtons = false;
    }

    public void func_73866_w_() {
        isOpen = true;
        this.guiLeft = (this.field_146294_l - 256) / 2;
        this.guiTop = (this.field_146295_m - 137) / 2;
        this.head = new GuiHoldButton(1, this.guiLeft + 4, this.guiTop + 8, 52, 20, I18n.func_135052_a((String)"gui.head", (Object[])new Object[0]), false);
        this.func_189646_b(this.head);
        this.leftArm = new GuiHoldButton(2, this.guiLeft + 4, this.guiTop + 33, 52, 20, I18n.func_135052_a((String)"gui.left_arm", (Object[])new Object[0]), false);
        this.func_189646_b(this.leftArm);
        this.leftLeg = new GuiHoldButton(3, this.guiLeft + 4, this.guiTop + 58, 52, 20, I18n.func_135052_a((String)"gui.left_leg", (Object[])new Object[0]), false);
        this.func_189646_b(this.leftLeg);
        this.leftFoot = new GuiHoldButton(4, this.guiLeft + 4, this.guiTop + 83, 52, 20, I18n.func_135052_a((String)"gui.left_foot", (Object[])new Object[0]), false);
        this.func_189646_b(this.leftFoot);
        this.body = new GuiHoldButton(5, this.guiLeft + 199, this.guiTop + 8, 52, 20, I18n.func_135052_a((String)"gui.body", (Object[])new Object[0]), true);
        this.func_189646_b(this.body);
        this.rightArm = new GuiHoldButton(6, this.guiLeft + 199, this.guiTop + 33, 52, 20, I18n.func_135052_a((String)"gui.right_arm", (Object[])new Object[0]), true);
        this.func_189646_b(this.rightArm);
        this.rightLeg = new GuiHoldButton(7, this.guiLeft + 199, this.guiTop + 58, 52, 20, I18n.func_135052_a((String)"gui.right_leg", (Object[])new Object[0]), true);
        this.func_189646_b(this.rightLeg);
        this.rightFoot = new GuiHoldButton(8, this.guiLeft + 199, this.guiTop + 83, 52, 20, I18n.func_135052_a((String)"gui.right_foot", (Object[])new Object[0]), true);
        this.func_189646_b(this.rightFoot);
        if (this.disableButtons) {
            this.head.field_146124_l = false;
            this.leftArm.field_146124_l = false;
            this.leftLeg.field_146124_l = false;
            this.leftFoot.field_146124_l = false;
            this.body.field_146124_l = false;
            this.rightArm.field_146124_l = false;
            this.rightLeg.field_146124_l = false;
            this.rightFoot.field_146124_l = false;
        }
        GuiButton buttonCancel = new GuiButton(9, this.field_146294_l / 2 - 100, this.field_146295_m - 50, I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0])){

            public void func_194829_a(double mouseX, double mouseY) {
                GuiHealthScreen.this.field_146297_k.func_147108_a(null);
            }
        };
        this.func_189646_b(buttonCancel);
        if (this.field_146297_k.field_71474_y.field_74330_P) {
            GuiButton refresh = new GuiButton(10, this.guiLeft + 218, this.guiTop + 115, 36, 20, "resync"){

                public void func_194829_a(double mouseX, double mouseY) {
                    FirstAid.NETWORKING.sendToServer((Object)new MessageClientRequest(MessageClientRequest.Type.REQUEST_REFRESH));
                    FirstAid.LOGGER.info("Requesting refresh");
                    GuiHealthScreen.this.field_146297_k.field_71439_g.func_146105_b((ITextComponent)new TextComponentString("Re-downloading health data from server..."), true);
                    GuiHealthScreen.this.field_146297_k.func_147108_a(null);
                }
            };
            this.func_189646_b(refresh);
        }
        this.holdButtons.clear();
        for (GuiButton button : this.field_146292_n) {
            Integer holdTime;
            if (!(button instanceof GuiHoldButton)) continue;
            Integer n = holdTime = this.activeHand == null ? null : FirstAidRegistryImpl.INSTANCE.getPartHealingTime(this.field_146297_k.field_71439_g.func_184586_b(this.activeHand));
            if (holdTime == null) {
                holdTime = Integer.MAX_VALUE;
            }
            ((GuiHoldButton)button).setup(holdTime, (float)button.field_146120_f / (float)HUDHandler.INSTANCE.getMaxLength());
            this.holdButtons.add((GuiHoldButton)button);
        }
        super.func_73866_w_();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        this.func_73733_a(this.guiLeft, this.guiTop, this.guiLeft + 256, this.guiTop + 137, -16777216, -16777216);
        this.field_146297_k.func_110434_K().func_110577_a(HealthRenderUtils.GUI_LOCATION);
        this.func_73729_b(this.guiLeft, this.guiTop, 0, 0, 256, 137);
        int entityLookX = this.guiLeft + 128 - mouseX;
        int entityLookY = this.guiTop + 20 - mouseY;
        if (EventCalendar.isGuiFun()) {
            entityLookX = -entityLookX;
            entityLookY = -entityLookY;
        }
        GuiInventory.func_147046_a((int)(this.field_146294_l / 2), (int)(this.field_146295_m / 2 + 30), (int)45, (float)entityLookX, (float)entityLookY, (EntityLivingBase)this.field_146297_k.field_71439_g);
        super.func_73863_a(mouseX, mouseY, partialTicks);
        int morphineTicks = this.damageModel.getMorphineTicks();
        if (morphineTicks > 0) {
            this.func_73732_a(this.field_146297_k.field_71466_p, I18n.func_135052_a((String)"gui.morphine_left", (Object[])new Object[]{StringUtils.func_76337_a((int)morphineTicks)}), this.guiLeft + 128, this.guiTop + 137 - (this.activeHand == null ? 21 : 29), 0xFFFFFF);
        }
        if (this.activeHand != null) {
            this.func_73732_a(this.field_146297_k.field_71466_p, I18n.func_135052_a((String)"gui.apply_hint", (Object[])new Object[0]), this.guiLeft + 128, this.guiTop + 137 - (morphineTicks == 0 ? 21 : 11), 0xFFFFFF);
        }
        this.field_146297_k.func_110434_K().func_110577_a(Gui.field_110324_m);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.drawHealth(this.damageModel.HEAD, false, 14);
        this.drawHealth(this.damageModel.LEFT_ARM, false, 39);
        this.drawHealth(this.damageModel.LEFT_LEG, false, 64);
        this.drawHealth(this.damageModel.LEFT_FOOT, false, 89);
        this.drawHealth(this.damageModel.BODY, true, 14);
        this.drawHealth(this.damageModel.RIGHT_ARM, true, 39);
        this.drawHealth(this.damageModel.RIGHT_LEG, true, 64);
        this.drawHealth(this.damageModel.RIGHT_FOOT, true, 89);
        GlStateManager.func_179094_E();
        this.tooltipButton(this.head, this.damageModel.HEAD, mouseX, mouseY);
        this.tooltipButton(this.leftArm, this.damageModel.LEFT_ARM, mouseX, mouseY);
        this.tooltipButton(this.leftLeg, this.damageModel.LEFT_LEG, mouseX, mouseY);
        this.tooltipButton(this.leftFoot, this.damageModel.LEFT_FOOT, mouseX, mouseY);
        this.tooltipButton(this.body, this.damageModel.BODY, mouseX, mouseY);
        this.tooltipButton(this.rightArm, this.damageModel.RIGHT_ARM, mouseX, mouseY);
        this.tooltipButton(this.rightLeg, this.damageModel.RIGHT_LEG, mouseX, mouseY);
        this.tooltipButton(this.rightFoot, this.damageModel.RIGHT_FOOT, mouseX, mouseY);
        GlStateManager.func_179121_F();
        double sleepHealing = (Double)FirstAidConfig.SERVER.sleepHealPercentage.get();
        int renderBedX = Math.round((float)this.guiLeft / this.bedScaleFactor) + 2;
        int renderBedY = Math.round((float)(this.guiTop + 137) / this.bedScaleFactor) - 18;
        int bedX = (int)((float)renderBedX * this.bedScaleFactor);
        int bedY = (int)((float)renderBedY * this.bedScaleFactor);
        GlStateManager.func_179094_E();
        if (sleepHealing > 0.0) {
            RenderHelper.func_74520_c();
        }
        GlStateManager.func_179152_a((float)this.bedScaleFactor, (float)this.bedScaleFactor, (float)this.bedScaleFactor);
        this.field_146297_k.func_175599_af().func_184391_a(null, BED_ITEMSTACK, renderBedX, renderBedY);
        GlStateManager.func_179121_F();
        if (mouseX >= bedX && mouseY >= bedY && (float)mouseX < (float)bedX + 16.0f * this.bedScaleFactor && (float)mouseY < (float)bedY + 16.0f * this.bedScaleFactor) {
            String s = sleepHealing == 0.0 ? I18n.func_135052_a((String)"gui.no_sleep_heal", (Object[])new Object[0]) : I18n.func_135052_a((String)"gui.sleep_heal_amount", (Object[])new Object[]{FORMAT.format(sleepHealing * 100.0)});
            this.func_146279_a(s, mouseX, mouseY);
            GlStateManager.func_179140_f();
        }
        this.holdButtonMouseCallback(true);
    }

    private void tooltipButton(GuiButton button, AbstractDamageablePart part, int mouseX, int mouseY) {
        boolean enabled;
        boolean bl = enabled = part.activeHealer == null;
        if (!enabled && button.func_146115_a()) {
            this.func_146283_a(Arrays.asList(I18n.func_135052_a((String)"gui.active_item", (Object[])new Object[0]) + ": " + I18n.func_135052_a((String)(part.activeHealer.stack.func_77977_a() + ".name"), (Object[])new Object[0]), I18n.func_135052_a((String)"gui.next_heal", (Object[])new Object[]{Math.round((float)(part.activeHealer.ticksPerHeal.getAsInt() - part.activeHealer.getTicksPassed()) / 20.0f)})), mouseX, mouseY);
        }
        if (!this.disableButtons) {
            button.field_146124_l = enabled;
        }
    }

    public void drawHealth(AbstractDamageablePart damageablePart, boolean right, int yOffset) {
        GlStateManager.func_179094_E();
        int xTranslation = this.guiLeft + (right ? GuiHealthScreen.getRightOffset(damageablePart) : 57);
        HealthRenderUtils.drawHealth(damageablePart, xTranslation, this.guiTop + yOffset, (Gui)this, true);
        GlStateManager.func_179121_F();
    }

    private static int getRightOffset(AbstractDamageablePart damageablePart) {
        if (HealthRenderUtils.drawAsString(damageablePart, true)) {
            return 160;
        }
        return 200 - Math.min(40, HealthRenderUtils.getMaxHearts(damageablePart.getMaxHealth()) * 9 + HealthRenderUtils.getMaxHearts(damageablePart.getAbsorption()) * 9 + 2);
    }

    public boolean keyPressed(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (ClientHooks.showWounds.isActiveAndMatches(InputMappings.func_197954_a((int)p_keyPressed_1_, (int)p_keyPressed_2_))) {
            this.field_146297_k.func_147108_a(null);
        }
        return super.keyPressed(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
    }

    public boolean mouseReleased(double p_mouseReleased_1_, double p_mouseReleased_3_, int p_mouseReleased_5_) {
        this.holdButtonMouseCallback(false);
        return super.mouseReleased(p_mouseReleased_1_, p_mouseReleased_3_, p_mouseReleased_5_);
    }

    protected void holdButtonMouseCallback(boolean renderPass) {
        for (GuiHoldButton button : this.holdButtons) {
            int timeLeft = button.getTimeLeft();
            if (timeLeft == 0) {
                button.reset();
                EnumPlayerPart playerPart = EnumPlayerPart.fromID(button.field_146127_k);
                FirstAid.NETWORKING.sendToServer((Object)new MessageApplyHealingItem(playerPart, this.activeHand));
                AbstractDamageablePart part = this.damageModel.getFromEnum(playerPart);
                part.activeHealer = FirstAidRegistryImpl.INSTANCE.getPartHealer(this.field_146297_k.field_71439_g.func_184586_b(this.activeHand));
                this.field_146297_k.func_147108_a(null);
                continue;
            }
            if (!renderPass) {
                button.reset();
                continue;
            }
            if (timeLeft == -1) continue;
            float timeInSecs = (float)timeLeft / 1000.0f;
            if (timeInSecs < 0.0f) {
                timeInSecs = 0.0f;
            }
            this.field_146297_k.func_110434_K().func_110577_a(HealthRenderUtils.GUI_LOCATION);
            this.func_73729_b(button.field_146128_h + (button.isRightSide ? 56 : -25), button.field_146129_i - 2, button.isRightSide ? 2 : 0, 169, 22, 24);
            this.field_146297_k.field_71466_p.func_211126_b(HealthRenderUtils.TEXT_FORMAT.format(timeInSecs), (float)(button.field_146128_h + (button.isRightSide ? 60 : -20)), (float)(button.field_146129_i + 6), 0xFFFFFF);
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_146281_b() {
        INSTANCE = null;
        isOpen = false;
    }

    public List<GuiButton> getButtons() {
        return this.field_146292_n;
    }

    static {
        isOpen = false;
    }
}

