/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.firstaid.client.util;

import com.google.common.collect.ImmutableMap;
import ichttt.mods.firstaid.FirstAidConfig;
import ichttt.mods.firstaid.api.damagesystem.AbstractDamageablePart;
import ichttt.mods.firstaid.api.enums.EnumPlayerPart;
import ichttt.mods.firstaid.client.gui.FlashStateManager;
import ichttt.mods.firstaid.common.EventHandler;
import it.unimi.dsi.fastutil.ints.Int2IntArrayMap;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.text.DecimalFormat;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.init.MobEffects;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;

public class HealthRenderUtils {
    public static final ResourceLocation GUI_LOCATION = new ResourceLocation("firstaid", "textures/gui/show_wounds.png");
    public static final DecimalFormat TEXT_FORMAT = new DecimalFormat("0.0");
    private static final Object2IntOpenHashMap<EnumPlayerPart> prevHealth = new Object2IntOpenHashMap();
    private static final ImmutableMap<EnumPlayerPart, FlashStateManager> flashStates;

    public static void drawHealthString(AbstractDamageablePart damageablePart, float xTranslation, float yTranslation, boolean allowSecondLine) {
        float absorption = damageablePart.getAbsorption();
        String text = TEXT_FORMAT.format(damageablePart.currentHealth) + "/" + damageablePart.getMaxHealth();
        if (absorption > 0.0f) {
            String line2 = "+ " + TEXT_FORMAT.format(absorption);
            if (allowSecondLine) {
                Minecraft.func_71410_x().field_71466_p.func_175063_a(line2, xTranslation, yTranslation + 5.0f, 0xFFFFFF);
                yTranslation -= 5.0f;
            } else {
                text = text + " " + line2;
            }
        }
        Minecraft.func_71410_x().field_71466_p.func_175063_a(text, xTranslation, yTranslation, 0xFFFFFF);
    }

    private static void updatePrev(EnumPlayerPart part, int current, boolean playerDead) {
        if (!playerDead) {
            prevHealth.put((Object)part, current);
        } else {
            prevHealth.clear();
        }
    }

    public static boolean healthChanged(AbstractDamageablePart damageablePart, boolean playerDead) {
        int current = (int)Math.ceil(damageablePart.currentHealth);
        if (prevHealth.containsKey((Object)damageablePart.part)) {
            int prev = prevHealth.getInt((Object)damageablePart.part);
            HealthRenderUtils.updatePrev(damageablePart.part, current, playerDead);
            return prev != current;
        }
        HealthRenderUtils.updatePrev(damageablePart.part, current, playerDead);
        return true;
    }

    public static boolean drawAsString(AbstractDamageablePart damageablePart, boolean allowSecondLine) {
        int maxExtraHealth;
        int maxHealth = HealthRenderUtils.getMaxHearts(damageablePart.getMaxHealth());
        return maxHealth + (maxExtraHealth = HealthRenderUtils.getMaxHearts(damageablePart.getAbsorption())) > 8 && allowSecondLine || maxHealth + maxExtraHealth > 12;
    }

    public static void drawHealth(AbstractDamageablePart damageablePart, float xTranslation, float yTranslation, Gui gui, boolean allowSecondLine) {
        int prev;
        int maxHealth = HealthRenderUtils.getMaxHearts(damageablePart.getMaxHealth());
        int maxExtraHealth = HealthRenderUtils.getMaxHearts(damageablePart.getAbsorption());
        int current = (int)Math.ceil(damageablePart.currentHealth);
        FlashStateManager activeFlashState = (FlashStateManager)Objects.requireNonNull(flashStates.get((Object)damageablePart.part));
        if (prevHealth.containsKey((Object)damageablePart.part) && (prev = prevHealth.getInt((Object)damageablePart.part)) != current) {
            activeFlashState.setActive(Util.func_211177_b());
        }
        if (HealthRenderUtils.drawAsString(damageablePart, allowSecondLine)) {
            HealthRenderUtils.drawHealthString(damageablePart, xTranslation, yTranslation, allowSecondLine);
            return;
        }
        int yTexture = damageablePart.canCauseDeath ? 45 : 0;
        int absorption = (int)Math.ceil(damageablePart.getAbsorption());
        boolean highlight = activeFlashState.update(Util.func_211177_b());
        Minecraft mc = Minecraft.func_71410_x();
        int regen = -1;
        if (((Boolean)FirstAidConfig.SERVER.allowOtherHealingItems.get()).booleanValue() && mc.field_71439_g.func_70644_a(MobEffects.field_76428_l)) {
            regen = (int)(mc.field_71456_v.field_175191_F / 2L % 15L);
        }
        boolean low = (float)(current + absorption) < 1.25f;
        mc.func_110434_K().func_110577_a(Gui.field_110324_m);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)xTranslation, (float)yTranslation, (float)0.0f);
        boolean drawSecondLine = allowSecondLine;
        if (allowSecondLine) {
            boolean bl = drawSecondLine = maxHealth + maxExtraHealth > 4;
        }
        if (drawSecondLine) {
            int maxHealth2 = 0;
            if (maxHealth > 4) {
                maxHealth2 = maxHealth - 4;
                maxHealth = 4;
            }
            int maxExtraHealth2 = Math.max(0, maxExtraHealth - (4 - maxHealth));
            maxExtraHealth -= maxExtraHealth2;
            int current2 = 0;
            if (current > 8) {
                current2 = current - 8;
                current = 8;
            }
            int absorption2 = absorption - maxExtraHealth * 2;
            absorption -= absorption2;
            GlStateManager.func_179109_b((float)0.0f, (float)5.0f, (float)0.0f);
            GlStateManager.func_179094_E();
            HealthRenderUtils.renderLine(regen, low, yTexture, maxHealth2, maxExtraHealth2, current2, absorption2, gui, highlight);
            regen -= maxHealth2 + maxExtraHealth;
            GlStateManager.func_179121_F();
            GlStateManager.func_179109_b((float)0.0f, (float)-10.0f, (float)0.0f);
        }
        HealthRenderUtils.renderLine(regen, low, yTexture, maxHealth, maxExtraHealth, current, absorption, gui, highlight);
        GlStateManager.func_179121_F();
    }

    private static void renderLine(int regen, boolean low, int yTexture, int maxHealth, int maxExtraHearts, int current, int absorption, Gui gui, boolean highlight) {
        GlStateManager.func_179094_E();
        Int2IntArrayMap map = new Int2IntArrayMap();
        if (low) {
            for (int i = 0; i < maxHealth + maxExtraHearts; ++i) {
                map.put(i, EventHandler.rand.nextInt(2));
            }
        }
        HealthRenderUtils.renderMax(regen, (Int2IntFunction)map, maxHealth, yTexture, gui, highlight);
        if (maxExtraHearts > 0) {
            if (maxHealth != 0) {
                GlStateManager.func_179109_b((float)(2 + 9 * maxHealth), (float)0.0f, (float)0.0f);
            }
            HealthRenderUtils.renderMax(regen - maxHealth, (Int2IntFunction)map, maxExtraHearts, yTexture, gui, false);
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)1.0f);
        HealthRenderUtils.renderCurrentHealth(regen, (Int2IntFunction)map, current, yTexture, gui);
        if (absorption > 0) {
            int offset = maxHealth * 9 + (maxHealth == 0 ? 0 : 2);
            GlStateManager.func_179109_b((float)offset, (float)0.0f, (float)0.0f);
            HealthRenderUtils.renderAbsorption(regen - maxHealth, (Int2IntFunction)map, absorption, yTexture, gui);
        }
    }

    public static int getMaxHearts(float value) {
        int maxCurrentHearts = (int)Math.ceil(value);
        if (maxCurrentHearts % 2 != 0) {
            ++maxCurrentHearts;
        }
        return maxCurrentHearts >> 1;
    }

    private static void renderMax(int regen, Int2IntFunction function, int max, int yTexture, Gui gui, boolean highlight) {
        int BACKGROUND = highlight ? 25 : 16;
        HealthRenderUtils.renderTexturedModalRects(regen, function, max, false, BACKGROUND, BACKGROUND, yTexture, gui);
    }

    private static void renderCurrentHealth(int regen, Int2IntFunction function, int current, int yTexture, Gui gui) {
        boolean renderLastHalf = false;
        int render = current >> 1;
        if (current % 2 != 0) {
            renderLastHalf = true;
            ++render;
        }
        HealthRenderUtils.renderTexturedModalRects(regen, function, render, renderLastHalf, 61, 52, yTexture, gui);
    }

    private static void renderAbsorption(int regen, Int2IntFunction function, int absorption, int yTexture, Gui gui) {
        boolean renderLastHalf = false;
        int render = absorption >> 1;
        if (absorption % 2 != 0) {
            renderLastHalf = true;
            ++render;
        }
        if (render > 0) {
            HealthRenderUtils.renderTexturedModalRects(regen, function, render, renderLastHalf, 169, 160, yTexture, gui);
        }
    }

    private static void renderTexturedModalRects(int regen, Int2IntFunction function, int toDraw, boolean lastOneHalf, int halfTextureX, int textureX, int textureY, Gui gui) {
        if (toDraw == 0) {
            return;
        }
        if (toDraw < 0) {
            throw new IllegalArgumentException("Cannot draw negative amount of icons " + toDraw);
        }
        for (int i = 0; i < toDraw; ++i) {
            boolean renderHalf = lastOneHalf && i + 1 == toDraw;
            gui.func_175174_a(9.0f * (float)i, (float)((i == regen ? -2 : 0) - function.get(i)), renderHalf ? halfTextureX : textureX, textureY, 9, 9);
        }
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (EnumPlayerPart part : EnumPlayerPart.VALUES) {
            builder.put((Object)part, (Object)new FlashStateManager());
        }
        flashStates = builder.build();
    }
}

