/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.firstaid.client.util;

import ichttt.mods.firstaid.api.damagesystem.AbstractDamageablePart;
import ichttt.mods.firstaid.api.damagesystem.AbstractPlayerDamageModel;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;

public class PlayerModelRenderer {
    private static final ResourceLocation HEALTH_RENDER_LOCATION = new ResourceLocation("firstaid", "textures/gui/simple_health.png");
    private static final int SIZE = 64;

    public static void renderPlayerHealth(AbstractPlayerDamageModel damageModel, Gui gui, float alpha) {
        GlStateManager.func_179141_d();
        GlStateManager.func_179147_l();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)(1.0f - alpha / 255.0f));
        Minecraft.func_71410_x().func_110434_K().func_110577_a(HEALTH_RENDER_LOCATION);
        GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
        PlayerModelRenderer.drawPart(gui, damageModel.HEAD, 16, 0, 32, 32);
        PlayerModelRenderer.drawPart(gui, damageModel.BODY, 16, 32, 32, 48);
        PlayerModelRenderer.drawPart(gui, damageModel.LEFT_ARM, 0, 32, 16, 48);
        PlayerModelRenderer.drawPart(gui, damageModel.RIGHT_ARM, 48, 32, 16, 48);
        PlayerModelRenderer.drawPart(gui, damageModel.LEFT_LEG, 16, 80, 16, 32);
        PlayerModelRenderer.drawPart(gui, damageModel.RIGHT_LEG, 32, 80, 16, 32);
        PlayerModelRenderer.drawPart(gui, damageModel.LEFT_FOOT, 16, 112, 16, 16);
        PlayerModelRenderer.drawPart(gui, damageModel.RIGHT_FOOT, 32, 112, 16, 16);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private static void drawPart(Gui gui, AbstractDamageablePart part, int texX, int texY, int sizeX, int sizeY) {
        int rawTexX = texX;
        int maxHealth = part.getMaxHealth();
        if ((double)part.currentHealth <= 0.001) {
            texX += 192;
        } else if ((double)Math.abs(part.currentHealth - (float)maxHealth) > 0.001) {
            float healthPercentage = part.currentHealth / (float)maxHealth;
            if (healthPercentage >= 1.0f || healthPercentage <= 0.0f) {
                throw new RuntimeException(String.format("Calculated invalid health for part %s with current health %s and max health %d. Got value %s", new Object[]{part.part, Float.valueOf(part.currentHealth), maxHealth, Float.valueOf(healthPercentage)}));
            }
            texX += 64 * ((double)healthPercentage > 0.5 ? 1 : 2);
        }
        gui.func_73729_b(rawTexX, texY, texX, texY, sizeX, sizeY);
    }
}

