/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.firstaid.common;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import ichttt.mods.firstaid.FirstAid;
import ichttt.mods.firstaid.api.damagesystem.AbstractPlayerDamageModel;
import ichttt.mods.firstaid.api.enums.EnumPlayerPart;
import ichttt.mods.firstaid.common.damagesystem.distribution.DamageDistribution;
import ichttt.mods.firstaid.common.damagesystem.distribution.DirectDamageDistribution;
import ichttt.mods.firstaid.common.network.MessageReceiveDamage;
import ichttt.mods.firstaid.common.util.CommonUtils;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.DamageSource;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.network.PacketDistributor;

public class DebugDamageCommand {
    private static final SimpleCommandExceptionType TYPE = new SimpleCommandExceptionType((Message)new TextComponentString("0 is invalid as damage"));

    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.func_197057_a((String)"damagePart").requires(source -> source.func_197034_c(2));
        for (EnumPlayerPart part : EnumPlayerPart.VALUES) {
            builder.then(Commands.func_197057_a((String)part.name()).then(Commands.func_197056_a((String)"damage", (ArgumentType)FloatArgumentType.floatArg()).executes(context -> DebugDamageCommand.damage(part, FloatArgumentType.getFloat((CommandContext)context, (String)"damage"), true, ((CommandSource)context.getSource()).func_197035_h()))));
        }
        dispatcher.register(builder);
    }

    private static int damage(EnumPlayerPart part, float damage, boolean debuff, EntityPlayerMP player) throws CommandSyntaxException {
        if (damage == 0.0f) {
            throw TYPE.create();
        }
        AbstractPlayerDamageModel damageModel = CommonUtils.getDamageModel((EntityPlayer)player);
        if (damage > 0.0f) {
            DamageDistribution.handleDamageTaken(new DirectDamageDistribution(part, debuff), damageModel, damage, (EntityPlayer)player, DamageSource.field_76380_i, false, false);
        } else {
            damageModel.getFromEnum(part).heal(-damage, (EntityPlayer)player, debuff);
        }
        FirstAid.NETWORKING.send(PacketDistributor.PLAYER.with(() -> player), (Object)new MessageReceiveDamage(part, damage, 0.0f));
        if (damageModel.isDead((EntityPlayer)player)) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("death.attack.generic", new Object[]{player.func_145748_c_()}));
            CommonUtils.killPlayer((EntityPlayer)player, null);
        }
        return 1;
    }
}

