/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.firstaid.common;

import com.mojang.brigadier.CommandDispatcher;
import ichttt.mods.firstaid.FirstAid;
import ichttt.mods.firstaid.FirstAidConfig;
import ichttt.mods.firstaid.api.IDamageDistribution;
import ichttt.mods.firstaid.api.damagesystem.AbstractPlayerDamageModel;
import ichttt.mods.firstaid.api.enums.EnumPlayerPart;
import ichttt.mods.firstaid.common.CapProvider;
import ichttt.mods.firstaid.common.DataManagerWrapper;
import ichttt.mods.firstaid.common.DebugDamageCommand;
import ichttt.mods.firstaid.common.apiimpl.FirstAidRegistryImpl;
import ichttt.mods.firstaid.common.damagesystem.PlayerDamageModel;
import ichttt.mods.firstaid.common.damagesystem.distribution.DamageDistribution;
import ichttt.mods.firstaid.common.damagesystem.distribution.HealthDistribution;
import ichttt.mods.firstaid.common.damagesystem.distribution.PreferredDamageDistribution;
import ichttt.mods.firstaid.common.items.FirstAidItems;
import ichttt.mods.firstaid.common.network.MessageConfiguration;
import ichttt.mods.firstaid.common.network.MessageReceiveDamage;
import ichttt.mods.firstaid.common.network.MessageSyncDamageModel;
import ichttt.mods.firstaid.common.util.CommonUtils;
import ichttt.mods.firstaid.common.util.ProjectileHelper;
import java.util.Arrays;
import java.util.Map;
import java.util.Random;
import java.util.WeakHashMap;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.util.DamageSource;
import net.minecraft.util.FoodStats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraft.world.storage.loot.functions.SetCount;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppedEvent;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.registries.ObjectHolder;
import org.apache.commons.lang3.tuple.Pair;

public class EventHandler {
    public static final Random rand = new Random();
    @ObjectHolder(value="firstaid:debuff.heartbeat")
    public static final SoundEvent HEARTBEAT = (SoundEvent)FirstAidItems.getNull();
    @ObjectHolder(value="firstaid:morphine")
    public static final Potion MORPHINE = (Potion)FirstAidItems.getNull();
    @ObjectHolder(value="minecraft:poisen")
    public static final Potion POISON_PATCHED = (Potion)FirstAidItems.getNull();
    public static final Map<EntityPlayer, Pair<Entity, RayTraceResult>> hitList = new WeakHashMap<EntityPlayer, Pair<Entity, RayTraceResult>>();

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onLivingHurt(LivingHurtEvent event) {
        Entity entityProjectile;
        EntityEquipmentSlot slot;
        Pair<Entity, RayTraceResult> rayTraceResult;
        EntityLivingBase entity = event.getEntityLiving();
        if (entity.field_70170_p.field_72995_K || !CommonUtils.hasDamageModel((Entity)entity)) {
            return;
        }
        float amountToDamage = event.getAmount();
        EntityPlayer player = (EntityPlayer)entity;
        AbstractPlayerDamageModel damageModel = CommonUtils.getDamageModel(player);
        DamageSource source = event.getSource();
        if (amountToDamage == Float.MAX_VALUE) {
            damageModel.forEach(damageablePart -> {
                damageablePart.currentHealth = 0.0f;
            });
            if (player instanceof EntityPlayerMP) {
                Arrays.stream(EnumPlayerPart.VALUES).forEach(part -> FirstAid.NETWORKING.send(PacketDistributor.PLAYER.with(() -> (EntityPlayerMP)player), (Object)new MessageReceiveDamage((EnumPlayerPart)((Object)part), Float.MAX_VALUE, 0.0f)));
            }
            event.setCanceled(true);
            CommonUtils.killPlayer(player, source);
            return;
        }
        boolean addStat = amountToDamage < 3.4028235E37f;
        IDamageDistribution damageDistribution = FirstAidRegistryImpl.INSTANCE.getDamageDistribution(source);
        if (source.func_76352_a() && (rayTraceResult = hitList.remove(player)) != null && (slot = ProjectileHelper.getPartByPosition(entityProjectile = (Entity)rayTraceResult.getLeft(), player)) != null) {
            damageDistribution = new PreferredDamageDistribution(slot);
        }
        DamageDistribution.handleDamageTaken(damageDistribution, damageModel, amountToDamage, player, source, addStat, true);
        event.setCanceled(true);
        hitList.remove(player);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onProjectileImpact(ProjectileImpactEvent event) {
        RayTraceResult result = event.getRayTraceResult();
        if (result.field_72313_a != RayTraceResult.Type.ENTITY) {
            return;
        }
        Entity entity = result.field_72308_g;
        if (!entity.field_70170_p.field_72995_K && entity instanceof EntityPlayer) {
            hitList.put((EntityPlayer)entity, (Pair<Entity, RayTraceResult>)Pair.of((Object)event.getEntity(), (Object)event.getRayTraceResult()));
        }
    }

    @SubscribeEvent
    public static void registerCapability(AttachCapabilitiesEvent<Entity> event) {
        Entity obj = (Entity)event.getObject();
        if (CommonUtils.hasDamageModel(obj)) {
            EntityPlayer player = (EntityPlayer)obj;
            PlayerDamageModel damageModel = PlayerDamageModel.create();
            event.addCapability(CapProvider.IDENTIFIER, (ICapabilityProvider)new CapProvider(damageModel));
            player.field_70180_af = new DataManagerWrapper(player, player.field_70180_af);
        }
    }

    @SubscribeEvent
    public static void tickPlayers(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && CommonUtils.isSurvivalOrAdventure(event.player)) {
            if (!event.player.func_70089_S()) {
                return;
            }
            CommonUtils.getDamageModel(event.player).tick(event.player.field_70170_p, event.player);
            hitList.remove(event.player);
        }
    }

    @SubscribeEvent
    public static void tickWorld(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        if ((Double)FirstAidConfig.SERVER.sleepHealPercentage.get() <= 0.0) {
            return;
        }
        World world = event.world;
        if (!world.field_72995_K && world instanceof WorldServer && ((WorldServer)world).func_73056_e()) {
            for (EntityPlayer player : world.field_73010_i) {
                CommonUtils.getDamageModel(player).sleepHeal(player);
            }
        }
    }

    @SubscribeEvent
    public static void onLootTableLoad(LootTableLoadEvent event) {
        ResourceLocation tableName = event.getName();
        LootPool pool = null;
        int bandage = 0;
        int plaster = 0;
        int morphine = 0;
        if (tableName.equals((Object)LootTableList.field_186420_b)) {
            pool = event.getTable().getPool("main");
            bandage = 8;
            plaster = 16;
            morphine = 4;
        } else if (tableName.equals((Object)LootTableList.field_186428_j) || tableName.equals((Object)LootTableList.field_186427_i) || tableName.equals((Object)LootTableList.field_186424_f)) {
            pool = event.getTable().getPool("main");
            bandage = 20;
            plaster = 24;
            morphine = 8;
        }
        if (pool != null) {
            pool.addEntry((LootEntry)new LootEntryItem(FirstAidItems.BANDAGE, bandage, 0, (LootFunction[])new SetCount[]{new SetCount(new LootCondition[0], new RandomValueRange(1.0f, 3.0f))}, new LootCondition[0], "firstaidbandage"));
            pool.addEntry((LootEntry)new LootEntryItem(FirstAidItems.PLASTER, plaster, 0, (LootFunction[])new SetCount[]{new SetCount(new LootCondition[0], new RandomValueRange(1.0f, 5.0f))}, new LootCondition[0], "firstaidplaster"));
            pool.addEntry((LootEntry)new LootEntryItem(FirstAidItems.MORPHINE, morphine, 0, (LootFunction[])new SetCount[]{new SetCount(new LootCondition[0], new RandomValueRange(1.0f, 2.0f))}, new LootCondition[0], "firstaidmorphine"));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onHeal(LivingHealEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        if (!CommonUtils.hasDamageModel((Entity)entity)) {
            return;
        }
        event.setCanceled(true);
        if (!((Boolean)FirstAidConfig.SERVER.allowOtherHealingItems.get()).booleanValue()) {
            return;
        }
        float amount = event.getAmount();
        if (Arrays.stream(Thread.currentThread().getStackTrace()).anyMatch(stackTraceElement -> stackTraceElement.getClassName().equals(FoodStats.class.getName()))) {
            if (((Boolean)FirstAidConfig.SERVER.allowNaturalRegeneration.get()).booleanValue()) {
                amount *= (float)((Double)FirstAidConfig.SERVER.naturalRegenMultiplier.get()).doubleValue();
            }
        } else {
            amount *= (float)((Double)FirstAidConfig.SERVER.otherRegenMultiplier.get()).doubleValue();
        }
        if (FirstAidConfig.debug) {
            CommonUtils.debugLogStacktrace("External healing: : " + amount);
        }
        HealthDistribution.distributeHealth(amount, (EntityPlayer)entity, true);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.getPlayer().field_70170_p.field_72995_K) {
            FirstAid.LOGGER.debug("Sending damage model to " + event.getPlayer().func_200200_C_());
            AbstractPlayerDamageModel damageModel = CommonUtils.getDamageModel(event.getPlayer());
            if (damageModel.hasTutorial) {
                CapProvider.tutorialDone.add(event.getPlayer().func_200200_C_().getString());
            }
            EntityPlayerMP playerMP = (EntityPlayerMP)event.getPlayer();
            FirstAid.NETWORKING.send(PacketDistributor.PLAYER.with(() -> playerMP), (Object)new MessageConfiguration((NBTTagCompound)damageModel.serializeNBT()));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        hitList.remove(event.getPlayer());
    }

    @SubscribeEvent
    public static void onWorldLoad(WorldEvent.Load event) {
        IWorld world = event.getWorld();
        if (!world.func_201670_d() && world instanceof World) {
            ((World)world).func_82736_K().func_82764_b("naturalRegeneration", Boolean.toString((Boolean)FirstAidConfig.SERVER.allowNaturalRegeneration.get()), ((World)world).func_73046_m());
        }
    }

    @SubscribeEvent
    public static void onDimensionChange(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (!event.getPlayer().field_70170_p.field_72995_K && event.getPlayer() instanceof EntityPlayerMP) {
            FirstAid.NETWORKING.send(PacketDistributor.PLAYER.with(() -> (EntityPlayerMP)event.getPlayer()), (Object)new MessageSyncDamageModel(CommonUtils.getDamageModel(event.getPlayer())));
        }
    }

    @SubscribeEvent
    public static void beforeServerStart(FMLServerStartingEvent event) {
        DebugDamageCommand.register((CommandDispatcher<CommandSource>)event.getCommandDispatcher());
    }

    @SubscribeEvent
    public static void onServerStop(FMLServerStoppedEvent event) {
        FirstAid.LOGGER.debug("Cleaning up");
        CapProvider.tutorialDone.clear();
        hitList.clear();
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        EntityPlayer player = event.getPlayer();
        if (!event.isEndConquered() && !player.field_70170_p.field_72995_K && player instanceof EntityPlayerMP) {
            AbstractPlayerDamageModel damageModel = CommonUtils.getDamageModel(player);
            damageModel.runScaleLogic(player);
            damageModel.forEach(damageablePart -> damageablePart.heal(damageablePart.getMaxHealth(), player, false));
            damageModel.scheduleResync();
        }
    }
}

