/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.firstaid.common.apiimpl;

import com.google.common.primitives.Floats;
import com.google.common.primitives.Ints;
import ichttt.mods.firstaid.FirstAid;
import ichttt.mods.firstaid.FirstAidConfig;
import ichttt.mods.firstaid.api.FirstAidRegistry;
import ichttt.mods.firstaid.api.debuff.builder.DebuffBuilderFactory;
import ichttt.mods.firstaid.api.debuff.builder.IDebuffBuilder;
import ichttt.mods.firstaid.api.enums.EnumDebuffSlot;
import ichttt.mods.firstaid.api.enums.EnumPlayerPart;
import ichttt.mods.firstaid.common.EventHandler;
import ichttt.mods.firstaid.common.apiimpl.DebuffBuilderFactoryImpl;
import ichttt.mods.firstaid.common.apiimpl.FirstAidRegistryImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;

public class RegistryManager {
    public static final List<String> debuffConfigErrors = new ArrayList<String>();

    public static void setupRegistries() {
        FirstAidRegistry.setImpl(FirstAidRegistryImpl.INSTANCE);
        DebuffBuilderFactory.setInstance(DebuffBuilderFactoryImpl.INSTANCE);
    }

    public static void registerDefaults() {
        FirstAid.LOGGER.debug("Registering defaults registry values");
        FirstAidRegistry registry = Objects.requireNonNull(FirstAidRegistry.getImpl());
        ArrayList<Pair<EntityEquipmentSlot, EnumPlayerPart[]>> feetList = new ArrayList<Pair<EntityEquipmentSlot, EnumPlayerPart[]>>(2);
        feetList.add(Pair.of((Object)EntityEquipmentSlot.FEET, (Object)new EnumPlayerPart[]{EnumPlayerPart.LEFT_FOOT, EnumPlayerPart.RIGHT_FOOT}));
        feetList.add(Pair.of((Object)EntityEquipmentSlot.LEGS, (Object)new EnumPlayerPart[]{EnumPlayerPart.LEFT_LEG, EnumPlayerPart.RIGHT_LEG}));
        registry.bindDamageSourceStandard(DamageSource.field_76379_h, feetList, false);
        registry.bindDamageSourceStandard(DamageSource.field_190095_e, feetList, false);
        ArrayList<Pair<EntityEquipmentSlot, EnumPlayerPart[]>> headList = new ArrayList<Pair<EntityEquipmentSlot, EnumPlayerPart[]>>(1);
        headList.add(Pair.of((Object)EntityEquipmentSlot.HEAD, (Object)new EnumPlayerPart[]{EnumPlayerPart.HEAD}));
        registry.bindDamageSourceStandard(DamageSource.field_82728_o, headList, false);
        ArrayList<Pair<EntityEquipmentSlot, EnumPlayerPart[]>> headArmsList = new ArrayList<Pair<EntityEquipmentSlot, EnumPlayerPart[]>>(2);
        headArmsList.add(Pair.of((Object)EntityEquipmentSlot.HEAD, (Object)new EnumPlayerPart[]{EnumPlayerPart.HEAD}));
        headArmsList.add(Pair.of((Object)EntityEquipmentSlot.CHEST, (Object)new EnumPlayerPart[]{EnumPlayerPart.LEFT_ARM, EnumPlayerPart.RIGHT_ARM}));
        registry.bindDamageSourceStandard(DamageSource.field_180137_b, headArmsList, true);
        registry.bindDamageSourceRandom(DamageSource.field_76376_m, false, false);
        if (FirstAidConfig.hardMode) {
            ArrayList<Pair<EntityEquipmentSlot, EnumPlayerPart[]>> bodyList = new ArrayList<Pair<EntityEquipmentSlot, EnumPlayerPart[]>>(1);
            bodyList.add(Pair.of((Object)EntityEquipmentSlot.CHEST, (Object)new EnumPlayerPart[]{EnumPlayerPart.BODY}));
            registry.bindDamageSourceStandard(DamageSource.field_76366_f, bodyList, false);
            ArrayList<Pair<EntityEquipmentSlot, EnumPlayerPart[]>> headBodyList = new ArrayList<Pair<EntityEquipmentSlot, EnumPlayerPart[]>>(2);
            headBodyList.add(Pair.of((Object)EntityEquipmentSlot.CHEST, (Object)new EnumPlayerPart[]{EnumPlayerPart.BODY}));
            headBodyList.add(Pair.of((Object)EntityEquipmentSlot.HEAD, (Object)new EnumPlayerPart[]{EnumPlayerPart.HEAD}));
            registry.bindDamageSourceStandard(DamageSource.field_76369_e, headBodyList, true);
        } else {
            registry.bindDamageSourceRandom(DamageSource.field_76366_f, false, true);
            registry.bindDamageSourceRandom(DamageSource.field_76369_e, false, true);
        }
        registry.bindDamageSourceRandom(DamageSource.field_76368_d, false, true);
        DebuffBuilderFactory factory = DebuffBuilderFactory.getInstance();
        RegistryManager.loadValuesFromConfig(factory, "blindness", () -> EventHandler.HEARTBEAT, FirstAidConfig.GENERAL.head.blindnessConditions, EnumDebuffSlot.HEAD);
        RegistryManager.loadValuesFromConfig(factory, "nausea", null, FirstAidConfig.GENERAL.head.nauseaConditions, EnumDebuffSlot.HEAD);
        RegistryManager.loadValuesFromConfig(factory, "nausea", null, FirstAidConfig.GENERAL.body.nauseaConditions, EnumDebuffSlot.BODY);
        RegistryManager.loadValuesFromConfig(factory, "weakness", FirstAidConfig.GENERAL.body.weaknessConditions, EnumDebuffSlot.BODY);
        RegistryManager.loadValuesFromConfig(factory, "mining_fatigue", FirstAidConfig.GENERAL.arms.miningFatigueConditions, EnumDebuffSlot.ARMS);
        RegistryManager.loadValuesFromConfig(factory, "slowness", FirstAidConfig.GENERAL.legsAndFeet.slownessConditions, EnumDebuffSlot.LEGS_AND_FEET);
    }

    private static void loadValuesFromConfig(DebuffBuilderFactory factory, String potionName, Supplier<SoundEvent> event, FirstAidConfig.General.ConditionOnHit config, EnumDebuffSlot slot) {
        float[] damageTaken = Floats.toArray((Collection)((Collection)config.damageTaken.get()));
        int[] debuffLength = Ints.toArray((Collection)((Collection)config.debuffLength.get()));
        if (debuffLength.length != damageTaken.length) {
            RegistryManager.logError("The fields to not have the same amount of values!", potionName, slot);
            return;
        }
        if (debuffLength.length == 0) {
            RegistryManager.logError("The fields are empty!", potionName, slot);
            return;
        }
        float[] healthPercentageLeft = new float[damageTaken.length];
        System.arraycopy(damageTaken, 0, healthPercentageLeft, 0, damageTaken.length);
        Arrays.sort(healthPercentageLeft);
        ArrayUtils.reverse((float[])healthPercentageLeft);
        if (!Arrays.equals(healthPercentageLeft, damageTaken)) {
            RegistryManager.logError("The damageTaken field is not sorted right!", potionName, slot);
            return;
        }
        IDebuffBuilder builder = factory.newOnHitDebuffBuilder(potionName);
        builder.addEnableCondition(() -> ((ForgeConfigSpec.BooleanValue)config.enabled).get());
        for (int i = 0; i < damageTaken.length; ++i) {
            builder.addBound(damageTaken[i], debuffLength[i]);
        }
        if (event != null) {
            builder.addSoundEffect(event);
        }
        builder.register(slot);
    }

    private static void loadValuesFromConfig(DebuffBuilderFactory factory, String potionName, FirstAidConfig.General.ConditionConstant config, EnumDebuffSlot slot) {
        float[] healthPercentageLeft;
        int[] debuffStrength = Ints.toArray((Collection)((Collection)config.debuffStrength.get()));
        if (debuffStrength.length != (healthPercentageLeft = Floats.toArray((Collection)((Collection)config.healthPercentageLeft.get()))).length) {
            RegistryManager.logError("The fields to not have the same amount of values!", potionName, slot);
            return;
        }
        if (healthPercentageLeft.length == 0) {
            RegistryManager.logError("The fields are empty!", potionName, slot);
            return;
        }
        if (!ArrayUtils.isSorted((float[])healthPercentageLeft)) {
            RegistryManager.logError("The healthPercentageLeft field is not sorted right!", potionName, slot);
            return;
        }
        IDebuffBuilder builder = factory.newConstantDebuffBuilder(potionName);
        builder.addEnableCondition(() -> ((ForgeConfigSpec.BooleanValue)config.enabled).get());
        for (int i = 0; i < healthPercentageLeft.length; ++i) {
            builder.addBound(healthPercentageLeft[i], debuffStrength[i]);
        }
        builder.register(slot);
    }

    private static void logError(String error, String potionName, EnumDebuffSlot slot) {
        String errorMsg = String.format("Invalid config entry for debuff %s at part %s: %s", potionName, slot.toString(), error);
        FirstAid.LOGGER.warn(errorMsg);
        debuffConfigErrors.add(errorMsg);
    }

    public static void finalizeRegistries() {
        FirstAidRegistryImpl.finish();
        DebuffBuilderFactoryImpl.verify();
    }
}

