/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.firstaid.common.damagesystem;

import ichttt.mods.firstaid.FirstAid;
import ichttt.mods.firstaid.FirstAidConfig;
import ichttt.mods.firstaid.api.damagesystem.AbstractDamageablePart;
import ichttt.mods.firstaid.api.damagesystem.AbstractPartHealer;
import ichttt.mods.firstaid.api.debuff.IDebuff;
import ichttt.mods.firstaid.api.enums.EnumPlayerPart;
import ichttt.mods.firstaid.common.apiimpl.FirstAidRegistryImpl;
import ichttt.mods.firstaid.common.items.FirstAidItems;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.INBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.World;

public class DamageablePart
extends AbstractDamageablePart {
    private int maxHealth;
    @Nonnull
    private final IDebuff[] debuffs;
    private float absorption;

    public DamageablePart(int maxHealth, boolean canCauseDeath, @Nonnull EnumPlayerPart playerPart, IDebuff ... debuffs) {
        super(maxHealth, canCauseDeath, playerPart);
        this.maxHealth = maxHealth;
        this.currentHealth = maxHealth;
        this.debuffs = debuffs;
    }

    @Override
    public float heal(float amount, @Nullable EntityPlayer player, boolean applyDebuff) {
        if (amount <= 0.0f) {
            return 0.0f;
        }
        float notFitting = Math.abs(Math.min(0.0f, (float)this.maxHealth - (this.currentHealth + amount)));
        this.currentHealth = Math.min((float)this.maxHealth, this.currentHealth + amount);
        if (notFitting > 0.0f) {
            float oldHealth = this.currentHealth;
            this.currentHealth = Math.min(this.currentHealth + notFitting, this.currentHealth);
            notFitting -= this.currentHealth - oldHealth;
        }
        float finalNotFitting = notFitting;
        if (applyDebuff) {
            Objects.requireNonNull(player, "Got null player with applyDebuff = true");
            Arrays.stream(this.debuffs).forEach(debuff -> debuff.handleHealing(amount - finalNotFitting, this.currentHealth / (float)this.maxHealth, (EntityPlayerMP)player));
        }
        return notFitting;
    }

    @Override
    public float damage(float amount, @Nullable EntityPlayer player, boolean applyDebuff) {
        return this.damage(amount, player, applyDebuff, 0.0f);
    }

    @Override
    public float damage(float amount, @Nullable EntityPlayer player, boolean applyDebuff, float minHealth) {
        if (amount <= 0.0f) {
            return 0.0f;
        }
        if (minHealth > (float)this.maxHealth) {
            throw new IllegalArgumentException("Cannot damage part with minHealth " + minHealth + " while he has more max health (" + this.maxHealth + ")");
        }
        float origAmount = amount;
        if (this.absorption > 0.0f) {
            amount = Math.abs(Math.min(0.0f, this.absorption - origAmount));
            this.absorption = Math.max(0.0f, this.absorption - origAmount);
        }
        float notFitting = Math.abs(Math.min(minHealth, this.currentHealth - amount) - minHealth);
        this.currentHealth = Math.max(minHealth, this.currentHealth - amount);
        if (applyDebuff) {
            Objects.requireNonNull(player, "Got null player with applyDebuff = true");
            Arrays.stream(this.debuffs).forEach(debuff -> debuff.handleDamageTaken(origAmount - notFitting, this.currentHealth / (float)this.maxHealth, (EntityPlayerMP)player));
        }
        return notFitting;
    }

    @Override
    public void tick(World world, EntityPlayer player, boolean tickDebuffs) {
        if (this.activeHealer != null) {
            if (this.activeHealer.tick()) {
                this.heal(1.0f, player, !world.field_72995_K);
            }
            if (this.activeHealer.hasFinished()) {
                this.activeHealer = null;
            }
        }
        if (!world.field_72995_K && tickDebuffs) {
            Arrays.stream(this.debuffs).forEach(debuff -> debuff.update(player, this.currentHealth / (float)this.maxHealth));
        }
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74776_a("health", this.currentHealth);
        if (FirstAidConfig.scaleMaxHealth) {
            compound.func_74768_a("maxHealth", this.maxHealth);
        }
        if (this.absorption > 0.0f) {
            compound.func_74776_a("absorption", this.absorption);
        }
        if (this.activeHealer != null) {
            compound.func_74782_a("healer", (INBTBase)this.activeHealer.stack.serializeNBT());
            compound.func_74768_a("itemTicks", this.activeHealer.getTicksPassed());
            compound.func_74768_a("itemHeals", this.activeHealer.getHealsDone());
        }
        return compound;
    }

    public void deserializeNBT(@Nullable NBTTagCompound nbt) {
        if (nbt == null) {
            return;
        }
        if (nbt.func_74764_b("maxHealth") && FirstAidConfig.scaleMaxHealth) {
            this.maxHealth = nbt.func_74762_e("maxHealth");
        }
        this.currentHealth = Math.min((float)this.maxHealth, nbt.func_74760_g("health"));
        ItemStack stack = null;
        if (nbt.func_74764_b("healingItem")) {
            stack = new ItemStack((IItemProvider)(nbt.func_74771_c("healingItem") == 1 ? FirstAidItems.PLASTER : FirstAidItems.BANDAGE));
        } else if (nbt.func_74764_b("healer")) {
            stack = ItemStack.func_199557_a((NBTTagCompound)((NBTTagCompound)nbt.func_74781_a("healer")));
        }
        if (stack != null) {
            AbstractPartHealer healer = FirstAidRegistryImpl.INSTANCE.getPartHealer(stack);
            if (healer == null) {
                FirstAid.LOGGER.warn("Failed to lookup healer for item {}", (Object)stack.func_77973_b());
            } else {
                this.activeHealer = healer.loadNBT(nbt.func_74762_e("itemTicks"), nbt.func_74762_e("itemHeals"));
            }
        }
        if (nbt.func_74764_b("absorption")) {
            this.absorption = nbt.func_74760_g("absorption");
        }
        Arrays.stream(this.debuffs).forEach(debuff -> debuff.handleHealing(0.0f, this.currentHealth / (float)this.maxHealth, null));
    }

    @Override
    public void setAbsorption(float absorption) {
        if (absorption > 4.0f && FirstAidConfig.capMaxHealth) {
            absorption = 4.0f;
        }
        if (absorption > 32.0f) {
            absorption = 32.0f;
        }
        this.absorption = absorption;
        this.currentHealth = Math.min((float)this.maxHealth + absorption, this.currentHealth);
    }

    @Override
    public float getAbsorption() {
        return this.absorption;
    }

    @Override
    public void setMaxHealth(int maxHealth) {
        if (maxHealth > 12 && FirstAidConfig.capMaxHealth) {
            maxHealth = 12;
        }
        if (maxHealth > 128) {
            maxHealth = 128;
        }
        this.maxHealth = Math.max(2, maxHealth);
        this.currentHealth = Math.min(this.currentHealth, (float)this.maxHealth);
    }

    @Override
    public int getMaxHealth() {
        return this.maxHealth;
    }
}

