/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.firstaid.common.damagesystem;

import ichttt.mods.firstaid.FirstAid;
import ichttt.mods.firstaid.FirstAidConfig;
import ichttt.mods.firstaid.api.FirstAidRegistry;
import ichttt.mods.firstaid.api.damagesystem.AbstractDamageablePart;
import ichttt.mods.firstaid.api.damagesystem.AbstractPlayerDamageModel;
import ichttt.mods.firstaid.api.debuff.IDebuff;
import ichttt.mods.firstaid.api.enums.EnumDebuffSlot;
import ichttt.mods.firstaid.api.enums.EnumPlayerPart;
import ichttt.mods.firstaid.client.util.HealthRenderUtils;
import ichttt.mods.firstaid.common.CapProvider;
import ichttt.mods.firstaid.common.DataManagerWrapper;
import ichttt.mods.firstaid.common.EventHandler;
import ichttt.mods.firstaid.common.apiimpl.FirstAidRegistryImpl;
import ichttt.mods.firstaid.common.damagesystem.DamageablePart;
import ichttt.mods.firstaid.common.damagesystem.debuff.SharedDebuff;
import ichttt.mods.firstaid.common.network.MessageSyncDamageModel;
import ichttt.mods.firstaid.common.util.CommonUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.INBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.PacketDistributor;

public class PlayerDamageModel
extends AbstractPlayerDamageModel {
    private final Set<SharedDebuff> sharedDebuffs = new HashSet<SharedDebuff>();
    private int morphineTicksLeft = 0;
    private int sleepBlockTicks = 0;
    private float prevHealthCurrent = -1.0f;
    private float prevScaleFactor;
    private boolean waitingForHelp = false;
    private final boolean noCritical;
    private boolean needsMorphineUpdate = false;
    private int resyncTimer = -1;

    public static PlayerDamageModel create() {
        FirstAidRegistryImpl registry = FirstAidRegistryImpl.INSTANCE;
        IDebuff[] headDebuffs = ((FirstAidRegistry)registry).getDebuffs(EnumDebuffSlot.HEAD);
        IDebuff[] bodyDebuffs = ((FirstAidRegistry)registry).getDebuffs(EnumDebuffSlot.BODY);
        IDebuff[] armsDebuffs = ((FirstAidRegistry)registry).getDebuffs(EnumDebuffSlot.ARMS);
        IDebuff[] legFootDebuffs = ((FirstAidRegistry)registry).getDebuffs(EnumDebuffSlot.LEGS_AND_FEET);
        return new PlayerDamageModel(headDebuffs, bodyDebuffs, armsDebuffs, legFootDebuffs);
    }

    protected PlayerDamageModel(IDebuff[] headDebuffs, IDebuff[] bodyDebuffs, IDebuff[] armDebuffs, IDebuff[] legFootDebuffs) {
        super(new DamageablePart((Integer)FirstAidConfig.SERVER.maxHealthHead.get(), (Boolean)FirstAidConfig.SERVER.causeDeathHead.get(), EnumPlayerPart.HEAD, headDebuffs), new DamageablePart((Integer)FirstAidConfig.SERVER.maxHealthLeftArm.get(), false, EnumPlayerPart.LEFT_ARM, armDebuffs), new DamageablePart((Integer)FirstAidConfig.SERVER.maxHealthLeftLeg.get(), false, EnumPlayerPart.LEFT_LEG, legFootDebuffs), new DamageablePart((Integer)FirstAidConfig.SERVER.maxHealthLeftFoot.get(), false, EnumPlayerPart.LEFT_FOOT, legFootDebuffs), new DamageablePart((Integer)FirstAidConfig.SERVER.maxHealthBody.get(), (Boolean)FirstAidConfig.SERVER.causeDeathBody.get(), EnumPlayerPart.BODY, bodyDebuffs), new DamageablePart((Integer)FirstAidConfig.SERVER.maxHealthRightArm.get(), false, EnumPlayerPart.RIGHT_ARM, armDebuffs), new DamageablePart((Integer)FirstAidConfig.SERVER.maxHealthRightLeg.get(), false, EnumPlayerPart.RIGHT_LEG, legFootDebuffs), new DamageablePart((Integer)FirstAidConfig.SERVER.maxHealthRightFoot.get(), false, EnumPlayerPart.RIGHT_FOOT, legFootDebuffs));
        for (IDebuff debuff : armDebuffs) {
            this.sharedDebuffs.add((SharedDebuff)debuff);
        }
        for (IDebuff debuff : legFootDebuffs) {
            this.sharedDebuffs.add((SharedDebuff)debuff);
        }
        this.noCritical = (Boolean)FirstAidConfig.SERVER.causeDeathBody.get() == false && (Boolean)FirstAidConfig.SERVER.causeDeathHead.get() == false;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tagCompound = new NBTTagCompound();
        tagCompound.func_74782_a("head", this.HEAD.serializeNBT());
        tagCompound.func_74782_a("leftArm", this.LEFT_ARM.serializeNBT());
        tagCompound.func_74782_a("leftLeg", this.LEFT_LEG.serializeNBT());
        tagCompound.func_74782_a("leftFoot", this.LEFT_FOOT.serializeNBT());
        tagCompound.func_74782_a("body", this.BODY.serializeNBT());
        tagCompound.func_74782_a("rightArm", this.RIGHT_ARM.serializeNBT());
        tagCompound.func_74782_a("rightLeg", this.RIGHT_LEG.serializeNBT());
        tagCompound.func_74782_a("rightFoot", this.RIGHT_FOOT.serializeNBT());
        tagCompound.func_74757_a("hasTutorial", this.hasTutorial);
        return tagCompound;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.HEAD.deserializeNBT((INBTBase)((NBTTagCompound)nbt.func_74781_a("head")));
        this.LEFT_ARM.deserializeNBT((INBTBase)((NBTTagCompound)nbt.func_74781_a("leftArm")));
        this.LEFT_LEG.deserializeNBT((INBTBase)((NBTTagCompound)nbt.func_74781_a("leftLeg")));
        this.LEFT_FOOT.deserializeNBT((INBTBase)((NBTTagCompound)nbt.func_74781_a("leftFoot")));
        this.BODY.deserializeNBT((INBTBase)((NBTTagCompound)nbt.func_74781_a("body")));
        this.RIGHT_ARM.deserializeNBT((INBTBase)((NBTTagCompound)nbt.func_74781_a("rightArm")));
        this.RIGHT_LEG.deserializeNBT((INBTBase)((NBTTagCompound)nbt.func_74781_a("rightLeg")));
        this.RIGHT_FOOT.deserializeNBT((INBTBase)((NBTTagCompound)nbt.func_74781_a("rightFoot")));
        if (nbt.func_74764_b("morphineTicks")) {
            this.morphineTicksLeft = nbt.func_74762_e("morphineTicks");
            this.needsMorphineUpdate = true;
        }
        if (nbt.func_74764_b("hasTutorial")) {
            this.hasTutorial = nbt.func_74767_n("hasTutorial");
        }
    }

    @Override
    public void tick(World world, EntityPlayer player) {
        float newCurrentHealth;
        if (this.isDead(player)) {
            return;
        }
        world.field_72984_F.func_76320_a("FirstAidPlayerModel");
        if (this.sleepBlockTicks > 0) {
            --this.sleepBlockTicks;
        } else if (this.sleepBlockTicks < 0) {
            throw new RuntimeException("Negative sleepBlockTicks " + this.sleepBlockTicks);
        }
        float currentHealth = this.getCurrentHealth();
        if (currentHealth <= 0.0f) {
            FirstAid.LOGGER.error("Got {} health left, but isn't marked as dead!", (Object)Float.valueOf(currentHealth));
            world.field_72984_F.func_76319_b();
            return;
        }
        if (!world.field_72995_K && this.resyncTimer != -1) {
            --this.resyncTimer;
            if (this.resyncTimer == 0) {
                this.resyncTimer = -1;
                FirstAid.NETWORKING.send(PacketDistributor.PLAYER.with(() -> (EntityPlayerMP)player), (Object)new MessageSyncDamageModel(this));
            }
        }
        if (Float.isInfinite(newCurrentHealth = currentHealth / (float)this.getCurrentMaxHealth() * player.func_110138_aP())) {
            FirstAid.LOGGER.error("Error calculating current health: Value was infinite");
        } else {
            if (newCurrentHealth != this.prevHealthCurrent) {
                ((DataManagerWrapper)player.field_70180_af).set_impl(EntityPlayer.field_184632_c, Float.valueOf(newCurrentHealth));
            }
            this.prevHealthCurrent = newCurrentHealth;
        }
        if (!this.hasTutorial) {
            this.hasTutorial = CapProvider.tutorialDone.contains(player.func_200200_C_().getString());
        }
        this.runScaleLogic(player);
        if (this.needsMorphineUpdate) {
            player.func_195064_c(new PotionEffect(EventHandler.MORPHINE, this.morphineTicksLeft, 0, false, false));
        }
        PotionEffect morphine = player.func_70660_b(EventHandler.MORPHINE);
        if (!this.needsMorphineUpdate) {
            this.morphineTicksLeft = morphine == null ? 0 : morphine.func_76459_b();
        }
        this.needsMorphineUpdate = false;
        world.field_72984_F.func_76320_a("PartDebuffs");
        this.forEach(part -> part.tick(world, player, morphine == null));
        if (morphine == null && !world.field_72995_K) {
            this.sharedDebuffs.forEach(sharedDebuff -> sharedDebuff.tick(player));
        }
        world.field_72984_F.func_76319_b();
        world.field_72984_F.func_76319_b();
    }

    public static int getRandMorphineDuration() {
        return EventHandler.rand.nextInt(5) * 20 * 15 + 4200;
    }

    @Override
    @Deprecated
    public void applyMorphine() {
        this.morphineTicksLeft = PlayerDamageModel.getRandMorphineDuration();
        this.needsMorphineUpdate = true;
    }

    @Override
    public void applyMorphine(EntityPlayer player) {
        player.func_195064_c(new PotionEffect(EventHandler.MORPHINE, PlayerDamageModel.getRandMorphineDuration(), 0, false, false));
    }

    @Override
    @Deprecated
    public int getMorphineTicks() {
        return this.morphineTicksLeft;
    }

    @Override
    @Nonnull
    public Iterator<AbstractDamageablePart> iterator() {
        return new Iterator<AbstractDamageablePart>(){
            byte count = 1;

            @Override
            public boolean hasNext() {
                return this.count <= 8;
            }

            @Override
            public AbstractDamageablePart next() {
                if (this.count > 8) {
                    throw new NoSuchElementException();
                }
                AbstractDamageablePart part = PlayerDamageModel.this.getFromEnum(EnumPlayerPart.fromID(this.count));
                this.count = (byte)(this.count + 1);
                return part;
            }
        };
    }

    @Override
    public float getCurrentHealth() {
        float currentHealth = 0.0f;
        for (AbstractDamageablePart part : this) {
            currentHealth += part.currentHealth;
        }
        return currentHealth;
    }

    @Override
    public boolean isDead(@Nullable EntityPlayer player) {
        if (player != null && !player.func_70089_S()) {
            return true;
        }
        if (this.noCritical) {
            boolean dead = true;
            for (AbstractDamageablePart part : this) {
                if (!(part.currentHealth > 0.0f)) continue;
                dead = false;
                break;
            }
            return dead;
        }
        for (AbstractDamageablePart part : this) {
            if (!part.canCauseDeath || !(part.currentHealth <= 0.0f)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Float getAbsorption() {
        float value = 0.0f;
        for (AbstractDamageablePart part : this) {
            value += part.getAbsorption();
        }
        return Float.valueOf(value);
    }

    @Override
    public void setAbsorption(float absorption) {
        float newAbsorption = absorption / 8.0f;
        this.forEach(damageablePart -> damageablePart.setAbsorption(newAbsorption));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public int getMaxRenderSize() {
        int max = 0;
        for (AbstractDamageablePart part : this) {
            int newMax = FirstAidConfig.overlay.overlayMode == FirstAidConfig.Overlay.OverlayMode.NUMBERS ? Minecraft.func_71410_x().field_71466_p.func_78256_a(HealthRenderUtils.TEXT_FORMAT.format(part.currentHealth) + "/" + part.getMaxHealth()) + 1 : (int)((float)((int)((float)part.getMaxHealth() + part.getAbsorption() + 0.9999f) + 1) / 2.0f * 9.0f);
            max = Math.max(max, newMax);
        }
        return max;
    }

    @Override
    public void sleepHeal(EntityPlayer player) {
        if (this.sleepBlockTicks > 0) {
            return;
        }
        CommonUtils.healPlayerByPercentage((Double)FirstAidConfig.SERVER.sleepHealPercentage.get(), this, player);
        this.sleepBlockTicks = 20;
    }

    @Override
    public int getCurrentMaxHealth() {
        int maxHealth = 0;
        for (AbstractDamageablePart part : this) {
            maxHealth += part.getMaxHealth();
        }
        return maxHealth;
    }

    @Override
    public void stopWaitingForHelp(EntityPlayer player) {
        if (FirstAidConfig.debug) {
            FirstAid.LOGGER.info("Help waiting done!");
        }
        if (!this.waitingForHelp) {
            FirstAid.LOGGER.warn("Player {} not waiting for help!", (Object)player.func_200200_C_());
        }
        this.waitingForHelp = false;
    }

    @Override
    public boolean isWaitingForHelp() {
        return this.waitingForHelp;
    }

    @Override
    @Deprecated
    public void onNotHelped(EntityPlayer player) {
        this.stopWaitingForHelp(player);
    }

    @Override
    @Deprecated
    public void onHelpedUp(EntityPlayer player) {
        this.stopWaitingForHelp(player);
        this.revivePlayer(player);
    }

    @Override
    public void revivePlayer(EntityPlayer player) {
        if (FirstAidConfig.debug) {
            CommonUtils.debugLogStacktrace("Reviving player");
        }
        player.revive();
        for (AbstractDamageablePart part : this) {
            if (!part.canCauseDeath && !this.noCritical || !(part.currentHealth <= 0.0f)) continue;
            part.currentHealth = 1.0f;
        }
        if (!player.field_70170_p.field_72995_K && player instanceof EntityPlayerMP) {
            FirstAid.NETWORKING.send(PacketDistributor.PLAYER.with(() -> (EntityPlayerMP)player), (Object)new MessageSyncDamageModel(this));
        }
    }

    @Override
    public void runScaleLogic(EntityPlayer player) {
        if (FirstAidConfig.scaleMaxHealth) {
            player.field_70170_p.field_72984_F.func_76320_a("healthscaling");
            float globalFactor = player.func_110138_aP() / 20.0f;
            if (this.prevScaleFactor != globalFactor) {
                if (FirstAidConfig.debug) {
                    FirstAid.LOGGER.info("Starting health scaling factor {} -> {} (max health {})", (Object)Float.valueOf(this.prevScaleFactor), (Object)Float.valueOf(globalFactor), (Object)Float.valueOf(player.func_110138_aP()));
                }
                player.field_70170_p.field_72984_F.func_76320_a("distribution");
                int reduced = 0;
                int added = 0;
                float expectedNewMaxHealth = 0.0f;
                int newMaxHealth = 0;
                for (AbstractDamageablePart part : this) {
                    float floatResult = (float)part.initialMaxHealth * globalFactor;
                    expectedNewMaxHealth += floatResult;
                    int result = (int)floatResult;
                    if (result % 2 == 1) {
                        int partMaxHealth = part.getMaxHealth();
                        if (part.currentHealth < (float)partMaxHealth && reduced < 4) {
                            --result;
                            ++reduced;
                        } else if (part.currentHealth > (float)partMaxHealth && added < 4) {
                            ++result;
                            ++added;
                        } else if (reduced > added) {
                            ++result;
                            ++added;
                        } else {
                            --result;
                            ++reduced;
                        }
                    }
                    newMaxHealth += result;
                    if (FirstAidConfig.debug) {
                        FirstAid.LOGGER.info("Part {} max health: {} initial; {} old; {} new", (Object)part.part.name(), (Object)part.initialMaxHealth, (Object)part.getMaxHealth(), (Object)result);
                    }
                    part.setMaxHealth(result);
                }
                player.field_70170_p.field_72984_F.func_76318_c("correcting");
                if (Math.abs(expectedNewMaxHealth - (float)newMaxHealth) >= 2.0f) {
                    if (FirstAidConfig.debug) {
                        FirstAid.LOGGER.info("Entering second stage - diff {}", (Object)Float.valueOf(Math.abs(expectedNewMaxHealth - (float)newMaxHealth)));
                    }
                    ArrayList<AbstractDamageablePart> prioList = new ArrayList<AbstractDamageablePart>();
                    for (AbstractDamageablePart part : this) {
                        prioList.add(part);
                    }
                    prioList.sort(Comparator.comparingInt(AbstractDamageablePart::getMaxHealth));
                    for (AbstractDamageablePart part : prioList) {
                        int maxHealth = part.getMaxHealth();
                        if (FirstAidConfig.debug) {
                            FirstAid.LOGGER.info("Part {}: Second stage with total diff {}", (Object)part.part.name(), (Object)Float.valueOf(Math.abs(expectedNewMaxHealth - (float)newMaxHealth)));
                        }
                        if (expectedNewMaxHealth > (float)newMaxHealth) {
                            part.setMaxHealth(maxHealth + 2);
                            newMaxHealth += part.getMaxHealth() - maxHealth;
                        } else if (expectedNewMaxHealth < (float)newMaxHealth) {
                            part.setMaxHealth(maxHealth - 2);
                            newMaxHealth -= maxHealth - part.getMaxHealth();
                        }
                        if (!(Math.abs(expectedNewMaxHealth - (float)newMaxHealth) < 2.0f)) continue;
                        break;
                    }
                }
                player.field_70170_p.field_72984_F.func_76319_b();
            }
            this.prevScaleFactor = globalFactor;
            player.field_70170_p.field_72984_F.func_76319_b();
        }
    }

    @Override
    public void scheduleResync() {
        if (this.resyncTimer == -1) {
            this.resyncTimer = 2;
        } else {
            FirstAid.LOGGER.warn("resync already scheduled!");
        }
    }

    @Override
    public boolean hasNoCritical() {
        return this.noCritical;
    }
}

