/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.firstaid.common.damagesystem.distribution;

import ichttt.mods.firstaid.FirstAid;
import ichttt.mods.firstaid.FirstAidConfig;
import ichttt.mods.firstaid.api.IDamageDistribution;
import ichttt.mods.firstaid.api.damagesystem.AbstractDamageablePart;
import ichttt.mods.firstaid.api.damagesystem.AbstractPlayerDamageModel;
import ichttt.mods.firstaid.api.enums.EnumPlayerPart;
import ichttt.mods.firstaid.api.event.FirstAidLivingDamageEvent;
import ichttt.mods.firstaid.common.damagesystem.PlayerDamageModel;
import ichttt.mods.firstaid.common.damagesystem.distribution.RandomDamageDistribution;
import ichttt.mods.firstaid.common.network.MessageReceiveDamage;
import ichttt.mods.firstaid.common.util.ArmorUtils;
import ichttt.mods.firstaid.common.util.CommonUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.nbt.INBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.util.DamageSource;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.network.PacketDistributor;
import org.apache.commons.lang3.tuple.Pair;

public abstract class DamageDistribution
implements IDamageDistribution {
    public static void handleDamageTaken(IDamageDistribution damageDistribution, AbstractPlayerDamageModel damageModel, float damage, @Nonnull EntityPlayer player, @Nonnull DamageSource source, boolean addStat, boolean redistributeIfLeft) {
        float left;
        if (FirstAidConfig.debug) {
            FirstAid.LOGGER.info("Damaging {} using {} for dmg source {}, redistribute {}, addStat {}", (Object)Float.valueOf(damage), (Object)damageDistribution.toString(), (Object)source.field_76373_n, (Object)redistributeIfLeft, (Object)addStat);
        }
        NBTTagCompound beforeCache = (NBTTagCompound)damageModel.serializeNBT();
        if ((damage = ArmorUtils.applyGlobalPotionModifiers(player, source, damage)) != 0.0f) {
            player.func_71020_j(source.func_76345_d());
            float currentHealth = player.func_110143_aJ();
            player.func_110142_aN().func_94547_a(source, currentHealth, damage);
        }
        if ((left = damageDistribution.distributeDamage(damage, player, source, addStat)) > 0.0f && redistributeIfLeft) {
            damageDistribution = RandomDamageDistribution.NEAREST_KILL;
            left = damageDistribution.distributeDamage(left, player, source, addStat);
        }
        PlayerDamageModel before = PlayerDamageModel.create();
        before.deserializeNBT(beforeCache);
        if (MinecraftForge.EVENT_BUS.post((Event)new FirstAidLivingDamageEvent(player, damageModel, before, source, left))) {
            damageModel.deserializeNBT((INBTBase)beforeCache);
            return;
        }
        if (damageModel.isDead(player)) {
            CommonUtils.killPlayer(player, source);
        }
    }

    protected float minHealth(@Nonnull EntityPlayer player, @Nonnull AbstractDamageablePart part) {
        return 0.0f;
    }

    protected float distributeDamageOnParts(float damage, @Nonnull AbstractPlayerDamageModel damageModel, @Nonnull EnumPlayerPart[] enumParts, @Nonnull EntityPlayer player, boolean addStat) {
        ArrayList<AbstractDamageablePart> damageableParts = new ArrayList<AbstractDamageablePart>(enumParts.length);
        for (EnumPlayerPart part : enumParts) {
            damageableParts.add(damageModel.getFromEnum(part));
        }
        Collections.shuffle(damageableParts);
        for (AbstractDamageablePart part : damageableParts) {
            float minHealth = this.minHealth(player, part);
            FirstAid.NETWORKING.send(PacketDistributor.PLAYER.with(() -> (EntityPlayerMP)player), (Object)new MessageReceiveDamage(part.part, damage, minHealth));
            float dmgDone = damage - part.damage(damage, player, damageModel.getMorphineTicks() == 0, minHealth);
            if (addStat) {
                player.func_195067_a(StatList.field_188112_z, Math.round(dmgDone * 10.0f));
            }
            if ((damage -= dmgDone) == 0.0f) break;
            if (!(damage < 0.0f)) continue;
            FirstAid.LOGGER.error("Got negative damage {} left? Logic error? ", (Object)Float.valueOf(damage));
            break;
        }
        return damage;
    }

    @Nonnull
    protected abstract List<Pair<EntityEquipmentSlot, EnumPlayerPart[]>> getPartList();

    @Override
    public float distributeDamage(float damage, @Nonnull EntityPlayer player, @Nonnull DamageSource source, boolean addStat) {
        AbstractPlayerDamageModel damageModel = CommonUtils.getDamageModel(player);
        for (Pair<EntityEquipmentSlot, EnumPlayerPart[]> pair : this.getPartList()) {
            EntityEquipmentSlot slot = (EntityEquipmentSlot)pair.getLeft();
            damage = ArmorUtils.applyArmor(player, player.func_184582_a(slot), source, damage, slot);
            if (damage <= 0.0f) {
                return 0.0f;
            }
            damage = ArmorUtils.applyEnchantmentModifiers(player.func_184582_a(slot), source, damage);
            if (damage <= 0.0f) {
                return 0.0f;
            }
            if ((damage = ForgeHooks.onLivingDamage((EntityLivingBase)player, (DamageSource)source, (float)damage)) <= 0.0f) {
                return 0.0f;
            }
            if ((damage = this.distributeDamageOnParts(damage, damageModel, (EnumPlayerPart[])pair.getRight(), player, addStat)) != 0.0f) continue;
            break;
        }
        return damage;
    }
}

