/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.firstaid.common.damagesystem.distribution;

import ichttt.mods.firstaid.FirstAid;
import ichttt.mods.firstaid.api.damagesystem.AbstractDamageablePart;
import ichttt.mods.firstaid.api.damagesystem.AbstractPlayerDamageModel;
import ichttt.mods.firstaid.api.enums.EnumPlayerPart;
import ichttt.mods.firstaid.common.network.MessageAddHealth;
import ichttt.mods.firstaid.common.util.CommonUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.network.PacketDistributor;

public class HealthDistribution {
    private static final List<EnumPlayerPart> parts;

    public static void manageHealth(float health, AbstractPlayerDamageModel damageModel, EntityPlayer player, boolean sendChanges, boolean distribute) {
        if (sendChanges && player.field_70170_p.field_72995_K) {
            FirstAid.LOGGER.catching((Throwable)new RuntimeException("Someone set flag sendChanges on the client, this is not supported!"));
            sendChanges = false;
        } else if (sendChanges && !(player instanceof EntityPlayerMP)) {
            sendChanges = false;
        }
        float toHeal = distribute ? health / 8.0f : health;
        Collections.shuffle(parts, player.field_70170_p.field_73012_v);
        ArrayList<AbstractDamageablePart> damageableParts = new ArrayList<AbstractDamageablePart>(parts.size());
        for (EnumPlayerPart part : parts) {
            damageableParts.add(damageModel.getFromEnum(part));
        }
        if (distribute) {
            damageableParts.sort(Comparator.comparingDouble(value -> (float)value.getMaxHealth() - value.currentHealth));
        }
        float[] healingDone = new float[8];
        for (int i = 0; i < 8; ++i) {
            AbstractDamageablePart part = (AbstractDamageablePart)damageableParts.get(i);
            float diff = toHeal - part.heal(toHeal, player, !player.field_70170_p.field_72995_K);
            healingDone[part.part.id - 1] = diff = (float)Math.round(diff * 10000.0f) / 10000.0f;
            health -= diff;
            if (distribute) {
                if (i >= 7) continue;
                toHeal = health / (7.0f - (float)i);
                continue;
            }
            if ((toHeal -= diff) <= 0.0f) break;
        }
        if (sendChanges) {
            FirstAid.NETWORKING.send(PacketDistributor.PLAYER.with(() -> (EntityPlayerMP)player), (Object)new MessageAddHealth(healingDone));
        }
    }

    public static void distributeHealth(float health, EntityPlayer player, boolean sendChanges) {
        AbstractPlayerDamageModel damageModel = CommonUtils.getDamageModel(player);
        HealthDistribution.manageHealth(health, damageModel, player, sendChanges, true);
    }

    public static void addRandomHealth(float health, EntityPlayer player, boolean sendChanges) {
        AbstractPlayerDamageModel damageModel = CommonUtils.getDamageModel(player);
        HealthDistribution.manageHealth(health, damageModel, player, sendChanges, false);
    }

    static {
        EnumPlayerPart[] partArray = EnumPlayerPart.VALUES;
        parts = new ArrayList<EnumPlayerPart>(partArray.length);
        parts.addAll(Arrays.asList(partArray));
    }
}

