/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.firstaid.common.network;

import ichttt.mods.firstaid.api.damagesystem.AbstractPlayerDamageModel;
import ichttt.mods.firstaid.api.enums.EnumPlayerPart;
import ichttt.mods.firstaid.common.util.CommonUtils;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageAddHealth {
    private final float[] table;

    public MessageAddHealth(PacketBuffer buffer) {
        this.table = new float[8];
        for (int i = 0; i < 8; ++i) {
            this.table[i] = buffer.readFloat();
        }
    }

    public MessageAddHealth(float[] table) {
        this.table = table;
    }

    public void encode(PacketBuffer buf) {
        for (float f : this.table) {
            buf.writeFloat(f);
        }
    }

    public static class Handler {
        public static void onMessage(MessageAddHealth message, Supplier<NetworkEvent.Context> supplier) {
            NetworkEvent.Context ctx = supplier.get();
            CommonUtils.checkClient(ctx);
            ctx.enqueueWork(() -> {
                EntityPlayerSP playerSP = Minecraft.func_71410_x().field_71439_g;
                AbstractPlayerDamageModel damageModel = CommonUtils.getDamageModel((EntityPlayer)playerSP);
                for (int i = 0; i < message.table.length; ++i) {
                    float f = message.table[i];
                    EnumPlayerPart part = EnumPlayerPart.fromID(i + 1);
                    damageModel.getFromEnum(part).heal(f, (EntityPlayer)playerSP, false);
                }
            });
        }
    }
}

