/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.firstaid.common.network;

import ichttt.mods.firstaid.FirstAid;
import ichttt.mods.firstaid.api.damagesystem.AbstractDamageablePart;
import ichttt.mods.firstaid.api.damagesystem.AbstractPartHealer;
import ichttt.mods.firstaid.api.damagesystem.AbstractPlayerDamageModel;
import ichttt.mods.firstaid.api.enums.EnumPlayerPart;
import ichttt.mods.firstaid.common.apiimpl.FirstAidRegistryImpl;
import ichttt.mods.firstaid.common.util.CommonUtils;
import java.util.function.Supplier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageApplyHealingItem {
    private final EnumPlayerPart part;
    private final EnumHand hand;

    public MessageApplyHealingItem(PacketBuffer buffer) {
        this.part = EnumPlayerPart.fromID(buffer.readByte());
        this.hand = buffer.readBoolean() ? EnumHand.MAIN_HAND : EnumHand.OFF_HAND;
    }

    public MessageApplyHealingItem(EnumPlayerPart part, EnumHand hand) {
        this.part = part;
        this.hand = hand;
    }

    public void encode(PacketBuffer buf) {
        buf.writeByte((int)this.part.id);
        buf.writeBoolean(this.hand == EnumHand.MAIN_HAND);
    }

    public static class Handler {
        public static void onMessage(MessageApplyHealingItem message, Supplier<NetworkEvent.Context> supplier) {
            NetworkEvent.Context ctx = supplier.get();
            EntityPlayerMP player = CommonUtils.checkServer(ctx);
            ctx.enqueueWork(() -> {
                AbstractPlayerDamageModel damageModel = CommonUtils.getDamageModel((EntityPlayer)player);
                ItemStack stack = player.func_184586_b(message.hand);
                Item item = stack.func_77973_b();
                AbstractPartHealer healer = FirstAidRegistryImpl.INSTANCE.getPartHealer(stack);
                if (healer == null) {
                    FirstAid.LOGGER.warn("Player {} has invalid item in hand {} while it should be an healing item", (Object)player.func_200200_C_(), (Object)item.getRegistryName());
                    player.func_145747_a((ITextComponent)new TextComponentString("Unable to apply healing item!"));
                    return;
                }
                stack.func_190918_g(1);
                AbstractDamageablePart damageablePart = damageModel.getFromEnum(message.part);
                damageablePart.activeHealer = healer;
            });
        }
    }
}

